#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "ks_game.h"
#include "entime.h"

static int near virtual_move( void );
static void near save_position(void);
static void near restore_position(void);

POSITION pos_buf={0};

static MOVE old_previous;
static int old_last_repeated;
static int old_last_to_repeat;
static int old_pos_repeated;
static int old_drawflag;

MOVE kaissa_move;
MOVE bestanswer={DUMMY,DUMMY,'\0',0};
MOVE bestanswer0={DUMMY,DUMMY,'\0',0};
MOVE bestanswer1;
int answer_ready;  /* Answer ready to best enemy answer. */

void think_enemy_time( void )
{
MOVE *movep;
/*  movedata(1,2,3,4,5);*/
  answer_ready=0;
  enemy_move_done=0;
  enemy_move_exist=0;
  thinktime=ENEMYTIME; /*putinfo( 2, 3, "Enemy time" );*/
  movecpy(&bestanswer,&bestanswer0);
  if(!move_exist(&bestanswer)){
	thinktime=MYTIME; /*putinfo( 2, 3, "Kaissa time" );*/
	return;
  }
  save_position();
  CURRENT=&bestanswer;
  virtual_move();
  movep=get_move();
  movecpy(&kaissa_move,movep);
  if (move_exist(movep) && (!breakflag || breakflag==TIMEBREAK))
      answer_ready=1;
  else {
	clear_move( &bestanswer );
	answer_ready=0;
  }
  if( !enemy_move_done ) restore_position();
/*  if (debug_flag) closewindow(reply); W.K.temp*/
  thinktime=MYTIME; /*putinfo( 2, 3, "Kaissa time" );*/
}

static void near save_position(void)
{
  MEMCPY(&pos_buf,pos_stk,sizeof(POSITION));
  movecpy(&old_previous,move_stk);
  old_last_repeated=last_repeated;
  old_last_to_repeat=last_to_repeat;
  old_pos_repeated=pos_repeated;
  old_drawflag=drawflag;
}
static void near restore_position(void)
{
  pos_sp=pos_stk; level=0;  /* AD 15 june 90 reset stacks */
  MEMCPY(pos_stk, &(pos_buf), sizeof(POSITION));
  movecpy(move_stk,&old_previous);
  last_repeated=old_last_repeated;
  last_to_repeat=old_last_to_repeat;
  pos_repeated=old_pos_repeated;
  drawflag=old_drawflag;
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
}
static int near virtual_move( void )
{
  movecpy(move_stk,CURRENT); /* save making move in stack */
  if(move()){    /* Move is not legal. */
    move_back();
    return(-1);
  }
  MEMCPY( pos_stk, pos_stk+1, sizeof(POSITION) );
  Our_color=MOVE_COLOR;
  Enemy_color=reverse_color(Our_color);
  PREVIOUS=move_stk;
  change_repeated();
  return(1);
}

