#include <mem.h>
#include <dos.h>
#include <string.h>
#include "lang.h"
#include "ems.h"
#include "proc.h"
#include "facelib.h"

#define  EMS_PAGE_SIZE    (16*1024)       /*  16K */
#define  EMS_INT          (0x67)
static char far* EMS_physical_address;
static int handle=0;
static int curr_log_page=-1; 
long EMS_memory_size;

static int near map_memory(int physical_page,int logical_page,int handle);
static int near get_EMS_memory_size(long *sizep );
static int near get_physical_segment_addres(char far ** addrp);
static int near open_EMM_handle( int page_num,int *handlep);
static int near close_EMM_handle(int handle);
/*static int near count_active_handles(void);*/

int NEAR EMS_write(long number,void far *src,int lenght){
char far* dst; 
  if( (dst=EMS_access(number*lenght))!=NULL ){
    ks_farmemcpy(dst, src, lenght);
    return(0);
  }
  return(1);
}

int NEAR EMS_read(long number,void far *dst,int lenght){
char far *src;
  if( (src=EMS_access(number*lenght))!=NULL ){
    ks_farmemcpy(dst, src, lenght);
    return(0);
  }
  return(1);
}

void far* NEAR EMS_access(long relation_address){
int remainder,quoter;
  quoter=(int)(relation_address >> 14);         /*    / EMS_PAGE_SIZE  */
  remainder=(int)relation_address & 0x3FFF;     /*    % EMS_PAGE_SIZE  */
  if( quoter !=curr_log_page ){
    map_memory(0,quoter,handle);           /* No error handled */
    curr_log_page=quoter;
  }
  return ( EMS_physical_address+remainder);
}

int NEAR EMS_init(long size)       /* return(1) if error */
{
/*int i=0;*/
char *EMS_device="EMMXXXX0", far * device_name_ptr;
  device_name_ptr=MK_FP(*(unsigned far *)MK_FP(0,(EMS_INT<<2)+2),10);
  if( FARSTRNCMP(EMS_device,device_name_ptr,strlen(EMS_device)) ) return(1);
  /*i|=*/get_physical_segment_addres( &EMS_physical_address );
  if ( handle ) return (0); /* Memory was allocated earler */
  /*i|=*/get_EMS_memory_size( &EMS_memory_size );
  if(EMS_memory_size <= 0) return(1);

  if(EMS_memory_size>size) EMS_memory_size=size;


  /*i|=*/open_EMM_handle( (int)((EMS_memory_size+EMS_PAGE_SIZE-1) / EMS_PAGE_SIZE)
                          , &handle );
  return ( handle<=0 );
}

int NEAR EMS_reset(void)
{
  curr_log_page=-1;
  if( handle>0 ){
    close_EMM_handle(handle);
    handle=0;
    return 1;
  }
  return 0;
}

void NEAR EMS_clear( long size ,char c, int off, int step)
{
long i;
int j,jmax;
char far * adr;
  jmax=EMS_PAGE_SIZE/step;
  for(i=0;i<size;i+=EMS_PAGE_SIZE){
    adr=(CFP)EMS_access(i)+off;
    for(j=0; j<jmax; j++) *(adr+=step)=c;
  }
}

static int near map_memory(int physical_page,int logical_page,int handle)
{
union REGS reg;

  reg.h.ah=0x44;
  reg.h.al=physical_page;
  reg.x.bx=logical_page;
  reg.x.dx=handle;
  int86(EMS_INT,&reg,&reg);
  return(reg.x.ax);
}

static int near get_physical_segment_addres(char far ** addrp)
{
union REGS reg;

  reg.h.ah=0x41;
  int86(EMS_INT,&reg,&reg);
  *addrp=MK_FP(reg.x.bx,0);
  return(reg.x.ax);
}

static int near get_EMS_memory_size(long *page_num)
{
union REGS reg;

  reg.h.ah=0x42;
  int86(EMS_INT,&reg,&reg);
  *page_num=reg.x.bx * (long)EMS_PAGE_SIZE;
  return(reg.x.ax);
}

static int near open_EMM_handle( int page_num ,int *handlep)
{
union REGS reg;

  reg.h.ah=0x43;
  reg.x.bx=page_num;
  int86(EMS_INT,&reg,&reg);
  *handlep=reg.x.dx;
  return(reg.x.ax);
}

/*static int near count_active_handles(void)   /* ???????????? */
{
union REGS reg;

  reg.h.ah=0x4c;
  int86(EMS_INT,&reg,&reg);
  return(reg.x.bx);
} */

static int near close_EMM_handle(int handle)
{
union REGS reg;

  reg.h.ah=0x45;
  reg.x.dx=handle;
  int86(EMS_INT,&reg,&reg);
  return(reg.x.ax);
}
/*
void main ()
{
char x='a';
int i;
struct time t,t1;
char far *src;
  EMS_init(10000);
  gettime(&t);
  for (i=0;i<10000;i++)
/*    EMS_write(10000,&x,1);*/
      src=EMS_access(10000); 
/*      map_memory(0,6,handle);*/
  gettime(&t1);
  x='b';
  EMS_read(10000,&x,1);
  EMS_reset();
}*/

