/*  4 nov 90

	Draw pieces in hi-CGA graphics mode

*/

#include <stdio.h>
#include <io.h>
#include <fcntl.h>
#include <alloc.h>

#include "lang.h"
#include "chess.h"
#include "ks_macro.h"

#define CGA_MODE 1
#if CGA_MODE /************** CGA Graphics **********************/

#define FONTSIZE   8
enum putimage_ops {		/* BitBlt operators for putimage */
	COPY_PUT,		/* MOV */
	XOR_PUT,		/* XOR */
	OR_PUT, 		/* OR  */
	AND_PUT,		/* AND */
	NOT_PUT 		/* NOT */
};
void resetgraph( void );
char far pieceimagefont[80]="ch~0808g.scf";

#else /*************** Hercules Graphics ******************/

#define FONTSIZE   14
#include <graphics.h>
char far pieceimagefont[80]="ch~0814g.scf";

#endif /****************************************************/

#define CELL_PIECE 6
#define PIECE_IMAGE_SIZE  (FONTSIZE*CELL_PIECE)

static char far *pieceimage;
static char far *piecebkground;
static char far *smallpieceimage;
static char far bkground[]=
	{0x22,0x88,0x22,0x88,0x22,0x88,0x22,0x88,
	0x22,0x88,0x22,0x88,0x22,0x88};
static char far whitesq[ 4+FONTSIZE*5*2 ] ={ 5,0,2,0 };
static char far blacksq[ 4+FONTSIZE*5*2 ] ={ 5,0,2,0 };

void installgraph( void );
int loadbetafile( char far *fname, int first, int last, int fontsize, char far *mem );
int loadgrfont( void );
void put_image( int col, int row, void far *image, int putoption );
void gputch( int col, int row, int ch, int putopt );
void gputstr( int col, int row, char far *str, int len, int putopt );
void gr_drawpiece( int col, int row,
				PIECE_NAME piece, PIECE_COLOR color, PIECE_COLOR sqcolor );

static void near setimage(    void far *image, char byte );
static void near fillimage(   void far *image, char far *patp );
static void near andnotimage( void far *image, char far *patp );
static void near orimage(     void far *image, char far *patp );

int loadpieceimage( void )
{
	pieceimage=farcalloc( 128*FONTSIZE, 1 ); /* allocate memory */
	if( !pieceimage )
		return(-1);
	if( loadbetafile( pieceimagefont, 128, 256, FONTSIZE, pieceimage )==-1 )
		return(-1);
	piecebkground=pieceimage+NPIECE*PIECE_IMAGE_SIZE;
	smallpieceimage=piecebkground+NPIECE*PIECE_IMAGE_SIZE;
	fillimage( whitesq, bkground );
	return(0);
}

static void near setimage( void far *image, char byte )
{
  char far *cfp;
  int imagesize, i;

	cfp=image; cfp+=4;
	imagesize= FONTSIZE*(*(int far *)image)*( *((int far *)image+1));
	for( i=0; i<imagesize; i++ )
		*cfp++=byte;
}

static void near fillimage( void far *image, char far *patp )
{
  char far *cfp;
  int imagesize, i;

	cfp=image; cfp+=4;
	imagesize= FONTSIZE*(*(int far *)image)*( *((int far *)image+1));
	for( i=0; i<imagesize; i++ )
		*cfp++=patp[i%FONTSIZE];
}

static void near andnotimage( void far *image, char far *patp )
{
  char far *cfp;
  int imagesize, i;

	cfp=image; cfp+=4;
	imagesize= FONTSIZE*(*(int far *)image)*( *((int far *)image+1));
	for( i=0; i<imagesize; i++ )
		*cfp++ &= ~*patp++;
}

static void near orimage( void far *image, char far *patp )
{
  char far *cfp;
  int imagesize, i;

	cfp=image; cfp+=4;
	imagesize= FONTSIZE*(*(int far *)image)*( *((int far *)image+1));
	for( i=0; i<imagesize; i++ )
		*cfp++ |= *patp++;
}

void gr_drawsquare( int col, int row, PIECE_COLOR color )
{
  void far *sqimage;
	if( color==WHITE_PIECE ) sqimage=whitesq;
	else sqimage=blacksq;
	put_image( col, row, sqimage, COPY_PUT );
}

void gr_drawpiece( col, row, piece, color, sqcolor )
int col, row;
PIECE_NAME piece;
PIECE_COLOR color, sqcolor;
{
  char buff[ 4 + PIECE_IMAGE_SIZE ]={3,0,2,0};
  char far *pbkgr, far *pimage;

	setimage( buff, 0 );
	pbkgr=piecebkground+(piece-1)*PIECE_IMAGE_SIZE;
	pimage=pieceimage+(piece-1)*PIECE_IMAGE_SIZE;

	if( sqcolor==WHITE_PIECE ){
		fillimage( buff, bkground );
		if( color==WHITE_PIECE ){
			andnotimage( buff, pbkgr );
			orimage( buff, pimage );
		} else {
			orimage( buff, pbkgr );
			andnotimage( buff, pimage );
		}
	} else {
		if( color==WHITE_PIECE ){
			orimage( buff, pimage );
		} else {
			orimage( buff, pbkgr );
			andnotimage( buff, pimage );
		}
	}
	put_image( col, row, buff, COPY_PUT );
}


void gr_drawboard( int col, int row )
{
  int file, line;
	for( file=0; file<LINELEN; file++ )
		for( line=0; line<LINELEN; line++ ){
			gr_drawsquare( col+5*file, row+2*line,
				SQISWHITE( file, line )? BLACK_PIECE:WHITE_PIECE );
		}
}

void gr_clearframe( int col, int row, PIECE_COLOR color )
{
  char far *sqimage;
	if( color==WHITE_PIECE ) sqimage=whitesq;
	else sqimage=blacksq;
	*sqimage=1;  /* set new width  */
	put_image( col, row, sqimage, COPY_PUT );
	put_image( col+4, row, sqimage, COPY_PUT );
	*sqimage=5;  /* restore old width  */
}

/*
main()
{
int i,j;
char buff[ 4 + PIECE_IMAGE_SIZE ]={1,0,1,0};

	installgraph();
	loadpieceimage();
	for( j=0; j<4; j++ ){
		for( i=KING; i<PAWN+1; i++ )
			gr_drawpiece( 7*i, 2*(j+1), i, ODD(j), HALF(j) );
	}
	for( i=KING; i<PAWN+1; i++ ){
		fillimage( buff, smallpieceimage+(i-1)*FONTSIZE );
		put_image( 1+2*i, 15, buff, COPY_PUT );
	}

	gr_drawboard( 1,3 );
	getch();
	resetgraph();
	return(0);
}
*/