#include "dos.h"       /* delay() */
#include "string.h"
#include "stdlib.h"
#include "io.h"        /* lseek(), SEEK_SET */

#include "facedemo.h"
#include "facelib.h"
#include "facekeys.h"
#include "facemous.h"

		     /* Types definitions */
typedef struct{
  char *name;
  int key;
} KEYTABLE;
typedef struct{
  char *name;
  int key;
} MOUSEKEYTABLE;

			  /* Defines */
#define DEFAULTDELAY 500
#define DEMOBUFSIZE 500
#define MOUSEDELAY 400 /* milliseconds */

			 /* Variables */

char demobuf[500]="@", *demobufp=demobuf;
int demobufflag=0;
int demo=0;
int demofile=-1;
static int mousex=40, mousey=11;

KEYTABLE keytable[]={
	{"F1",F1}, {"F1",F2}, {"F3",F3},
	{"F4",F4}, {"F5",F5}, {"F6",F6},
	{"F7",F7}, {"F8",F8}, {"F9",F9},
	{"F10",F10},

	{"ESCAPE",ESCAPE},
	{"RETURN",RETURN}, {"ENTER",ENTER},
	{"BACKSPACE",BACKSPACE},
	{"SPACE",SPACE},

	{"HOME",HOME}, {"UPARROW",UPARROW}, {"PGUP",PGUP},
	{"LEFTARROW",LEFTARROW}, {"RIGHTARROW",RIGHTARROW},
	{"END",END}, {"DOWNARROW",DOWNARROW}, {"PGDOWN",PGDOWN},
	{"INS",INS}, {"DEL",DEL}, {"TAB",TAB},

	{"ALT_B",ALT_B},
	{"ALT_V",ALT_V},
	{"NULLKEY",0}
};

MOUSEKEYTABLE mousetable[]={
	{"LP",LEFTPRESS}, {"LR",LEFTRELEAS},
	{"RP",RIGHTPRESS}, {"RR",RIGHTRELEAS},
	{"LM",LEFTBUTTMOVE},       /* moving with pressed button */
	{"RM",RIGHTBUTTMOVE},
	{"NULLKEY",0}
};

			    /* Function declarations */

int commit(int handle);
static int near name_to_key(char *word);
int message(char *str,int mode);



static int near mousekeyword(char *word)
{
int i;
  for(i=0;mousetable[i].key;i++){
    if(strcmp(mousetable[i].name,word)==0) return(mousetable[i].key);
  }
  return(0);
}

static int near name_to_key(char *word)
{
int i;
  for(i=0;keytable[i].key;i++){
    if(strcmp(keytable[i].name,word)==0) return(keytable[i].key);
  }
  return(0);
}


int readdemo(void)
{
  demofile = MYOPEN( "demo.dat", O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
  MYREAD(demofile,demobuf,500);
  MYCLOSE(demofile);
  return(0);
}

int filldemobuf(void)
{
char *cp;
int j;

  if(*demobufp=='@'){
    j=MYREAD(demofile,demobuf,500);
    demobufp=demobuf;
    if(!j) lseek(demofile,0L,SEEK_SET);  /* To the beginning of file */

    for(cp=demobuf+j;*cp!='#' && cp!=demobuf; cp--);
    cp+=strcspn(cp," \r\t\n");   /* skip word */
    *cp='@';
  }
  return(0);
}


int facedemo( void )  /* If demonstration version working */
{
char word[20], *wordp=word;
char text[80], *textp=text;
int endx, endy;
int xdistance,ydistance,maxdistance,step;
int key;
int i,j;
int time;
int simulflag;

  if(demofile==-1) demofile = MYOPEN( "demo.dat", O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
  while(1){  /* While not end of file */
    filldemobuf();
    delay(DEFAULTDELAY);
    demobufp+=strspn(demobufp," \r\t\n");   /* skip word space */

    if(*demobufp=='@') continue;                        /* End of buffer */

    if(*demobufp=='/' && *(demobufp+1)=='*'){           /* Comment */
      do{ demobufp++; } while(!(*(demobufp-1)=='*' && *demobufp=='/'));
      demobufp++;
      continue;
    }

    if(*demobufp=='#'){  /* Command */
      demobufp++;

      simulflag=0;                                    /* For mouse */
      if(*demobufp=='M'){ simulflag=1; demobufp++; }  /* simulation */

      j=strcspn(demobufp," \r\t\n");             /* get word */
      *word='\0';                                /* */
      strncat(word,demobufp,j); demobufp+=j;     /* */
      if(key=mousekeyword(wordp)){               /* Mouse */
	demobufp+=strspn(demobufp," \r\t\n");   /* skip word space */
	endx=atoi(demobufp);
	demobufp+=strcspn(demobufp," \r\t\n");   /* skip word */
	demobufp+=strspn(demobufp," \r\t\n");   /* skip word space */
	endy=atoi(demobufp);
	demobufp+=strcspn(demobufp," \r\t\n");   /* skip word */

	if(simulflag){      /* Simulate mouse moving */
	  xdistance=endx-mousex;
	  ydistance=endy-mousey;
	  maxdistance=max(abs(xdistance),abs(ydistance));
	  for(step=maxdistance-1;step>=0;step--){
	    mousex=endx-step*xdistance/maxdistance;
	    mousey=endy-step*ydistance/maxdistance;
	    delay(MOUSEDELAY);
	    simmouse( mousex, mousey );
	  }
	}
	else{
	 mousex=endx; mousey=endy;
	 simmouse( endx, endy );
	}
	return(key);
      }   /* End mouse command */

      if(strcmp(wordp,"Text")==0){              /* Text */
	demobufp+=strspn(demobufp," \r\t\n");   /* skip word space */
	while(*demobufp!='#'){
	  *textp++=*demobufp++;
	}
	demobufp++;
	*textp='\0';
	message(text,1);
	continue;
      } /* End text */

      if(*wordp=='T'){                           /* Delay */
	wordp++;
	time=atoi(wordp);
	delay(time);
	continue;
      }

      if(key=name_to_key(wordp)) return(key);  /* Key */
      continue;            /* Unrecognized command */
    }  /* If command */
    return(*demobufp++);
  } /* While not end of file */
  return(0);
}

