
		/**\
		 	Header file "current.h"		
		 					
		 		      pos_sp macros	
		\**/

#ifndef  _CURRENT_H
#define  _CURRENT_H

#undef FIRST
#undef LAST
#undef CURRENT

#define SQUARE      pos_sp->n.square		/* square information */
#define PIECE_LIST  pos_sp->n.piece_list 	/* Piece list */
#define PIECE_MASKS pos_sp->n.piece_mask		/* piece masks */
#define MOVES       pos_sp->n.moves		/* piece masks */
#define CASTLE      pos_sp->n.castle		/* available & done castles */
#define KING_SQ     pos_sp->n.king_sq
#define POS_MASK    pos_sp->n.pos_mask       /*mask of all pieces on the board */
#define PIECE_BOUND_MASK  pos_sp->n.piece_bound_mask
#define PAWN_BOUND_MASK  pos_sp->n.pawn_bound_mask
#define HASH        pos_sp->n.hash      /*pointer to the saved pos eval */
#define PROFITS     pos_sp->n.profits    /* profit attacks */
#define NEWATTACKED pos_sp->n.newattacked    /* new attacked squares */
#define DEFENCING_PIECE pos_sp->n.defencing_piece /* defending pieces */

#define FIRST   pos_sp->a.first
#define  LAST   pos_sp->a.last			/* first & last moves */
#define CURRENT pos_sp->a.current			/* current move */
#define PREVIOUS pos_sp->a.previous		/* previous move */
#define CURR_N  pos_sp->a.curr_n			/* current move number */
#define  BEST   pos_sp->a.best  			/* the best found move */
#define BEST_N  pos_sp->a.best_n                	/* the best move number */
#define MATERIAL_EVAL pos_sp->a.material_eval	/* material evaluation */
#define MOVE_COLOR pos_sp->a.move_color		/* color of moved piece */
#define EN_PASS pos_sp->a.en_pass      /* en passant captured pawn square */
#define G_STATUS    pos_sp->a.g_status		/* generator status */
#define NSLOW       pos_sp->a.nslow	/*Number of slow moves at the brunch */
#define NCHECK      pos_sp->a.ncheck	/* Number of check moves at the brunch */
#define NFVCHECK    pos_sp->a.nfvcheck	/* Number of check moves in fv at the brunch */
#define NEVAL       pos_sp->a.neval	/* Number of evaluation at the brunch */
#define MAT_DEFICIT pos_sp->a.mat_deficit
#define POSBETAMOVE      pos_sp->a.posbetamove
#define POSFLAGS        pos_sp->a.posflags

#define CHECK (POSFLAGS & P_CHECK)
#define INFIRSTROUNDBORDERS (POSFLAGS & P_INFIRSTROUNDBORDERS)


#define SQUAREP( sq )   ((SQUARE_INFO *)((BYTE *)SQUARE+sqnum_to_addr_shift[sq]))                 /* square pointer */
#define WHOONSQUARE( square )  (&(SQUAREP(square)->wood))

#endif