#include <stdlib.h>	/* exit() */
#include <stdio.h>
#include <conio.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <ctype.h>
#include <string.h>
#include <dir.h>

#include "myface.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facelib.h"

#include "menu.h"
#include "menu_fun.h"
#include "ks_game.h"

#include "ksiwind.h"


int message( char far * str,int flag );

typedef struct {
  NODEPTR np;
  ITEMPTR itemp;
} far MENU_STK;

void setfacefontfile(CFP name);
void getfacefontfile(CFP name);

static MENU_STK mymenustack[ MENUSTACKSIZE ];
static MENU_STK *mymenusp=mymenustack;
static int mymenulevel=0;

char far configfile[MAXPATH]="kaissa.cfg";
static char far signature[5]="\x57\x4b\x01\x02";
int autosaveoptions=0;
int mouseflag=1;

extern char far basename[MAXPATH];
extern char far font16[MAXPATH];
extern char far font14[MAXPATH];
char far font8[MAXPATH];
extern char far pieceimagefont[MAXPATH];
extern char far wndfile[MAXPATH];
extern char far helpfile[MAXPATH];
extern int fontsize;
extern int usefont;
extern int graphmode;
extern int flagmono;
extern int fontsize;
extern int hash_ems;

static enum {
  SEARCH_READ,
  SEARCH_WRITE,
  SEARCH_LENGTH
} search_flag=SEARCH_READ;

static unsigned char options_length=0;

static int hnd=-1;

static int readname(CFP name);

static int errortowind=1;
static void error_report(CFP msg)
{
static char far press_mess[]="Press any key to continue...";
   if(errortowind) message(msg,0);
   else {
     farputs(msg); farputs(press_mess);
     if(!getch()) getch();
   }
}

static int findname( int ifile, CFP name )
{
int i;
struct wndnam {
	 unsigned char length;
	 unsigned char namlth;
	 char nam1[MAXNAME];
	 } windnam;
long int li;

	li=MYLSEEK(ifile,0L,SEEK_SET);
	while((i=MYREAD(ifile,(CFP)&windnam,2))!=0) {
		/* try to find the information on the window in the file */
		if (i==-1) return(ERROR);	/* error on read */
		if(windnam.length==0) return(ERROR);
		li+=windnam.length;
		if (windnam.namlth==FARSTRLEN(name)+2) {
			if ((i=MYREAD(ifile,windnam.nam1,windnam.namlth-1)) <=0)
				return(ERROR);
			if (!FARSTRNCMP(windnam.nam1,name,windnam.namlth)) break;
			/* found the window name */
		}
		if ((li=MYLSEEK(ifile,li,SEEK_SET))==-1L)
			return(ERROR);
	}
	if (i==0)		/* this window was not in the file */
		{ return(0); }
	return( windnam.length );
}

void make_bak_file_name(CFP bakfilename, CFP path)
{
  char drive[MAXDRIVE], dir[MAXDIR], file[MAXFILE], ext[MAXEXT];
    MYFNSPLIT(path,drive,dir,file,ext);
    MYFNMERGE(bakfilename,drive,dir,file,".bak");
}
int make_bak_file(CFP path)
{
  char bakfilename[MAXPATH];
    make_bak_file_name(bakfilename,path);
    chmod(bakfilename,S_IREAD|S_IWRITE); /* If ".bak" file is read only chng attr */
    MYUNLINK(bakfilename);
    return MYRENAME(path,bakfilename);
}

static char far confmess1[]=" Can't copy configuration file.";
static char far confmess2[]=" Wrong configuration file.";
static char far confmess3[]=" Configuration file missing.";
static char far confmess4[]=" Can't write configuration file.";

static int cfgcpy(CFP destname, CFP srcname)
			/* Copy all information exept menu information */
{
  int dest,src;
  int size,n;
  struct {
    unsigned char length;
    unsigned char namlth;
  } label;
  long int offset;
  char buffer[80];

    src=MYOPEN(srcname,O_BINARY|O_RDONLY,S_IREAD|S_IWRITE);
    if(src==-1) goto error_copy;
    dest=MYOPEN(destname,O_TRUNC|O_CREAT|O_BINARY|O_WRONLY,S_IREAD|S_IWRITE);
    if(dest==-1) goto error_copy;
    offset=0L;
    while((offset=MYLSEEK(src,offset,SEEK_SET))!=-1L) {
      if(MYREAD(src,&label,2)<=0) break; /* No more to read */
      if(label.length==0) goto error_copy;
      offset+=label.length;
      if(MYREAD(src,buffer,label.namlth-1)<=0) goto error_copy;
      if(FARSTRNCMP(buffer,signature,label.namlth)) { /* not my name -- copy it */
	if(MYWRITE(dest,&label,2)<=0) goto error_copy;
	if(MYWRITE(dest,buffer,label.namlth-1)<=0) goto error_copy;
	size=label.length-2-(label.namlth-1);
	do {
	  n=(size<sizeof(buffer))? size: sizeof(buffer);
	  if((n=MYREAD(src,buffer,n))<=0) goto error_copy;
	  if(MYWRITE(dest,buffer,n)<=0) goto error_copy;
	  size-=n;
	} while(size>0);
      }
      else { /* my name -- nothing to write now */
      }
    }
    MYCLOSE(src);
    MYCLOSE(dest);
    return 0;
error_copy:
    error_report(confmess1);
    return -1;
}

static int readconfig(void)
{
    if(findname(hnd,"KSCFG")>0) {
      flagmono=0; MYREAD(hnd,&flagmono,sizeof(char));
      if(flagmono==2) { flagmono=0; graphmode=1; }
      else graphmode=0;
      mouseflag=0; MYREAD(hnd,&mouseflag,sizeof(char));
      fontsize=0; MYREAD(hnd,&fontsize,sizeof(char));
      hash_ems=0; MYREAD(hnd,&hash_ems,sizeof(char));
      readname(basename);
      readname(font8);
      setfacefontfile(font8);
      readname(pieceimagefont);
      readname(font14);
      readname(font16);
      readname(helpfile);
      return 0;
    }
    else {
      error_report(confmess2);
      return -1;
    }
}

static int readname(CFP name)
{
  char b;
    do {
      if(MYREAD(hnd,&b,1)<=0) return -1;
      *(name++)=b;
    } while(b);
    return 0;
}
void command_line_help(void)
{
static char far mess1[]="Command line options:";
static char far mess2[]=" /c<filename> configuration file";
static char far mess3[]=" /f no use of chess font";
static char far mess4[]=" /m monochrome";
static char far mess5[]=" /s<14|16> chess font size";
static char far mess6[]=" /p store/replay key strokes";
static char far mess7[]=" /g work in graphics mode";
static char far mess8[]=" /e use EMS for hash";
static char far mess9[]=" /h this help";

    farputs(mess1);
    farputs(mess2);
    farputs(mess3);
    farputs(mess4);
    farputs(mess5);
    farputs(mess6);
    farputs(mess7);
    farputs(mess8);
    farputs(mess9);
    exit(1);
}
int scanargs( int argc, char *argv[] )
{
  int i;
  CFP cp;
    for( i=1; i<argc; i++ ) {	/* Look config file */
      cp=argv[i];
      if( *cp=='-' || *cp=='/' ) {
	cp++;
	if( tolower(*cp) =='c') { FARSTRCPY(configfile,cp+1); break;}
      }
    }
    errortowind=0;
    if(readdefaultoptionsfile()==-1) return -1;
    errortowind=1;
    for( i=1; i<argc; i++ ) {
      cp=argv[i];
      if( *cp=='-' || *cp=='/' ){
	cp++;
	switch( tolower(*cp) ) {
	  case 'c': break; 			/* already proceeded */
	  case 'f': usefont=0; break;
	  case 'm': flagmono=1; break;
	  case 's': farsscanf(cp+1,"%d",&fontsize); break;
	  case 'p': prot_init(); break;
	  case 'g': graphmode=1; break;
	  case 'e': hash_ems=1; break;  
	  case 'h':
	  default: command_line_help();
	}
      }
      else command_line_help();
    }
    return 0;
}

static int readconfig(void);

static int writeoptionsfile(CFP name);
static int readoptionsfile(CFP name);
static int searchoptions(CFP name);
static int beginsearch(CFP name);
static int endsearch(CFP name);
static int american(void);
static int chinese(void);
static int russian(void);
static int down(void);
static int up(void);

/*static char cfgdefstr[]="*.cfg";*/

static char far loadmess[]=" Load Options ";
static char far savemess[]=" Save Options ";
int readoptions(void)
{
  char str[MAXPATH];
  int i;
  WINP wp;
    wp=getpromptwindow(14,56,loadmess);
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      FARSTRCPY(str,configfile);
      i=searchfile( wp, str, /*cfgdef*/str );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return(0);
    checkface(i);
    if (i) return(0);
    if(readoptionsfile(str)) return 0;
    return(1);
}

int writeoptions(void)
{
  char str[MAXPATH];
  int i;
  WINP wp;
    wp=getpromptwindow(13,56,savemess);
    if( wp ) {
      keyfunc(wp,tohelpprompt,BEFORE);
      FARSTRCPY(str,configfile);
      i=searchfile( wp, str, /*cfgdef*/str );
      checkface(freewindow(wp));
    } else return 0;
    if(i==ESCAPE) return 0;
    checkface(i);
    if(i) return 0;
    if(writeoptionsfile(str)) return 0;
    return(1);
}
int readdefaultoptionsfile(void)
{
    return readoptionsfile(configfile);
}
int writedefaultoptionsfile(void)
{
	 return writeoptionsfile(configfile);
}

static int readoptionsfile(CFP name)
{
  search_flag=SEARCH_READ;
  return searchoptions(name);
}

static int writeoptionsfile(CFP name)
{
  search_flag=SEARCH_LENGTH;
  searchoptions(name);
  search_flag=SEARCH_WRITE;
  return searchoptions(name);
}

static int searchoptions(CFP name)
{
  int ret;
		  ret=beginsearch(name);
		  if(ret==-1) goto labelerror;
		  if (ret) goto labelexit;
  labelmain: if( !american() ) goto labelup;
  labeldown: if((ret=down())==-1) goto labelerror;
	     if( ret ) goto labelmain;
  labelup:   if ( !russian() ) goto labeldown;
	     if ( !up()     ) goto labelexit;
	     if ( chinese() ) goto labelup;
	     goto labeldown;
  labelexit: return endsearch(name);
  labelerror: endsearch("");
	     return -1;
}
static int write_signature(CFP name)
{
  unsigned char bf;
    hnd=MYOPEN(name,O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
    if(hnd==-1) return -1;
    MYLSEEK(hnd,0L,SEEK_END);	/* Go to EOF */
			  /* Write label */
    if(MYWRITE(hnd,&options_length,sizeof(options_length))<=0) return -1;
	 bf=sizeof(signature)+1;
    if(MYWRITE(hnd,&bf,sizeof(bf))<=0) return -1;
    if(MYWRITE(hnd,signature,sizeof(signature))<=0) return -1;
    return 0;
}

static int beginsearch(CFP name)
{
  static char far signature[5]="\x57\x4b\x01\x02";
  extern NODE mainmenu;
  char buff[80];
  int size;
    switch(search_flag) {
      case SEARCH_READ:
	hnd=MYOPEN(name,O_BINARY|O_RDONLY|O_TRUNC,0);
	if(hnd==-1) {
	  error_report(confmess3);
	  return -1;
	}
	if(readconfig()==-1) return -1;	/* Error reading configuration */
	if(findname( hnd, signature )<=0) return 1; /* Nothing to read */
	break;
      case SEARCH_WRITE:
	options_length+=sizeof(options_length)+2+(sizeof(signature)-1);
	if(FARSTRCMP(configfile,name)) {	/* It is other file */
	  make_bak_file(name); /* rename old file to ".bak"*/
	  if(cfgcpy(name,configfile)==-1) return -1;	/* copy "configfile" to "name" */
	  if(write_signature(name)==-1) goto error_write;
	}
	else {				/* It is the same file */
	  hnd=MYOPEN(name,O_BINARY|O_RDWR,S_IREAD|S_IWRITE);
	  if(hnd==-1) goto error_write;
	  size=findname(hnd,signature);
	  if(size<options_length) {	/* Not found or size is too small */
	    MYCLOSE(hnd);
	    make_bak_file_name(buff,name);
	    chmod(buff,S_IREAD|S_IWRITE); /* If ".bak" file is read only chng attr */
	    unlink(buff);		/* delete ".bak" if exist */
	    MYRENAME(name,buff);	/* rename "name" to ".bak" */
	    if(cfgcpy(name,buff)==-1) return -1;	/* copy ".bak" to "name" */
		 if(write_signature(name)==-1) goto error_write;
	  }
	}
	break;
      case SEARCH_LENGTH:
	options_length=0;
	break;
    }
    mymenulevel=0;
    mymenusp=mymenustack;
    mymenusp->np=&mainmenu;
    return 0;
error_write:
    error_report(confmess4);
    return -1;
}
static int endsearch(CFP name)
{
    if(search_flag==SEARCH_LENGTH) return 0;
    if(*name) FARSTRCPY(configfile,name);
	 return MYCLOSE(hnd);
}

static int american(void)
{
    mymenusp->itemp=mymenusp->np->firstitem;
    return (mymenusp->itemp->itemname)!=NULL;
}

static int chinese(void)
{
    return !((++(mymenusp->itemp))->itemname);
}

static int russian(void)
{
    return 1;
}

static int down(void)
{
  char buf;
  char far *p;
  int len,i;
  ITEMPTR itemp;
    do {
      itemp=mymenusp->itemp;
      switch(ITEMTYPE&~SPEC_FLAGS) {
	case SUBMENU: 
	  mymenulevel++;
	  mymenusp++;
	  mymenusp->np=(NODEPTR)OBJECT;
	  return 1;
	case ON_OFF: 
	case YES_NO: 
	case INT_NO: 
	case INT:    p=OBJECT; len=sizeof(int);  break;
	case LONG_NO:
	case LONG:       
	case TIME:   p=OBJECT; len=sizeof(long); break;
	case STR :
	case SPECSTR:
	  p=OBJECT;
	  if(search_flag==SEARCH_READ) {
	    i=0;
	    do {
	      if(MYREAD(hnd,&buf,1)<=0) goto error_read;
	      p[i]=buf;
	      i++;
	    } while(buf);
	    continue;
	  }
	  else /* search_flag==SEARCH_WRITE|| search_flag==SEARCH_LENGTH */ {
	    for(len=0; p[len]; len++); len++;
	  }
	  break;
	case LIST :  p=INFO; len=sizeof(int); break;
	default: len=0;
      }
      if(search_flag==SEARCH_READ) {
	for(i=0; i<len; i++) {
	  if(MYREAD(hnd,&buf,1)<=0) goto error_read;
	  p[i]=buf;
	}
      }
      else if(search_flag==SEARCH_WRITE) {
	for(i=0; i<len; i++) {
	  buf=p[i];
	  if(MYWRITE(hnd,&buf,1)<=0) goto error_write;
	}
      } 
      else /*search_flag==SEARCH_LENGTH*/ {
	options_length+=len;
      }
    } while( (++(mymenusp->itemp))->itemname );
    return 0;
error_read:
    error_report(confmess2);
    return -1;
error_write:
    error_report(confmess4);
    return -1;
}

static int up(void)
{
    if(mymenulevel==0) return 0;
    mymenulevel--;
    mymenusp--;
    return 1;
}
