		/**\
		 	Header file "chess.h"		
		 					
		 		Some chess definitions	
		\**/

#ifndef  _CHESS_H
#define  _CHESS_H

#ifndef  _LANG_H
#include "lang.h"
#endif

	/* Some global constants */


#define TOTAL_NUM_PIECE 32	/* Total number of pieces. */
				  /* White king have # 0 and */
				  /* Black king have # 16 */
#define NUM_PIECE   16		/* Number of pieces of one color */
#define NSQUARE     64		/* Number of squares on a board */
#define NDIR	     8		/* Number of directions */
#define NLINE        8  	/* Number of lines on a board */
#define NFILE        8         	/* Number of files on a board */
#define NPIECE       6		/* Number of different pieces */
#define LINELEN      8		/* Lenght of line or file on a board */
#define FIRSTLINE    0		/* Number of the first line on a board */
#define LASTLINE     7		/* Number of the last line on a board */

	/* Some global types and constants */

// *** Move flags ***

typedef unsigned int MOVEFLAGS;

#define M_EN_PASSANT          0x01	/* Move flag masks */
#define M_CASTLE_LEFT         0x02
#define M_CASTLE_RIGHT	      0x04
#define M_NULLMOVE            0x08
#define M_PROMOTION           0x10
#define M_CAPTURE             0x20
#define M_ISCHECK             0x40
#define M_KILLER              0x80
#define M_PASSAGE            0x100
#define M_CHECK_DEFENCE      0x200

// *** Position flags ***

typedef unsigned int POS_FLAGS;

#define P_EVALKILLER   0x01   /* Evaluation is the killer move in position */
#define P_EVALBETTER   0x02   /* Evaluation is the better move in position */
#define P_DEEPENING    0x04 /* Deepening in position */
#define P_ADDMOVESORT  0x08 /* Additional move sorting happend */
#define P_CHECK	       0x10  /* Check state indicator */
#define P_CAPTURE      0x20  /* Previous move was capture */
#define P_INFIRSTROUNDBORDERS 0x40
#define P_POSNARROWBOARDS  0x80
#define P_EVALBAD         0x100
#define P_ENINFIRSTROUNDBORDERS 0x200

#define P_EVALBEST (P_EVALKILLER|P_EVALBETTER)  /* Evaluation is the best move in position */
#define P_EVAL (P_EVALKILLER|P_EVALBETTER|P_EVALBAD)


typedef unsigned char GEN_STATUS;

#define G_NORMAL              0
#define G_FORCED 	 0x0001
#define G_WITHOUT_CHECK  0x0002
#define G_VARIANT        0x0004
#define G_ATTACKS        0x0008
#define G_NULLENABLE     0x0010
#define G_SELECTIVE      0x0020
#define G_ATTDEFENCE     0x0040

#undef DIR
typedef BYTE DIR;		/* directions of moving */
typedef enum {
	NODIR=0x00,
	_LEFT_UP   =0x01, _UP  =0x02, _RIGHT_UP =0x04, _RIGHT=0x08,
	_RIGHT_DOWN=0x10, _DOWN=0x20, _LEFT_DOWN=0x40, _LEFT =0x80
} DIRECTIONS;
#define NOBOUND '\xFF'

#define NCOLOR	     2		/* Number of colors */
typedef enum {			/* Define type PIECE_COLOR */
  NOCOLOR=-1,
  WHITE_PIECE = 0,
  BLACK_PIECE = 1
}		  OLD_PIECE_COLOR;
typedef	signed char PIECE_COLOR;

typedef enum {			/* Define type PIECE_NAME */
  NOPIECE= 0,
  KING   = 1,
  QUEEN  = 2,
  ROOK   = 3,
  BISHOP = 4,
  KNIGHT = 5,
  PAWN   = 6
}		   OLD_PIECE_NAME;
typedef	signed char PIECE_NAME;

typedef signed int MAT_EVAL;
typedef signed int POS_EVAL;
#define	MAT_INFINITY	997	/* Maximum material evaluation value */
#define POS_INFINITY    0x7FFF	/* Maximum position evaluation value */

typedef enum {
  NOCOST=0,     KING_COST=20/*0*/,  QUEEN_COST=19,
  ROOK_COST=10, BISHOP_COST=7,  KNIGHT_COST=7,
  PAWN_COST=2
} OLD_PIECE_COST;
typedef	signed char PIECE_COST;

typedef struct {		/* Define type EVAL for evaluations */
  MAT_EVAL material;			/* Material part */
  POS_EVAL position;			/* Position part */
}		         EVAL;

typedef const struct {		/* Define type WOOD_PIECE */
  PIECE_NAME name;			/* piece name */
  PIECE_COLOR color;			/* color of piece */
  PIECE_COST cost;			/* piece cost */
}		   WOOD_PIECE;

typedef enum {			/* Define type SQUARE NUMber */
  a1,b1,c1,d1,e1,f1,g1,h1,
  a2,b2,c2,d2,e2,f2,g2,h2,
  a3,b3,c3,d3,e3,f3,g3,h3,
  a4,b4,c4,d4,e4,f4,g4,h4,
  a5,b5,c5,d5,e5,f5,g5,h5,
  a6,b6,c6,d6,e6,f6,g6,h6,
  a7,b7,c7,d7,e7,f7,g7,h7,
  a8,b8,c8,d8,e8,f8,g8,h8,
  DUMMY=-1
}	       OLD_SQUARE_NUM;
typedef signed char SQUARE_NUM;

typedef struct {
  unsigned int leftup:1, up:1, uprght:1, right:1,
	rghtdn:1, down:1, dnleft:1, left:1/*, unuse:8*/;
} B_DIR;
typedef union {
  BYTE i;
  B_DIR bd;
} BIT_DIR;
/* 				 Directions
				   knight

				1       2

			     0		   3
				    *
			     7	           4

				 6      5

				not knight

				    1

			       0         2

			    7       *       3

			       6	 4

				    5			*/

typedef struct {		/* Define type PIECE_IN_LIST */
  SQUARE_NUM where;			 /* where stay piece */
/*
  B_DIR /*SQUARE_NUM*/ linked; /* what directions linked at */
  B_DIR defence;             /* what directions defence at */
*/
  /*
  WOOD_PIECE wood;			/* who stay on square "where"*/
  */
}		   PIECE_IN_LIST;

typedef enum {			/* Define type piece LIST NUMber */
  EMPTY_NUM = -1,
  WHITE_KING   =  0,
  WHITE_QUEEN  =  1,
  WHITE_LEFT_ROOK   =  2,  WHITE_RIGHT_ROOK   =  3,
  WHITE_LEFT_BISHOP =  4,  WHITE_RIGHT_BISHOP =  5,
  WHITE_LEFT_KNIGHT =  6,  WHITE_RIGHT_KNIGHT =  7,
  WHITE_PAWN_A =  8, WHITE_PAWN_B =  9,  WHITE_PAWN_C = 10, WHITE_PAWN_D = 11,
  WHITE_PAWN_E = 12, WHITE_PAWN_F = 13,  WHITE_PAWN_G = 14, WHITE_PAWN_H = 15,
  BLACK_KING   = 16,
  BLACK_QUEEN  = 17,
  BLACK_LEFT_ROOK   = 18,  BLACK_RIGHT_ROOK   = 19,
  BLACK_LEFT_BISHOP = 20,  BLACK_RIGHT_BISHOP = 21,
  BLACK_LEFT_KNIGHT = 22,  BLACK_RIGHT_KNIGHT = 23,
  BLACK_PAWN_A = 24, BLACK_PAWN_B = 25,  BLACK_PAWN_C = 26, BLACK_PAWN_D = 27,
  BLACK_PAWN_E = 28, BLACK_PAWN_F = 29,  BLACK_PAWN_G = 30, BLACK_PAWN_H = 31,
}		   LIST_NUM;

typedef struct {		/* Define type MOVE */
  SQUARE_NUM from;			/* move from square */
  SQUARE_NUM to;			/* move  to  square */
  MOVEFLAGS flags;				/* move flags */
  MAT_EVAL profit;			/* capture profit */
}  			 MOVE;

typedef struct {		/* Type for view masks in TD */
  unsigned int K:1, Q:1, lR:1, rR:1, lB:1, rB:1, lN:1, rN:1;
  unsigned int aP:1, bP:1, cP:1, dP:1, eP:1, fP:1, gP:1, hP:1;
} BIT_MASK;

typedef enum {			/* Define type DEFAULT piece MASK */
  NOMASK = 0,
  KING_MASK =        0x0001, QUEEN_MASK =        0x0002,
  LEFT_ROOK_MASK =   0x0004, RIGHT_ROOK_MASK =   0x0008,
  LEFT_BISHOP_MASK = 0x0010, RIGHT_BISHOP_MASK = 0x0020,
  LEFT_KNIGHT_MASK = 0x0040, RIGHT_KNIGHT_MASK = 0x0080,
  A_PAWN_MASK =      0x0100, B_PAWN_MASK =       0x0200,
  C_PAWN_MASK =      0x0400, D_PAWN_MASK =       0x0800,
  E_PAWN_MASK =      0x1000, F_PAWN_MASK =       0x2000,
  G_PAWN_MASK =      0x4000, H_PAWN_MASK =       0x8000
}  DEFAULT_MASK;

#define ROOK_MASK   ( LEFT_ROOK_MASK | RIGHT_ROOK_MASK)
#define BISHOP_MASK ( LEFT_BISHOP_MASK | RIGHT_BISHOP_MASK)
#define KNIGHT_MASK ( LEFT_KNIGHT_MASK | RIGHT_KNIGHT_MASK)
#define QUEEN_ROOK_MASK   (QUEEN_MASK | ROOK_MASK)
#define QUEEN_BISHOP_MASK (QUEEN_MASK | BISHOP_MASK)
#define QUEEN_ROOK_BISHOP_MASK (QUEEN_ROOK_MASK | BISHOP_MASK)

#define BISHOP_KNIGHT_MASK  (BISHOP_MASK | KNIGHT_MASK)
#define BISHOP_KNIGHT_PAWN_MASK  (BISHOP_KNIGHT_MASK | PAWN_MASK)
#define ROOK_BISHOP_KNIGHT_PAWN_MASK  (ROOK_MASK | BISHOP_KNIGHT_PAWN_MASK)
#define ALLPIECE_MASK 0x00FF
#define PAWN_MASK   0xFF00

typedef union {			/* Define type PIECE MASK */
  DWRD dwrd;
  WORD word[NCOLOR];
  BYTE byte[NCOLOR][2];
  BIT_MASK bit[NCOLOR];
}                 PIECE_MASK;

typedef struct {		/* Define type SQUARE_INFO */
  SQUARE_NUM edge[NDIR];		/* edges for all directions */
  PIECE_MASK attackedby;		/* who attacks this square */
  WORD moves;				/* mask of written moves to this square */
  WOOD_PIECE wood;			/* who is on square */
  PIECE_MASK who_mask;			/* "who is on square" mask */
  DIR        bound;			/* can't leave this direction */
  SQUARE_NUM mynum;                     /* number of this square */
}		SQUARE_INFO;

typedef signed char CASTLES;

#define CASTLELEFT 8
#define CASTLERIGHT 4
#define CASTLELEFTDONE 2
#define CASTLERIGHTDONE 1 /* M.D. */

typedef struct {
  SQUARE_NUM square;
  BYTE profit;
}          PROFIT_SQ;

typedef struct  {		/* Define type NEAR_POSITION -- */
				  /* near part of position stack element type */

  SQUARE_INFO square[NSQUARE];		/* Square information */
  PIECE_IN_LIST piece_list[TOTAL_NUM_PIECE];	/* Piece list */
  PIECE_MASK piece_mask[NPIECE+1];  /* Group masks for all piece +NOPIECE */
  PIECE_MASK pos_mask;                /*mask of all pieces on the board */
  PIECE_MASK defencing_piece;         /*mask of defending pieces on the board */
  DIR piece_bound_mask[NCOLOR][NCOLOR];       /*mask of bound pieces */
  DIR pawn_bound_mask[NCOLOR][NCOLOR];       /*mask of bound pieces */
  CASTLES castle[NCOLOR];		/* Available and done castles */
  SQUARE_NUM king_sq[NCOLOR];            /* Square of the king */
  unsigned long hash;                   /* position's hash */
  PROFIT_SQ profits[NCOLOR][NUM_PIECE+1];       /* profit attacks */
  PROFIT_SQ newattacked[NCOLOR][NUM_PIECE+1];  /* new profit attacks */
  SQUARE_NUM passage[NLINE+1];
}		  NEAR_POSITION;

typedef struct  {		/* Define type ADD_POSITION -- */
				  /* additional position stack element type */
  MOVE *first,*last;			/* First & last moves */
  MOVE *current;			/* Current move */
  MOVE *previous;			/* Previous move */
  signed char curr_n;				/* Current move number */
  MOVE best;				/* The better found move */
  signed char best_n;	                        /* The better move number */
  GEN_STATUS g_status;			/* Generator status */
  MAT_EVAL material_eval;		/* Material evaluation */
  MAT_EVAL mat_deficit;			/* Material deficit */

  PIECE_COLOR move_color;		/* Color of moved piece */
  SQUARE_NUM en_pass;			/* En passant captured pawn square */
  BYTE nslow;				/* Number of slow moves at the brunch */
  BYTE ncheck;				/* Number of check moves at the brunch */
  BYTE neval;				/* Number of evaluation at the brunch */
  BYTE nfvcheck;			/* Number of check moves */
  MOVE *posbetamove;
  POS_FLAGS posflags;                    /* Position flags */
}		    ADD_POSITION;

typedef struct  {		/* Define type POSITION -- */
				  /* position stack element type */
  NEAR_POSITION n;
  ADD_POSITION  a;
}                      POSITION;

typedef enum {				/* Define type PARTY_STATUS */
  DEBUT=1,
  MIDDLEGAME=2,
  ENDGAME=4,
  CHECKMATE=8
} PARTY_STATUS;

#endif