#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "ks_corr.h"
#include "proc.h"
#include <mem.h>

/*static  PIECE_COLOR our,enemy;*/
/*static  SQUARE_NUM king_square;*/
static void near change_bound_dir(DIR dirmask, PIECE_COLOR our);
BYTE bytes[8]={0x1,0x2,0x4,0x8,0x10,0x20,0x40,0x80};


void NEAR change_bound(SQUARE_NUM sq)      /* Need both kings in piece_list */
{
PIECE_COLOR our;

  for(our=WHITE_PIECE;our<NCOLOR;our++)
    change_bound_dir(direction[KING_SQ[our]][sq], our);
}

void NEAR change_king_bound(PIECE_COLOR our) 
{
DIR dir;
/*PIECE_COLOR enemy;*/

/*  enemy=reverse_color(our); */
  for(dir=1;dir;dir<<=1)            /* For all direction */
    change_bound_dir(dir, our);
/*  change_bound_dir(direction[KING_SQ[enemy]][KING_SQ[our]], our); */
}

static void near change_bound_dir(DIR dirmask, PIECE_COLOR our)
{
  int ndir;
  SQUARE_INFO *firstp;
  PIECE_COLOR enemy;

    enemy=reverse_color(our);
    if(dirmask) {
      ndir=byte_to_int(dirmask);
      PIECE_BOUND_MASK[our][enemy]&=~dirmask;
      PIECE_BOUND_MASK[our][our]&=~dirmask;
      PAWN_BOUND_MASK[our][enemy]&=~dirmask;
      PAWN_BOUND_MASK[our][our]&=~dirmask;
      firstp=SQUAREP(SQUARE[KING_SQ[our]].edge[ndir]);
      if(firstp->who_mask.word[our])  {          /* En->Our->OurKING */
	if( SQUAREP(firstp->edge[ndir])->who_mask.word[enemy] &
	    firstp->attackedby.word[enemy] &
	    (QUEEN_MASK|ROOK_MASK|BISHOP_MASK))  {
	  if(firstp->wood.name==PAWN) PAWN_BOUND_MASK[our][our]|=dirmask;
	  else PIECE_BOUND_MASK[our][our]|=dirmask;
          return;
        }
      }
      if(firstp->who_mask.word[enemy])  {        /* En->En->OurKING */
	if( SQUAREP(firstp->edge[ndir])->who_mask.word[enemy] &
	    firstp->attackedby.word[enemy] &
	    (QUEEN_MASK|ROOK_MASK|BISHOP_MASK))  {
	  if(firstp->wood.name==PAWN) PAWN_BOUND_MASK[our][enemy]|=dirmask;
	  else PIECE_BOUND_MASK[our][enemy]|=dirmask;
	  return;
        }
      }
    } /* If dir */
}

int NEAR square_bounded(SQUARE_NUM sq, PIECE_COLOR kingcolor)
{
DIR dirmask;

 if(!(dirmask=direction[KING_SQ[kingcolor]][sq])) return(0);
 if(!(dirmask & PIECE_BOUND_MASK[kingcolor][kingcolor])) return(0);
 return
   (SQUAREP(KING_SQ[kingcolor])->edge[byte_to_int(dirmask)]==sq);
}


