#include <conio.h>      /* getch(), kbhit(), clrscr() */
#include <stdlib.h>     /* NULL,  abs() */
#include <stdio.h>      /* puts() */
#include <dir.h>
#include <ctype.h>      /* toupper() */
#include <string.h>

#include "myface.h"
#include "myfacpro.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facerr.h"
#include "facemous.h"

#include "chess.h"
#include "global.h"   /* pos_sp */
#include "current.h"  /* MOVE_COLOR */
#include "proc.h"
#include "entime.h"
#include "ksichess.h"
#include "helpind.h"
#include "menu.h"
#include "menu_func.h"
#include "interface.h"
#include "infc_func.h"
#include "ksibdraw.h"
#include "ks_macro.h"
#include "ksiutil.h"
#include "ksiprot.h"
#include "ksiwork.h"
#include "ksiwind.h"
#include "ksitimer.h"
#include "ks_corr.h"
#include "ks_game.h"
#include "ksisound.h"
#include "ksibase.h"
#include "newutil.h" /* setdefaultcastle() */
#include "tests.h"
#include "link.h"
#include "hashpos.h"

int downedit(WINP wp);
static void waitkaissamove( void );
static void makeonemove(FULLMOVE *curmove);
static void unlegaluser(void);

SQUARE_NUM cursquare=DUMMY, redsquare=DUMMY;
WHOPLAY whomove=MAN_MAN;  /* current player: user/computer  */
int debut=0;        /* begin is debut */
int issound=1;
int usedebut=1;     /* use debut base */
int analyse=0;     /* analyse one move */
int enemytime=1;   /* think enemy time */
int enemy_move_done=0; /* enemy move already done */
int enemy_move_exist=0; /* enemy move already entered */
char far playmove[]="t120o5 l24 adg#16e28";
char far playerror[]="t120o5 l24 ms ggg";

int beginboard(void)
{
  int boardtype,boardattr;
    showtimer();
    refresh( enter );
    getborder(board,&boardtype,&boardattr);
    border(board, TWOLINES, boardattr);
    openwindow(board);
    if( cursquare==DUMMY ) cursquare=e2;
    setcursquare( cursquare );
    if( (1 << MOVE_COLOR) & whomove) waitkaissamove();
    else if (!genlegalmoves() && whomove!=MAN_MAN) gamefinish();
    return 0;
}

int resetboard(void)
{
  int boardtype,boardattr;
    showtimer();
    refresh( enter );
    getborder(board,&boardtype,&boardattr);
    border(board, TWOLINES, boardattr);
    if( cursquare==DUMMY ) cursquare=e2;
    setcursquare( cursquare );
    if( (1 << MOVE_COLOR) & whomove) waitkaissamove();
    else  if (!genlegalmoves() && whomove!=MAN_MAN) gamefinish();
    return 0;
}

int beginboardbreak(void)
{
  int boardtype,boardattr;
    showtimer();
    refresh( enter );
    getborder(board,&boardtype,&boardattr);
    border(board, TWOLINES, boardattr);
    openwindow(board);
    if( cursquare==DUMMY ) cursquare=e2;
    setcursquare( cursquare );
    return 0;
}

int resetboardbreak(void)
{
/*  showtimer();
    openwindow( enter );
    border(board,TWOLINES,activewindbord);
    openwindow(board);
    if(cursquare==DUMMY) {
      cursquare=e2;
    }
    else {
      drawcurframe( cursquare );
    }
*/
    return (-1); 	/* to return to search */
}

int gooutboard(void)
{
  int boardtype,boardattr;
    getborder(board,&boardtype,&boardattr);
    border(board, ONELINE, boardattr);
    makeborder(board);
    clearframe(cursquare);
/*    if( redsquare==cursquare ) drawredframe( redsquare );*/
    redsquare=DUMMY;
    return 0;
}

extern int notstartposflag;
int beginboardset(void)
{
  int boardtype,boardattr;
    facefreeze(NULL);
    getborder(board,&boardtype,&boardattr);
    border(board, TWOLINES, boardattr);
    openwindow(board);
    closewindow(timer);
    closewindow(enter);
    closewindow(comment);
    redsquare=DUMMY;
    openwindow( colors ); 
    openwindow( pieces );
    faceunfreeze(NULL);
    countpieces();
    notstartposflag=1;
    return (ret_status(goto_endsetmenu()));
}

int resetboardset(void)
{
  int boardtype,boardattr;
    getborder(board,&boardtype,&boardattr);
    border(board, TWOLINES, boardattr);
    redsquare=DUMMY;
    countpieces();
    return 0;
}

int gooutboardset(void)
{
  int boardtype,boardattr;
    facefreeze(NULL);
    debut=0;
    setposition( MOVE_COLOR );
    closewindow(colors);
    closewindow(pieces);
    openwindow(comment);
    openwindow(timer);
    openwindow(enter);
    faceunfreeze(NULL);
    setwhomove(MAN_MAN);
    setcolor( MOVE_COLOR );
    closeprotocol();
    resetprotocol();
    closebase();
    getborder(board,&boardtype,&boardattr);
    border(board, ONELINE, boardattr);
    makeborder(board);
    clearframe(cursquare);
    if( redsquare==cursquare ) drawredframe( redsquare );
    return 0;
}

int newsquare( SQUARE_NUM *square, int key )
{
  int file, line;
  int delta=0;
    file=GETFILE( *square );
    line=GETLINE( *square );
    if( revindex ) {
      switch( key ) {
	case LEFTARROW: if( file!=7 ) delta=1;  break;
	case RIGHTARROW:if( file!=0 ) delta=-1; break;
	case UPARROW:   if( line!=0 ) delta=-8; break;
	case DOWNARROW: if( line!=7 ) delta=8;  break;
	case HOME:      if( file!=7 ) delta=1;
			if( line!=0 ) delta-=8; break;
	case END:       if( file!=7 ) delta=1;
			if( line!=7 ) delta+=8; break;
	case PGUP:      if( file!=0 ) delta=-1;
			if( line!=0 ) delta-=8; break;
	case PGDOWN:    if( file!=0 ) delta=-1;
			if( line!=7 ) delta+=8; break;
	default: return 0;
      }
    }
    else {
      switch( key ){
	case LEFTARROW: if( file!=0 ) delta=-1; break;
	case RIGHTARROW:if( file!=7 ) delta=1;  break;
	case UPARROW:   if( line!=7 ) delta=8;  break;
	case DOWNARROW: if( line!=0 ) delta=-8; break;
	case PGDOWN:    if( file!=7 ) delta=1;
			if( line!=0 ) delta-=8; break;
	case PGUP:      if( file!=7 ) delta=1;
			if( line!=7 ) delta+=8; break;
	case END:       if( file!=0 ) delta=-1;
			if( line!=0 ) delta-=8; break;
	case HOME:      if( file!=0 ) delta=-1;
			if( line!=7 ) delta+=8; break;
	default: return 0;
      }
    }
    *square+=delta;
    return(1);
}


int showsquare( void )
{
  static char far str[]=" e1-e2 ";
  static char far white_str[]=" white";
  static char far black_str[]=" black";
  int i=1;
    if( redsquare!=DUMMY && redsquare!=cursquare) {
      sprintsquare( str+i, redsquare ); i+=2;
      str[i++]='-';
    }
    sprintsquare( str+i, cursquare ); i+=2;
    str[i++]=' '; str[i]='\0';
    putadrln(2,28,(MOVE_COLOR==WHITE_PIECE)? white_str:black_str,0,6,
	WHITE ON LIGHTGRAY );
    putadrln(2,34,str,0,i,WHITE ON LIGHTGRAY );
    return(0);
}

int drawpiecemove( void )
{
  WOOD_PIECE *wpp;
  static SQUARE_NUM oldsquare=DUMMY;
	if( ismouse )
		disablecursor();
	if( oldsquare!=DUMMY ){ 
		wpp=WHOONSQUARE( oldsquare );
		if( wpp ){ 
			if( wpp->name==NOPIECE || oldsquare==redsquare )
				clearpiece( oldsquare );
			else 
				drawpiece( oldsquare, wpp->name, wpp->color );
		}
	}
	if( cursquare!=redsquare )
		clearpiece( redsquare );
	oldsquare=cursquare;
	drawpiece( cursquare, curmove.who, MOVE_COLOR );
	drawcurframe( cursquare );
	if( ismouse )
		enablecursor();
	return(0);
}
int w_drawboard(void)
{
    if(stone_name()==REPLY_ST) return 0;
    drawboard();
    drawcurframe( cursquare );
    if(redsquare!=DUMMY) drawredframe(redsquare);
    showsquare();
    return 0;
}

int boardcursorkey( int key )
{
    if( !newsquare( &cursquare, key ) ) return( key );
    setcursquare( cursquare );
	if( redsquare!=DUMMY ){ 
		drawpiecemove();
		drawredframe( redsquare );
	}
    showsquare();
    return(OK);
}
int boardkey(int key)
{
    if ( boardcursorkey( key )==0 ) return NULLKEY;
    if( cur_infc_ptr->name==BOARDSET_ST ) {
      if( ispiece(key) ) {
	posstate(pieces,chartopiece(key),1);
	refresh(pieces);
	spaceboardset();
	return NULLKEY;
      } 
      if( iscolor(key) ) {
	MOVE_COLOR=chartocolor(key);
	posstate(colors,1+MOVE_COLOR,1);
	refresh(colors);
	return NULLKEY;
      } 
    } 
    return key;
}

extern int notstartposflag;

int entermove( void )
{
  WOOD_PIECE  *wpp; /* wood piece pointer */
	wpp=WHOONSQUARE( cursquare );
	if( wpp->name!=NOPIECE && wpp->color==MOVE_COLOR ){
		if( redsquare!=DUMMY ) clearframe( redsquare );
		redsquare=cursquare; 		/* picking up the piece */
		curmove.who=wpp->name;
		curmove.from=redsquare;
		setwritten(board);
		return(0);          /* move not ready */
	}
	if( redsquare==DUMMY ) return(0);
	curmove.to=cursquare;
	curmove.flags=0;
	fillmove( &curmove );		/* opp's move */
/*	clearframe( redsquare );
	redsquare=DUMMY;*/
	return(1);               /* move ready */
}

int spaceboard( void )
{
    if( !entermove() ) return(0);
    if (!genlegalmoves()) {
	gamefinish();
	return(0);
    }
    if( legalmove(&curmove)) {
	   clearframe( redsquare );
	   redsquare=DUMMY;
	   putkaissamove( &curmove );     /* make opp's move */
	   makeonemove(&curmove);
	   if ( (1 << MOVE_COLOR) & whomove) waitkaissamove();
	   else if (!genlegalmoves()) gamefinish();
    } else unlegaluser();
    return(0);
}

int spaceboardbreak( void )
{
	if( !entermove() ) return(0);
	return(-2);
}

static void unlegaluser(void)
{
   music(playerror);
}

static void waitkaissamove(void)
{
int ret;
   while(1) {
	 if (!genlegalmoves()) {
	      gamefinish();
	      return;
	 }
	 if ( (1<<MOVE_COLOR) & whomove) { /* KAISSA's move */
/*		if (print_flag && !debut) ret_status((REPLY_ST<<8)|DELETE_ST);*/
		ret=getkaissamove(&curmove);
		if (ret==OK) 	makeonemove(&curmove);
		else {
			if (breakflag != TERMINATE) music(playerror);
			return ;
		} /* end of else move done */
	 } else {  /* human move */
		if( !debut && enemytime && !answer_ready &&
			  (whomove==MAN_KAISSA || whomove==KAISSA_MAN)) {
							/* thinking onopp's time */
		  openwindow(helpline); /* to hide window "small" */
		  think_enemy_time();
/*	 	  if (!breakflag || ) what is to be done;*/
		  if (!enemy_move_done && enemy_move_exist) {

			 putkaissamove(&curmove); /* it is get and checked in userbreak() */
			 makeonemove(&curmove);
					/*	KAISSA guessed wrong */
		  } else if (enemy_move_done) {
			 refresh(small);
			 answer_ready=0;
			 movetofull(&curmove,&kaissa_move);
			 putkaissamove(&curmove);
			 makeonemove(&curmove);
		  } else return;  /* broken */
		} /* end of opp's time */
		else return; 		/* no thinking on opp's time */
	 } /* end of if move is human */
   } /* end of while */
}

int escboard( void )
{
    if( redsquare!=DUMMY ) clearframe(redsquare);
	redsquare=DUMMY;
	return(0);
}

void getprotcomment(void);
extern NODE usermenu;

static void makeonemove( FULLMOVE *curmove )
{
    setwritten(board);
    refresh(board);
    drawcurframe( cursquare );
    updatetime();
    savemove( curmove , reverse_color(MOVE_COLOR));
    if( drawflag ){ message(" Draw. ",1); setwhomove(MAN_MAN); }
    if (issound) music(playmove);
	/*if(!enemy_move_done)*/ /*setcolor( REVCOLOR(MOVE_COLOR) );/* */*/
}


/* ----------- */

int clearpos( void )
{
  init_pos();
  notstartposflag=1;
  resetprotocol();
  closebase(); debut=0;
  whomove=MAN_MAN;
  setwritten(board);
  refresh(board);
  return(0);
}

int resetgame( void )
{
static char far mess1[]=" Opening book not available. ";
    setstartpos();
    resettime();
    if( usedebut ){
      if(initbase()==OK ) debut=1;
      else {
	message(mess1,0);
	debut=0;
      }
    }
    setcolor( WHITE_PIECE );
    setwhomove(MAN_MAN);
    /* drawboard(); */
    resetprotocol();
    return(0);
}

int setcolor( PIECE_COLOR color )
{
    MOVE_COLOR=color;
    return( showtimer() );
}



int tabboardset(void)
{
    downedit( pieces );
	refresh( pieces );
	return 0;
}
int shifttabboardset(void)
{
    downedit( colors );
	refresh( colors );
    return 0;
}

int spaceboardset(void)
{
  static char far mess1[]=" Can't set piece. ";
  WOOD_PIECE *wpp; /* wood piece pointer */
    notstartposflag=1;
    if(ismouse) disablecursor();
    wpp=WHOONSQUARE( cursquare );
    if( wpp->name!=NOPIECE ) {
      deloldpiece(cursquare);
      clearpiece( cursquare );
    }
    else {
      if( newpiece( cursquare, getcury( pieces ), getcury( colors )-1 )==ERROR )
	message(mess1,0);
      else {
	wpp=WHOONSQUARE( cursquare );
	setwritten(board);
	drawpiece( cursquare, wpp->name, wpp->color );
      }
    }
    drawcurframe( cursquare );
    if(ismouse) enablecursor();
    return 0;
}
int delboardset(void)
{
    deloldpiece( cursquare );
    setwritten(board);
    refresh(board);
    return 0;
}
int checkcolor(void)
{
  static char far mess1[]="Illegal check state.";
  static char far mess2[]=" You forgot the white king ";
  static char far mess3[]=" You forgot the black king ";
  if(check(reverse_color(MOVE_COLOR))){
    message(mess1,0);
    return(0);
  }
  if(MOVE_COLOR==WHITE_PIECE) {
    if (!is_white_king()) {
	message(mess2,0);
	return(0);
    }
    if (!is_black_king()) {
	message(mess3,0);
	return(0);
    }
  }
  else {
    if (!is_white_king()) {
	message(mess2,0);
	return(0);
    }
    if (!is_black_king()) {
	message(mess3,0);
	return(0);
    }
  }
  return terminate_set();

}

int goto_endsetmenu(void)
{
    setdefaultcastles();
    MOVE_COLOR=boardsetcolor;
    return ((ENDSET_ST<<8));
}

