
		/**\
		 	Header file "board.h"		
		 					
		 	All about boards		
		   required:             		
		 	"lang.h"			
		 					
		 	       Functions: or()		
		 			   xor()	
		               equal()	   and()	
		 		nequal()   not()	
		 		andnot()   copy()      	
		               or3()	   and3()	
		 		xor3()	   not2()	
		 		empty()    nempty()	
		 		clear()	   set()	
		 		asl1()	   asr1()	
		 		asl7()	   asr7()	
		 		asl8()	   asr8()	
		 		asl9()	   asr9()	
		 		low()	   high()	
		 		orf()      andf()	
		 		copyf()			
		 		int_to_board()		
		 		board_to_int()		
		 		int_to_byte()		
		 		byte_to_int()		
		 		transporate()		
		 		squares_quantity()	
		 		central_squares()	
		\**/

#ifndef  _BOARD_H
#define  _BOARD_H

#ifndef  _LANG_H
#include "lang.h"
#endif

#define NDWRD 2				/* Number of double words per board */
#define NWORD 4				/* Number of words per board */
#define NBYTE 8				/* Number of bytes per board */

typedef struct {
  unsigned int a:1,b:1,c:1,d:1,e:1,f:1,g:1,h:1;
}			BITS;
typedef union {               		/* Define type register BOARD */
  DWRD dwrd[NDWRD];				/* Double word */
  WORD word[NWORD];				/* Single word */
  BYTE byte[NBYTE];				/* Byte */
  BITS bits[NBYTE];				/* Bits */
}			BOARD;

extern const BOARD null_board;		/* Dummy board */
extern const BOARD unit_board;		/* Unit board */

		/* Functions prototypes */

void NEAR copy(register BOARD *dest, const register BOARD *src);
				/* Copy board from src to dest */
void NEAR clear(register BOARD *dest);	/* Clear board */
void NEAR set(register BOARD *dest);	/* Set board */
int NEAR equal(const register BOARD *src, const register BOARD *src2);
				/* Are boards equal ? */
int NEAR nequal(const register BOARD *src, const register BOARD *src2);
				/* Are boards not equal ? */
void NEAR or(register BOARD *dest, const register BOARD *src);
				/* OR on boards, result is in dest */
void NEAR xor(register BOARD *dest, const register BOARD *src);
				/* XOR on boards, result is in dest */
void NEAR and(register BOARD *dest, const register BOARD *src);
				/* AND on boards, result is in dest */
void NEAR not(register BOARD *dest);	/* NOT on board, result is in dest */
void NEAR andnot(register BOARD *dest, const register BOARD *src);
				/* AND NOT on board, result is in dest */
void NEAR andnot3(register BOARD *dest, const register BOARD *src, const register BOARD *src2);
				/* AND NOT on board, result is in dest */
void NEAR or3(register BOARD *dest, const register BOARD *src, const register BOARD *src2);
				/* OR on boards, result is in dest */
void NEAR xor3(register BOARD *dest, const register BOARD *src, const register BOARD *src2);
				/* XOR on boards, result is in dest */
void NEAR and3(register BOARD *dest, const register BOARD *src, const register BOARD *src2);
				/* AND on boards, result is in dest */
void NEAR not2(register BOARD *dest, const register BOARD *src);
				/* NOT on board, result is in dest */
int NEAR empty(const register BOARD *src);	/* Are board empty ? */
int NEAR nempty(const register BOARD *src);	/* Are board not empty ? */
void NEAR high(register BOARD *dest);	/* Set units higher edge */
				/* (including edge),result is in dest */
void NEAR low(register BOARD *dest);	/* Set units lower  edge */
				/* (including edge),result is in dest */

#define NSQUARES 64
int NEAR board_to_int(const register BOARD *src);/* Convert BOARD to int */
extern const BOARD squares[NSQUARES];	/* Convert int to register BOARD */
#define int_to_board(x) squares[(x)]
extern BYTE bit_number[256];		/* Convert byte to int */
#define byte_to_int(x) bit_number[(x)]
extern const BYTE bytes[8];		/* Convert int to byte*/
#define int_to_byte(x) bytes[(x)]

void NEAR asr1(register BOARD *dest);	/* Arithmetic right shift on 1 */
void NEAR asl1(register BOARD *dest);	/* Arithmetic left  shift on 1 */
void NEAR asr7(register BOARD *dest);	/* Right shift on 7 */
void NEAR asr8(register BOARD *dest);	/* Right shift on 8 */
void NEAR asr9(register BOARD *dest);	/* Right shift on 9 */
void NEAR asl7(register BOARD *dest);	/* Left  shift on 7 */
void NEAR asl8(register BOARD *dest);	/* Left  shift on 8 */
void NEAR asl9(register BOARD *dest);	/* Left  shift on 9 */

void NEAR transporate (register BOARD *dest, const register BOARD *src);
				/* Transporate BOARD (x <--> y) */
int NEAR squares_quantity(const register BOARD *src);
				/* Return quantity of squares in register BOARD */
int NEAR central_squares(const register BOARD *src);
				/* Return quantity of central squares */

#ifndef __HUGE__

void NEAR copyf(register BOARD *dest, const register BOARD far *src);
				/* Copy board from src to dest */
				/* src is far !!!! */
void NEAR orf(register BOARD *dest, const register BOARD far *src);
				/* OR on boards, result is in dest, */
				/* src is far !!!! */
void NEAR andf(register BOARD *dest, const register BOARD far *src);
				/* AND on boards, result is in dest */
				/* src is far !!!! */
#else

#define copyf(dest, src) copy(dest, src)
#define orf(dest, src)   or(dest, src)
#define andf(dest, src)  and(dest, src)

#endif

#endif