#include <math.h>
#include "lang.h"
#include "chess.h"
#include "global.h"
#include "current.h"
#include "proc.h"
#include "gener.h"
#include "facelib.h"
#include "attacks.h"

static WORD near profitable( BYTE far * white_cost, BYTE far * black_cost );
static int near calc_squeze_att( void );
static int near calc_expand_att( void );
static int near calc_attackedby_to_profit( void );
static int near calc_attackedby_to_cost( void );
static void calc_att_to_prof( void );

#define NUM_COST (256*3)
#define NUM_SQUEZE (3*4*3*2*2)
#define ATTACKS_MAX_NUM 3
BYTE (far *attackedby_to_cost)[NUM_COST][10];
WORD (far *attackedby_to_profit)[NUM_SQUEZE*NUM_SQUEZE];
BYTE (far *squeze_att)[NUM_COST];
WORD (far *expand_att)[NUM_SQUEZE];

void NEAR calc_attack_arrays( void ){
  if( ! ( calc_attackedby_to_cost() && calc_expand_att() &&
          calc_attackedby_to_profit() && calc_squeze_att() ) )
    message("No memory for attack arrays",0);
}

static int near calc_squeze_att( void )
{
BYTE far * squezep;
int i;
  if( !((CFP)squeze_att=MYFARMALLOC(sizeof(*squeze_att))) )/*No memory */
    return 0;

  for(i=0,squezep=(*squeze_att);i<NUM_COST;i++,squezep++){
    *squezep=bit_quantity[ i & KING_MASK ];
    *squezep+=2*bit_quantity[ i & QUEEN_MASK ];
    *squezep+=2*2*bit_quantity[ i & ROOK_MASK ];
    *squezep+=2*2*3*bit_quantity[ i & BISHOP_KNIGHT_MASK ];
    *squezep+=2*2*3*4*( i >> 8 );
  }
  return 1;
}

static int near calc_expand_att( void )
{
WORD far * attp;
BYTE i,k;
  if( !((CFP)expand_att=MYFARMALLOC(sizeof(*expand_att))) )/*No memory */
    return 0;

  for(i=0,attp=(*expand_att);i<NUM_SQUEZE;i++,attp++){
    k=i;
    *attp = (k/(2*2*3*4))<<8;
    *attp|= BISHOP_KNIGHT_MASK & (BISHOP_KNIGHT_MASK>>(4-(k%=(2*2*3*4))/(2*2*3)));
    *attp|= ROOK_MASK & (ROOK_MASK>>(2-(k%=(2*2*3))/(2*2)));
    *attp|= QUEEN_MASK & ((k%=(2*2))&2);
    *attp|= KING_MASK & (k&1);
  }
  return 1;
}

static int near calc_attackedby_to_profit( void )
{
  if( !((CFP)attackedby_to_profit=MYFARMALLOC(sizeof(*attackedby_to_profit))) )
    return 0;
  return( 1+/*-1:er,0:ok<-*/read_write_array("kaissa.pft", calc_att_to_prof,
         (CFP)attackedby_to_profit, sizeof(*attackedby_to_profit)));
}

static void calc_att_to_prof( void )
{
int i;
BYTE far * white_costp, far * black_costp;

/*  FARMEMSET(*attackedby_to_profit,100/*IRREAL*/,sizeof(*attackedby_to_profit));*/
  for(i=0;i<NUM_SQUEZE*NUM_SQUEZE;i++){
    white_costp=(BYTE far * )(*attackedby_to_cost)[ (*expand_att)[ i % NUM_SQUEZE ] ];
    black_costp=(BYTE far * )(*attackedby_to_cost)[ (*expand_att)[ i / NUM_SQUEZE ] ];
    (*attackedby_to_profit)[i]=profitable(white_costp,black_costp);
  }
}

static int near calc_attackedby_to_cost( void )
{
unsigned i,j,k,l;
  if( !((CFP)attackedby_to_cost=MYFARMALLOC(sizeof(*attackedby_to_cost))) )
    return 0;
  FARMEMSET(*attackedby_to_cost,0,sizeof(*attackedby_to_cost));
  for(i=0;i<NUM_COST;i++){
    j=0;
    for(l=0;l<2;l++)
     if( (i>>8) > l )
       (*attackedby_to_cost)[i][j++]=PAWN_COST; /* pawns */
    for(k=128;k;k>>=1)
      if( k & i )(*attackedby_to_cost)[i][j++]=mask_to_cost(k);  /* pieces */
  }
  return 1;
}

static WORD near profitable( BYTE far * white_cost, BYTE far * black_cost )
{
int profw=0, profb=0, k;
int i;

  for(i=ATTACKS_MAX_NUM-1;i>=0;i--)
    if( white_cost[i] && black_cost[i] ) break;

  if( i<0) return 0;

  profw = ( black_cost[i+1] ) ? -white_cost[i] : 0;
  profb = ( white_cost[i+1] ) ? black_cost[i] : 0;

  for(; i>=0; i--){
    if( ( k = profw + black_cost[i] ) > 0 ) profw = k;
    else profw=0;
    if( i>0 ){
      if ( (k = profw - white_cost[i-1] ) < 0 ) profw = k;
      else profw=0;
    }
    if( ( k = profb - white_cost[i] ) < 0 ) profb = k;
    else profb=0;
    if( i>0 ){
      if ( (k = profb + black_cost[i-1] ) > 0 ) profb = k;
      else profb=0;
    }
  }
  if( abs(profw)>31 ) profw = (profw>0)? 31:-31;
  if( abs(profb)>31 ) profb = (profb>0)? 31:-31;
  return( profw + ( ( WORD )profb << 8 ) );
}

/*
static CFP cur_costp, our_costp, enemy_costp;

MAT_EVAL NEAR point_exchange(SQUARE_INFO *sqp)
{
MAT_EVAL profit=0;
PIECE_COLOR enemy_col;
WORD white_att, black_att;
CFP white_costp, black_costp;

  white_att = sqp->attackedby.word[WHITE_PIECE];
  black_att = sqp->attackedby.word[BLACK_PIECE];
  white_costp = ATTACKEDBY_TO_COST( white_att );
  black_costp = ATTACKEDBY_TO_COST( black_att );

  enemy_col=sqp->wood.color;
  cur_costp = &(char)sqp->wood.cost;
  (enemy_col) ?   (our_costp=white_costp,enemy_costp=black_costp) :
                    (our_costp=black_costp,enemy_costp=black_costp) ;
  while( profitable() ) {
    enemy_col = reverse_color( enemy_col );
    (enemy_col)? (profit += *cur_costp) : (profit -= *cur_costp);
  }

  return( profitable() );
}
*/
/*
void calc_hash_att( void )
{
int i;
SQUARE_NUM sq;
  for(sq=a1;sq<=h8;sq++){
    if(i=att_area[sq]){
      woodp=WHOONSQUARE(sq);
      /*if(woodp->name)*/
      HASH_ATT[i]^=rand_num->pieces[woodp->color][woodp->name][sq];
    }
  }
}

void fill_att_area( void )
{
  if( attaced(
  if( attack
}
int attack_link( SQUARE_INFO *sqp, PIECE_COLOR our )
unsigned i;
  enemy_color=reverse_color( our );
  for( cur_enemy_mask=QUEEN_MASK; cur_enemy_mask>0; cur_enemy_mask<<=1 ){
    if ( (cur_enemy_mask & sqp->attackedby.word[enemy] &
          ~sqp->marked.word[enemy] ){
       sqp->marked[enemy]|=cur_enemy_mask;
       attack_link( ,enemy );
     }
MAT_EVAL mat_eval_aprocs(MAT_EVAL *mat_delta,MAT_EVAL MAT_DEFICIT)
{
  int i;
  SQUARE_NUM cur_square,*prof_sqp;
  SQUARE_INFO *sqip;
  PIECE_NAME cur_name;
  WORD our_mask,enemy_mask;
  PIECE_IN_LIST *piecep;

  our=MOVE_COLOR,enemy=reverse_color(our);

  if( QUEEN_FLAG[our] || QUEEN_FLAG[enemy] ) return 0;   /* difficult calculate */
           /*Lose */
  for ( i=1,piecep=PIECE_LIST_FIRST(enemy)+1; i<NUM_PIECE;piecep++,i++) {
                                                   /* loop on enemy pieces */
    if ( (cur_square=piecep->where ) == DUMMY ) continue;      /* no piece */
    sqip=SQUAREP(cur_square);
    our_mask=sqip->attackedby.word[our];       /* our attacks on the piece */
    enemy_mask=sqip->attackedby.word[enemy];
    if ( !our_mask ) continue;
    if (>=MAT_DEFICIT)
  }
  if( i==NUM_PIECE ) return -1;

/*  prof_sqp[our]=prof_attack_square[our];*/
/*  for( i=0;i<TOTAL_NUM_PIECE;i++ )prof[i]=0;*/
  for ( i=1,piecep=PIECE_LIST_FIRST(enemy)+1; i<NUM_PIECE;piecep++,i++) {
                                                   /* loop on enemy pieces */
    if ( (cur_square=piecep->where ) == DUMMY ){     /* no piece */
      prof[i].cost=0;
      continue;
    }
    sqip=SQUAREP(cur_square);
    our_mask=sqip->attackedby.word[our];       /* our attacks on the piece */
    enemy_mask=sqip->attackedby.word[enemy];
/*    if ( !our_mask ) continue;*/
    enemy_piecep=&enemy_piece_list[1];  /* Skip king */
    pm=0x0002;                          /* Enemy piece mask */
    do {                                /* Enemy pieces loop */
      to=enemy_piecep->where;           /* Take enemy piece coordinate */
      if(to!=DUMMY) {                   /* Is enemy piece exist in piece list ? */
        top=SQUAREP(to);                /* Square information pointer */
        if(top->wood.cost>=mat_deficit) /* Can we capture this piece ? */
          go_to_square(to,top,0xFFFF,1);  /* Write attacks of all our pieces to */
    prof[i].who=sqip->wood.cost;
    prof[i][WHITE_PIECE].mask=minbit(attackedby.wordWHITE_PIECE];
    prof[i]
    prof[i].[]=minbit[1];
    cur_name=sqip->wood.name;                /* piece name */
    if ( our_mask > trans_mask[cur_name] || !enemy_mask ) {
                                /* definition of profitable attack*/
      *prof_sqp++=cur_square;
      if ( our_mask & PAWN_MASK && cur_name!=PAWN)   /*pawn attack piece*/
      evalp->ev_pawn_attack_enemy_piece+=pawn_attack_enemy_piece;
    }                                               /* if profitable */
  }                                                 /* for enemy pieces */
  *prof_sqp=DUMMY;
                  /* double profitable attacks (forks) */
  if ( *prof_attack_square!= DUMMY && *(prof_attack_square+1) != DUMMY){
    evalp->ev_double_profitable_attack+=double_profitable_attack;
    if ( WHOONSQUARE(*prof_attack_square)->name!=PAWN &&
         WHOONSQUARE(*(prof_attack_square+1))->name!=PAWN)
         evalp->ev_double_profitable_attack+=double_profitable_attack;
                /*Double profitable attack at pieces */
    }

}
*/
