#include "lang.h"
#if _CPU==386
#include "386.h"
#pragma inline
void *memcpy1(void *dest, const void *src, size_t n)
{
  asm {
    mov ax, ds
    mov es, ax
    mov di, dest
    mov si, src
    cld
    mov cx,n
    shr cx, 1
    jnc $+2+1
    movsb
//met1:
    shr cx, 1
    jnc $+2+1
    movsw
//met2:
    .386
    rep movsd
    .286
  }
  return dest;
}

void movecpy(MOVE *dest, const MOVE *src) /* 6 bytes */
{          /*
  *(((int*)dest)++)=*(((int*)src)++);
  *((long*)dest)=*((long*)src);
  return;*/

  asm {
    mov ax, ds
    mov es, ax
    mov di, dest
    mov si, src
    cld
    movsw    /* 2 byte */
    .386
    movsd    /* 4 byte */
    .286
  }
}

#endif