/*
	 ͻ
	              Making windows for interface                      
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <conio.h>           /* colors */
#include <stdio.h>           /* NULL */

#include "myface.h"
#include "faceproc.h"
#include "myfacpro.h"
#include "facekeys.h"
#include "facerr.h"
#include "facemous.h"
#include "facelib.h"
#include "faceega.h"

#include "iFACE.H"
#include "iMENUFUN.H"

#include "dbwind.h"
#include "dbbdraw.h"

#define MOVESTRLEN 8

WINP helpline, infowind, reply;
WINP tree, help;
WINP protocol, prot1, prot2;
WINDOW errorwindow;
WINP errors=&errorwindow;

#define ON +16*
#define FILEWNDLEN 33
static enum winddef{
  ERRORTOP=13, ERRORLEFT=7,  ERRORBOT=16,  ERRORRIGHT=65,
  DIALTOP=10,  DIALLEFT=20,  DIALBOT=16,   DIALRIGHT=60,
};

	/* attributes for monochrome adapter */
#define NORMATTR     ( GREEN ON BLACK )
#define INVERSEATTR  ( BLACK ON LIGHTGRAY )
#define HLIGHTATTR   ( WHITE ON BLACK )

unsigned char attribute[]={
/* editattr *********** editboard*******************************************/
   YELLOW ON CYAN,      WHITE ON CYAN,
/* menuattr *********** menubord ********** menucurr ***********************/
   BLACK ON LIGHTGRAY,  WHITE ON LIGHTGRAY, WHITE ON CYAN,
/* promptattr ********* promptbord ******** promptcurr *********************/
   BLACK ON LIGHTGRAY,  WHITE ON LIGHTGRAY, WHITE ON BLACK,
/* paneattr *********** panebord *******************************************/
   BLACK ON LIGHTGRAY,  BLACK ON LIGHTGRAY,
/* fieldattr ********** fieldbord ********* fieldcurr ****** fielditem *****/
   WHITE ON CYAN,       BLACK ON CYAN,      YELLOW ON BLUE,  YELLOW ON CYAN,
/* helpattr *********** helpbord ********** helpcurr ******* helpitem ******/
   WHITE ON CYAN,       BLACK ON CYAN,      YELLOW ON BLUE,  YELLOW ON CYAN,
/* graphattr ********** graphbord ********* graph1 ********* graph2 *********/
   WHITE ON LIGHTGRAY,  BLACK ON LIGHTGRAY, BROWN ON BLACK,  GREEN ON BLUE,
/* infoattr *********** infobord ********** infocurr ******* infoitem ******/
   YELLOW ON BLUE,      WHITE ON BLUE,
/* dialattr *********** dialbord ********** dialcurr ***********************/
   YELLOW ON LIGHTGRAY, BLACK ON LIGHTGRAY, WHITE ON CYAN,
};

typedef struct {
  WINP wp;                  /* pointer to window information */
  char *wname;              /* window name in file */
  char top, left, bott, right;     /* real window size */
  char type, roll, border;  /* window type, rolling and border */
  char attr, battr, curattr, itemattr; /* attributes */
  unsigned char strlen;     /* maximum string length */
  char menunum, menulen;    /* if w. is menu-type # of items and bar size */
  char *headstr;            /* head string */
  char open;                /* flag to open */
  char **text;				/* text to fill window */
} WND_INFO;

char *infotext[]={" KAISSA Debut Base Editor  ",NULL};

WND_INFO windows[]={
/* 1 */
{ NULL, "edit",		/* pointer to window information */
/*  13, 1, 24, 80,			/* real window size */*/
  12, 46, 24, 80,			/* real window size */
  MENU, 0, 1,				/* window type, rolling and border */
  DIALATTR, DIALBORD, INFOATTR, 0, /* attributes */
  120, 2, 14,				/* str length, # of items and bar size */
  " Edit Tree ",			/* head string */
  1,						/* flag to open */
  NULL,						/* text to fill window */
},
/* 2 */
{ NULL,"view",		/* pointer to window information */
  13, 47, 24, 80,			/* real window size */
  MENU, 0, 1,				/* window type, rolling and border */
  DIALATTR, DIALBORD, INFOATTR, 0, /* attributes */
  120, 2, 14,				/* str length, # of items and bar size */
  " View Tree ",			/* head string */
  0,						/* flag to open */
  NULL,						/* text to fill window */
},
/* 3 */
{ NULL, "cboard",/* wp, wname                   */
  3, 1, 21, 44,		/* top, left, bott, right      */
/*  2, 1, 12, 27,			/* top, left, bott, right	   */*/
  GRAPH, 0, 1,			/* type, roll, border */
  GRAPHATTR, GRAPHBORD, GRAPH1, GRAPH2, /* attributes */
  50, 2, 5,				/* str len, menunum, menulen */
  NULL,					/* headstr */
  1,					/* open */
  NULL,					/* text */
},
/* 4 */
{ NULL, "helpline",		/* wp, wname */
  25, 1, 25, 80,		/* top, left, bott, right */
  PANE, 0, 0,			/* type, roll, border */
  INFOATTR, 0, 0, 0,	/* attributes */
  100, 0, 0,			/* str len, menunum, menulen */
  NULL,					/* headstr */
  1,					/* open */
  NULL,					/* text */
},
/* 5 */
{ NULL, "info",			/* wp, wname */
  2, 1, 2, 80,			/* top, left, bott, right */
  PANE, 0, 0,			/* type, roll, border, */
  INFOATTR, 0, 0, 0, /* attributes */
  100, 0, 0,			/* str len, menunum, menulen */
  NULL,					/* headstr */
  1,					/* open */
  infotext,				/* text */
},
/* 6 */
  { NULL, "protocol1",	/* wp, wname */
  3, 46, 11, 80,		/* top, left, bott, right */
  MENU, 0, 1,	 		/* type, roll, border */
  DIALATTR, DIALBORD, DIALCURR, 0, /* attributes */
  40, 2, 15,				/* str len, menunum, menulen */
  " Protocol 1 ",		/* headstr */
  1,					/* open */
  NULL,					/* text */
},
/* 7 */
{ NULL, "protocol2",	/* wp, wname */
  4, 47, 11, 80,		/* top, left, bott, right */
  MENU, 0, 1,	 		/* type, roll, border */
  DIALATTR, DIALBORD, DIALCURR, 0, /* attributes */
  40, 2, 15,			/* str len, menunum, menulen */
  " Protocol 2 ",		/* headstr */
  0,					/* open */
  NULL,					/* text */
},
/* 8 */
{ NULL, "reply",		/* wp, wname */
  22, 1, 24, 44,		/* top, left, bott, right */
  EDIT, 0, 0,	 		/* type, roll, border */
  DIALATTR, DIALBORD, 0, 0, /* attributes */
  100, 0, 0,			/* str len, menunum, menulen */
  NULL,					/* headstr */
  1,					/* open */
  NULL,					/* text */
},
/* 9 */
{ NULL, "message",		/* wp, wname */
  7, 20, 19, 60,		/* top, left, bott, right */
  HELPPANE, 0, 1, 		/* type, roll, border */
  HELPATTR, HELPBORD, HELPCURR, HELPITEM, /* attributes */
  80, 0, 0,				/* str len, menunum, menulen */
  " Message ",			/* headstr */
  0,					/* open */
  NULL,					/* text */
},
/* 10 */
{ NULL, "help", 		/* wp, wname */
  4, 14, 21, 65,		/* top, left, bott, right */
  HELPPANE, 0, 1, 		/* type, roll, border */
  HELPATTR, HELPBORD, HELPCURR, HELPITEM, /* attributes */
  60, 0, 0,				/* str len, menunum, menulen */
  " Help ", 			/* headstr */
  0,					/* open */
  NULL,					/* text */
},
};
/*
static int near setmonocolors( void )
{
	attribute[MENUATTR]=NORMATTR;  attributes[MENUCURR]=INVERSEATTR;
	attributes[MENUBORD]=NORMATTR;
	attributes[INFOATTR]=INVERSEATTR;
	attributes[EDITATTR]=NORMATTR;  attributes[EDITBORD]=HLIGHTATTR;
	attributes[DIALATTR]=NORMATTR;  attributes[DIALCURR]=INVERSEATTR;
	attributes[DIALBORD]=NORMATTR;
	attributes[HELPATTR]=NORMATTR;   attributes[HELPCURR]=INVERSEATTR;
	attributes[HELPITEM]=HLIGHTATTR; attributes[HELPBORD]=NORMATTR;
	return(0);
}
*/

int makefilewnd( WINP wp, int top, int left, char *headstr )
{
	if( left+FILEWNDLEN>79 ) left=79-FILEWNDLEN; if( top+2>24 ) top=24-2;
	settype(wp, PROMPT );
	checkface( poswindow(wp,top,left,top+2,left+FILEWNDLEN) );/* position */
	setattr(wp, attribute[MENUATTR] );/* the color */
	setcurattr(wp, attribute[MENUCURR] );
	border(wp, TWOLINES, attribute[MENUBORD] );
	if( headstr ) checkface( header( wp, headstr ) );
	setstrlth( wp, 80 );
	setusemouse( wp );
	setupwind( wp );		/* goto the window beginning */
	return(checkface(0));
}

static int near makeerror(WINP wp)		/* make window */
{
	FARMEMSET(wp,0,sizeof (WINDOW)); /* setting it to zero */
	ATTR=YELLOW ON RED;		/* default attribute - green on black */
	TYPE=PANE;			/* default type - PANE */
	MAXLINE=80;			/* default string size */
	checkface( poswindow(wp,ERRORTOP,ERRORLEFT,ERRORBOT,ERRORRIGHT));/* position */
	setstrlth(wp,80);
	settype(wp,PANE );
	setattr(wp, WHITE ON RED );/* the color */
	border(wp, ONELINE, YELLOW ON RED );
	checkface( header( wp, " Base Editor Error ") );
	checkface( newline( wp," *** free string for other message *** " ) );
	checkface( newline( wp," *** free string for other message *** " ) );
	setupwind(wp);		/* goto the window beginning */
	return(checkface(0));
}
/*
int gethelp( int i )
{
 int far facemessage( CFP str1, CFP str2 );
	facemessage( " Help not avaliable. ", NULL );
	return(0);
}
*/
WINP makewindow( int index )
{
  WND_INFO *wip;
  WINP wp;
  char **strp;
	wip=windows+index-1;
	wp=getwindow();
	if( !wp ){ checkface(0); return( NULL ); }
/*	*(wip->wpp)=wp;*/
	if( checkface( poswindow(wp,wip->top,wip->left,wip->bott,wip->right) ) )
		return( NULL );
	settype(wp, wip->type );
	if( wip->type==GRAPH || wip->type==PANE )
		if( checkface( getstate(wp) ) ) return( NULL );
	setattr(wp, attribute[wip->attr] );/* color of window */
	if( wip->type==MENU || wip->type==HELPPANE || wip->type==GRAPH )
		setcurattr(wp, attribute[wip->curattr] );
	if( wip->type==HELPPANE ){
		setattrhelp( wp, attribute[wip->itemattr] );
        setpaged( wp );
    }
	if( wip->border )
		border(wp, wip->border, attribute[wip->battr] );
	if( wip->headstr )
		if( checkface( header(wp, wip->headstr )) ) return( NULL );
	if( wip->type==MENU )
		setmenu( wp, wip->menunum, wip->menulen );
	if( wip->roll )
		setrolling( wp, wip->roll );
	setstrlth( wp, wip->strlen );
	if( facerror ){ checkface(0); return( NULL ); }
	setupwind(wp);
	if( wip->type==GRAPH ){
		MAXLINE=attribute[wip->curattr];
		TNEGATTR=attribute[wip->itemattr];
		TCOLLTH=wip->menulen;
		TNCOL=wip->menunum;
		makedrboard( wp );
	}
	if( (strp=wip->text)!=NULL) {
	  while(*strp) {
		if( wip->type==HELPPANE )
			checkface( newlinehelp(wp, *strp,'<','>') );
		else checkface( newline(wp, *strp) );
		strp++;
	  }
	}
	if( wip->open )
		if( checkface( openwindow( wp ) ) ) return( NULL );
	return( wp );
}

void loadfont(int  numbytes);
extern int fontsize;

int makeface( void )
{
	detectadapter();
//	setfacefontfile("ch~0814.scf",EGA_FACE);
//	setfacemode(EGA_FACE);
	loadfont(fontsize);
	checkface( faceinitialize(20) );
	setbackground( '', BLACK ON LIGHTGRAY );
	resetmouse();
/*	settextcursor( SOFTTEXT, 0x7700, 0x77fe );*/
	settextcursor( SOFTTEXT, 0x7000, 0x0cfe );
	makeerror( errors );
	helpline=makewindow(4);
	infowind=makewindow(5);
	protocol =prot1=makewindow(6);
	prot2=makewindow(7);
	reply=makewindow(8);
	help=makewindow(10);
	return(checkface(0));
}

int closeface( void )
{
	loadfont(0);
	mouseintmask(0);
//	EGA_close();
	return(0);
}

