#include <dos.h>             /* intr() */
#include <stdio.h>
#include <io.h>              /* open(), close() */
#include <fcntl.h>           /* O_RDONLY.. */
#include <stdlib.h>
/*#include <errno.h>*/
#include "facelib.h"
#define OK     0
#define ERROR -1
#define BSHIFT 0x206
#define WSHIFT 0x200

void EGA_KAIS(int openflag, int numbytes, char far *startbyt);
char font14[70]="ch~0814.scf";
char font16[70]="ch~0816.scf";
char font8[80]="ch~0808.scf";
static char *fname;
static CFP bp;
static CFP startcp; /* pointer to first font char */

static int loadfontfile( int fh )
{
  int i, cb; /* current byte */
             /* get size of file */
	if( (i=(int)lseek( fh, 0L, SEEK_END ))==ERROR ) return(ERROR);
	if( !(bp=MYCALLOC( i, 1 )) ) return(ERROR); /* allocate memory */
	if( lseek( fh, 0L, SEEK_SET )==ERROR ) return(ERROR);
	if( MYREAD( fh, bp, i )==ERROR ) return(ERROR);
	cb=*( (int far *)(bp+BSHIFT) ) +WSHIFT; /* shift to end of font */
	startcp=bp+cb; /* begin of font should be 0x33f */
	while(1) if( *(bp+cb--)==3 ) break; /* find font begin */
	/* test */
	i=*(bp-1+cb); /* orientation: 0/1 */
	i=*(bp-3+cb); /* height:14  */
	i=*(bp-5+cb); /* weidht: 8  */
	return(OK);
}


void loadfont( int numbytes )
{
  int betafh; /* beta font file handler */
	if (!numbytes) {
		EGA_KAIS(1,0,startcp);
		return;
	}
	switch(numbytes) {
	  case 16: fname=font16; break;
	  case 14: fname=font14; break;
          case 8: fname=font8; break;
          default: return; 
	}
	if( (betafh=open( fname, O_RDONLY|O_BINARY ))==-1 ){
		printf( " Can't open file: %s", fname );
		return;
	}
	if (loadfontfile( betafh )==ERROR) {
			puts("No memory for the program");
			exit(1);
	}
	close( betafh );
	EGA_KAIS(0,numbytes,startcp);
	MYFREE( bp );
}

#define BYTEFIRST 128

void EGA_KAIS(int openflag, int numbytes, char far *startbyt)
{
  struct REGPACK reg;
  union REGS inregs,outregs;
  struct SREGS segs;
  static unsigned int prev_mode=3;
  static betaflag=0;
  static unsigned int bet_int_segment=0;
  static unsigned int bet_int_offset=0;
  static unsigned int old_int_segment = 0;
  static unsigned int old_int_offset = 0;

    if(openflag==0) {
      reg.r_ax=0x0F<<8;		/* Read current display mode (AH) */
      intr(0x10,&reg);
      prev_mode=reg.r_ax&0xFF;	/* store current mode as previous (AL) */
/*      if((reg.r_ax&0xFF)==7) {	/* Monochrome */
		puts("\n Hercules \n");
		return;
	  }*/
	  inregs.x.ax = 0xED00;   			/* Is BETA loaded ?*/
	  int86(0x2F,&inregs,&outregs);
	  if(outregs.h.al) betaflag=1;  	/* Yes */

	  if (betaflag) {
		inregs.x.ax = 0xEDC4;            	/* get old int 10h address */
		inregs.h.dl=0x10;					/* interrupt number */
		int86(0x2F,&inregs,&outregs);

		old_int_segment = outregs.x.dx;  /* address of old   */
		old_int_offset =  outregs.x.ax;  /* interrupt        */

		inregs.x.ax=0x3510;              /* get BETA int 10h address */
		intdosx(&inregs,&outregs,&segs);
		bet_int_segment=segs.es;
		bet_int_offset=outregs.x.bx;

		inregs.x.ax=0x2510;				/* reset old interrupt */
		inregs.x.dx = old_int_offset;
		segs.ds = old_int_segment;
		intdosx(&inregs, &outregs, &segs);
	  }
				/* now we can load chess font */
	  {		/* EGA/VGA */
	    reg.r_bx=0x30;
	    reg.r_ax=
	    (0x12<<8)+		/* select scan lines  for text mode (AH) */
	    (numbytes==16 ? 2 : (numbytes==14 ? 1: 0));	/* 400/350/200 lines (AL) */
	    intr(0x10,&reg);
	    /* if AL==0x12 then OK */
	  }
	  if(prev_mode!=7) {
	    reg.r_ax=0x03;		/* TEXT - mode  80x25 */
	    intr(0x10,&reg);
	  }
	  reg.r_ax=0;		/* load user font */
	  reg.r_cx=256-BYTEFIRST;/* total number of chars */
	  reg.r_dx=BYTEFIRST;	/* start offset */
	  reg.r_bx=
	    (numbytes<<8)+		/* bytes per char pattern (BH) */
	    0;			/* load to block 0 (may be needs 4 ) (BL) */
	  reg.r_es=FP_SEG(startbyt+BYTEFIRST*numbytes); /* seg addr of font */
	  reg.r_bp=FP_OFF(startbyt+BYTEFIRST*numbytes); /* off addr of font */
	  reg.r_ax=
	    (0x11<<8)+		/* load font (AH) */
	    0;			/* user-defined font (AL) */
      intr(0x10,&reg);
    }
	else {					/* reset old situation */
	  if (betaflag) {
		inregs.x.ax=0x2510;				/* reset BETA interrupt */
		inregs.x.dx = bet_int_offset;
		segs.ds = bet_int_segment;
		intdosx(&inregs, &outregs, &segs);
	  }

	  reg.r_ax=prev_mode;	/* AH=0 set mode function AL= mode */
	  intr(0x10,&reg);		/* reset previous display mode */
	  /*
	  ;	mov     ah,11h   ; load font
	  ;	mov 	al,1	 ; ROM-defined font
      ;	int     10h
      */
    }
}
