/*
	 ͻ
	                                                                
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <string.h>     /* strlen() */
#include <ctype.h>      /* isalnum() */
#include <stdlib.h>     /* itoa(),ltoa() */
#include <stdio.h>      /* sprintf() */
#include <conio.h>      /* colors... */

#include "myface.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facelib.h"
/*#include "lang.h"*/
/*#include "helpind.h"*/

#include "iFACE.H"
#include "iMENU.H"
#include "iMENUFUN.H"

#include "dbwind.h"

static int getmenuwindow( NODE *menup );
static int freemenuwindow( NODE *menup );
static int getmenuvar( NODE *menup, int item );
int leftedit( WINP wp );
int rightedit( WINP wp );
int keytoitem( NODE *menup,  int key );
int fillmenuitem( char *str, ITEM *itemp );
int showmenu( void );
int beginmenu( NODE *menup );
int endmenu( void );

#define ON +16*
#define MENUSTACKSIZE     7
static NODE *menustack[ MENUSTACKSIZE ];
static NODE * *menusp=menustack;
static int menulevel=0;
static char menubordline=TWOLINES;
/*
static char menuattr=BLACK ON LIGHTGRAY,
	menubord=BLACK ON LIGHTGRAY,
	menucurr=WHITE ON BLUE;
*/
extern NODE mainmenu;

int getcurm(WINP wp)
{
  int curx,cury,roll;
    curx=getcurx( wp )-1;
    cury=getcury( wp )-1;
    getrolling( wp, &roll );
    switch( roll ){
      case HROLL: return(curx);
      case VROLL: return(cury);
      case ROLL :;   /* don't need now */
    }
    return(-1);
}

int alttochar( int key )
{                      /*01234567890123456 */
  static char altkeys[]="1234567890-=####qwertyuiop[]##asdfghjkl;'`#\zxcvbnm,./";
	key=-key;
	if( key>=(-ALT_Q) && key<=(-ALT_M) ) key=altkeys[key];
	else if( key>=(-ALT_1) && key<=(-ALT_EQUAL) ) key=altkeys[key-(-ALT_1)];
	else key=0;              /* this isn't ALT-key */
	if( key=='#' ) key=0;    /* check */
	return(key);
}

int mainmenukey( int key )
{
	if( (key=alttochar( key ))==0 ) return(0);
	return( keytoitem( &mainmenu, key )!=ERROR );
}

int gotoitem( NODE *menup, int item )
{
	if( MENUROLL==HROLL ) checkface( posstate( MENUWP, 1, item+1 ) );
	if( MENUROLL==VROLL ) checkface( posstate( MENUWP, item+1, 1 ) );
	menup->curitem=item;
/*	checkface( refresh(MENUWP) ); window may not be opened */
	return(0);
}

static int getmenuwindow( NODE *menup )
{
  char buff[80];
  WINP wp;
  int i, maxlen, nitem, totlen, top, left;
  ITEM *itemp;
    if( (MENUWP=getwindow())==NULL ){
      checkface(0);
      return(ERROR);
    }
    settype(MENUWP,MENU);
	setattr(MENUWP, attribute[MENUATTR] );
	setcurattr(MENUWP, attribute[MENUCURR]);
	checkface( setrolling(MENUWP,MENUROLL) );
	nitem=maxlen=totlen=0;	             /* reset counters */
    for( i=0,itemp=MENUFIRSTITEM; ITEMNAME; i++, itemp++ ){
      fillmenuitem(buff,itemp);
      if( MENUROLL==HROLL ) checkface(putstring( MENUWP, buff ));
      else checkface(newline( MENUWP, buff ));
      i=strlen( buff );       /* get item name length */
      if( i>maxlen ) maxlen=i;       /* find max string length */
      totlen+=i;
      nitem++;                       /* increment counter */
    }
    if(!maxlen) totlen=maxlen=1;	/* Nothing in window */
    if( MENUROLL==HROLL ){
/*	  setstrlth( MENUWP, totlen +11);*/
	  checkface( setmenu(MENUWP, nitem, maxlen) );
	  i=poswindow(MENUWP,MENUTOP,MENULEFT,MENUTOP,MENULEFT+totlen+1);
	} else {
/*	  setstrlth( MENUWP, maxlen );*/
	  checkface( setmenu(MENUWP, 1, maxlen ) );
	  if( menulevel>0 ){
		  wp=(*(menusp-1))->wp;
		  top=UTOP+(CURY-1)+1;
		  left=ULEFT+(CURX-1)*TCOLLTH;
	  } else { top=MENUTOP; left=MENULEFT; }
	  if( top+nitem+1 > 24 ) top=24-nitem-1;
	  if( left+maxlen+1 > 80 ) left=80-maxlen-1;
	  MENUTOP=top; MENULEFT=left;
	  i=poswindow(MENUWP,top,left,top+nitem+1,left+maxlen+1);
	  border(MENUWP, menubordline, attribute[MENUBORD] );
    }
    checkface(i);
/*	checkface( keyfunc(MENUWP, testhotkey, BEFORE|AFTER ) );*/
	setupwind(MENUWP);
	gotoitem( menup, menup->curitem );
	checkface(openwindow(MENUWP));
/*    showmenu();*/
    return(0);
}

static int freemenuwindow( NODE *menup )
{
	checkface( closewindow( MENUWP ) );
	checkface( freewindow( MENUWP ) );
	MENUWP=NULL;
	return(0);
}

int menuup( void )
{
    CURMENUCURITEM=getcurm(CURMENUWP);
    if( menulevel==0) return(0);/* can't up */
    if( CURMENUFLAG & OPENCLOSE ) freemenuwindow( *menusp );
	*menusp=NULL;            /* clear stack */
	menusp--; menulevel--;
	/* openwindow(CURMENUWP); */
	showmenu();
	CURSTWP=CURMENUWP;       /* replace window in menu state */
	return(1);               /* up done */
}

int menudown( void )
{
    if( *(menusp+1)==NULL ) return(1); /* can not down */
    menusp++; menulevel++;
    if( CURMENUFLAG & OPENCLOSE ) getmenuwindow( *menusp );
    showmenu();
	CURSTWP=CURMENUWP;       /* replace window in menu state */
	return(1);               /* down done */
}

int beginmenu( NODE *menup )
{
   menulevel=0;
   menustack[0]=menup;
   menusp=menustack;
   if( CURMENUFLAG & OPENCLOSE ) getmenuwindow( *menusp );
   setcurattr( CURMENUWP, attribute[MENUCURR] );
/*   checkface(openwindow( CURMENUWP ));*/
   showmenu();
   return(0);
}

int beginmainmenu( ISP isp )
{
	beginmenu( &mainmenu );
/*	STWP=mainmenu.wp;       /* init state window */*/
	return(0);
}

int endmainmenu( ISP isp )
{
	endmenu();
	STWP=mainmenu.wp;       /* init state window */
	return(0);
}

int endmenu( void )
{
   while(menuup());
   setcurattr( CURMENUWP, attribute[MENUATTR] );
   checkface( refresh( CURMENUWP ) );
   if( CURMENUFLAG & OPENCLOSE ) freemenuwindow( *menusp );
   menusp=NULL;
   return(0);
}

int showmenu( void )
{
  int item;
	checkface( refresh(CURMENUWP) );
	item=getcurm(CURMENUWP);
	if( (CURITEMP)->helpline )
        sethelpcontext( (CURITEMP)->helpline, (CURITEMP)->helpkey );
	return(0);
}

int makemenu( ISP isp )		/* make the menu window */
{
  WINP menuground;
    menuground=getwindow();
    settype(menuground,PANE );
    poswindow(menuground,1,1,1,80);
	setattr(menuground, attribute[MENUATTR] );
/*    newline(menuground,"                                                                           ");*/
    setupwind(menuground);
    checkface(openwindow(menuground));
    getmenuwindow( &mainmenu );
	setcurattr( mainmenu.wp, attribute[MENUATTR] );
    checkface(openwindow( mainmenu.wp ));
	STWP=mainmenu.wp;
    return(0);
}

int keytoitem( NODE *menup, int key )
{
  int item;
  ITEM *itemp;
  char *cp;
	key=toupper(key);
	for(item=0,itemp=MENUFIRSTITEM; ITEMNAME; item++,itemp++) {
		cp=ITEMNAME;
		while(*cp) {
			if(*cp!=' ') {
				if(*cp==key) return( item );
				if( isupper(*cp) ) break;
			}
			cp++;
		}
	}
    return(ERROR);
}

int menuletter( int key )
{
  int i;
	if( !CURMENU ) return( 0 );
    if( isaltkey( key ) ){
        i=keytoitem( &mainmenu, alttochar( key ) );
        if( i!=-1 )
            while( menuup() );
    } else i=keytoitem( CURMENU, key );
	if( i==-1 ) return( 0 );
	gotoitem( CURMENU, i );
	checkface( refresh( CURMENUWP ) );
	return( RETURN );
}

static int arrow_key;

static int special_arrow_key(int key)
{
    if( ((key==LEFTARROW)||(key==RIGHTARROW)) ) {
        if(arrow_key) return 1;
        if(menulevel==1 && (CURMENUROLL==VROLL)
            && ((*(menusp-1))->flag&HROLL) )
		        return 1;
    }
    return 0;
}

int menuarrow( int key )
{
  ITEM *itemp;
  int item;
	if( special_arrow_key( key ) ){
	    if( !arrow_key ) menuup();
	    if( key==LEFTARROW ) checkface( leftedit( CURMENUWP ) );
	    else                 checkface( rightedit( CURMENUWP ) );
	    item=getcurm( CURMENUWP );
	    CURMENUCURITEM=item;
	    itemp=CURITEMP;
	    switch( ITEMTYPE & ITYPEMASK ){
	      case SUBMENU:
	      case LIST:
		    arrow_key=0;
		    *(menusp+1)=(NODE *)OBJECT;
		    menudown();
		    break;
	      case FUNCTION:
		    arrow_key=key;
	    }
    } else {
	    item=getcurm( CURMENUWP );
	    CURMENUCURITEM=item;
    }
    if( (CURITEMP)->helpline )
        sethelpcontext( (CURITEMP)->helpline, (CURITEMP)->helpkey );
	return(0);
}

int menuleftpress( void )
{
	return(0);
}

int menuescape( void ) /*** case ESCAPE: ******************/
{
  int i=0;
	if( menulevel==1 || menulevel==0 ) i=1; /* to quit menu state */
	else menuup();
	return(i);
}

int menureturn( void ) /*** case RETURN: ******************/
{
  NODE *menup;
  ITEM *itemp;
  int (*fp)(void);
  int item, type, i=0;
  char buff[80];
	menup=CURMENU;
	MENUCURITEM=item=getcurm( MENUWP );
	itemp=MENUFIRSTITEM+item;
	type=(ITEMTYPE & ITYPEMASK );
	switch( type ){
	  case SUBMENU: case LIST:
		menup=(NODE *)OBJECT;
		MENUCURITEM=*((int *)INFO);
		*(menusp+1)=menup;
		menudown();
		break;
	  case FUNCTION:
		if( (fp=FUNC)==NULL ) { i=-1; break; } /* Error */
		i=(*fp)();
		break;
	  case COMMAND: myungetch( (int)OBJECT );
		i=1;
		break;
	  case ON_OFF:  case YES_NO: case INT_NO: case INT: case LONG_NO:
	  case LONG:    case TIME:   case STR:    case OPTION:
		getmenuvar( menup, item );
		break;
	  default: i=-1;
	}          /* end flag switch */
	if( FUNC && !(type==FUNCTION) ){ /* fun exist but not used */
	  i=FUNC();
	}
	if( type==OPTION ) menuup();
	fillmenuitem(buff,CURMENUFIRSTITEM+CURMENUCURITEM);
	setcurmenu(CURMENUWP,buff);
	refresh(CURMENUWP);
	showmenu();
	return(i);
}

int fillmenuitem( char *name, ITEM *itemp )
{
  char buff[80];
	switch( ITEMTYPE & ITYPEMASK ) {
	  case ON_OFF: sprintf(name,ITEMNAME,*((int*)OBJECT)&((int)INFO)?"On":"Off"); break;
	  case YES_NO: sprintf(name,ITEMNAME,*((int*)OBJECT)&((int)INFO)?"Yes":"No"); break;
	  case INT_NO: sprintf(name,ITEMNAME,*((int*)OBJECT)?itoa(*((int*)OBJECT),buff,10):"No"); break;
	  case INT:    sprintf(name,ITEMNAME,*((int*)OBJECT)); break;
	  case LONG_NO: sprintf(name,ITEMNAME,*((long*)OBJECT)?ltoa(*((long*)OBJECT),buff,10):"No"); break;
	  case LONG:   sprintf(name,ITEMNAME,*((long*)OBJECT)); break;
	  case TIME:   sprintf(name,ITEMNAME,(int)((*(long*)OBJECT*55L+30000L)/60000L)); break;
	  case STR :   sprintf(name,ITEMNAME,(char*)OBJECT); break;
	  case LIST :  sprintf(name,ITEMNAME,
	( ((NODE *)OBJECT)->firstitem+(*(int *)INFO) )->itemname );
	break;
      default: sprintf(name,ITEMNAME); break;
    }
	return( 0 );
}

int getmenuvar( NODE *menup, int item )
{
  ITEM *itemp;
  int tmp;
	itemp=ITEMP;
	switch( ITEMTYPE & ITYPEMASK ){
	  case ON_OFF:
	  case YES_NO:
		if((*((int*)OBJECT))&((int)INFO))  /* if mask is set */
			*((int*)OBJECT)&=~((int)INFO); /* reset mask */
		else
			*((int*)OBJECT)|=((int)INFO);  /* set mask */
		break;
	  case INT_NO: if(*((int*)OBJECT)) /* if object not equal zero */
			{ *((int*)OBJECT)=0; break; }   /* let it to zero and break */
	  case INT:                   /* else enter new int value */
		getnumber(MENUTOP+item+2,MENULEFT+1,(int *)OBJECT,(char *)INFO);
		break;
	  case LONG_NO: if(*((long*)OBJECT))
		{ *((long*)OBJECT)=0L; break; }
	  case LONG:
		getlong(MENUTOP+item+2,MENULEFT+1,(long *)OBJECT,(char *)INFO);
		break;
	  case TIME: tmp=(int)((*((long*)OBJECT)*55L+30000L)/60000L);
		getnumber(MENUTOP+item+2,MENULEFT+1,&tmp,(char *)INFO);
		*((long*)OBJECT)=(tmp*60L*182L+5L)/10L;
		break;
	  case STR:
		getstring(MENUTOP+item+2,MENULEFT+1,(char *)OBJECT,(char *)INFO);
		break;
	  case OPTION:
		itemp=(*(menusp-1))->firstitem+((*(menusp-1))->curitem);
		*((int *)INFO)=item;
		break;
	}
	return(0);
}

int getstring( int top, int left, char *str, char *headstr )
{
  WINP wp;
  int ret=0;
	wp=getwindow();
	if( !wp ) return( ERROR );
	settype(wp,PROMPT);
	if( left+35>=80 ) left=79-35;
	if (top+2>=25) top=22;
	checkface(poswindow(wp,top,left,top+2,left+35));
	setattr(wp,attribute[MENUATTR]);
	setcurattr(wp,attribute[MENUCURR]);
	border(wp,menubordline,attribute[MENUBORD]);
	checkface(header(wp,headstr));
	if( str ) checkface(newline(wp,str));
	setusemouse(wp);
	ret=waitkey(wp);
	checkface(firstread(wp,str,40));
	checkface(freewindow(wp));
	return(ret);
}

int getnumber( int top, int left, int *num, char *headstr )
{
  char buff[40];
  int ret;
	ret=getstring(top,left,itoa(*num,buff,10),headstr);
	if(ret!=ESCAPE) {
	  if(sscanf(buff,"%d",num)<=0) return(ERROR);
	}
    return(ret);
}

int getlong( int top, int left, long *num, char *headstr )
{
  char buff[40];
  int ret;
    ret=getstring( top, left, ltoa(*num,buff,10), headstr );
    if(ret!=ESCAPE) {
      if(sscanf(buff,"%ld",num)<=0) return(ERROR);
    }
    return(ret);
}

