/*
	 ͻ
	                                                                
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <stdlib.h>          /* NULL */

#include "myface.h"
#include "faceproc.h"
#include "myfacpro.h"
#include "facekeys.h"

#include "lang.h"
#include "iFACE.H"
#include "iMENUFUN.H"

#include "dbase.h"
#include "dbproc.h"
#include "dbbdraw.h"

int gethelp( void );
int viewreply( void );
WINP makewindow( int index );
int far testhotkey( WINP wp, int key, int when );
int findstack( int key, ISP *ispp );
int openboard( ISP isp );
int closeboard( ISP isp );

int openstate( ISP isp )
{
  int btype, battr;
	getborder( STWP, &btype, &battr );
	border( STWP, TWOLINES, battr );
	openwindow( STWP );
	return(0);
}
int closestate( ISP isp )
{
  int btype, battr;
	getborder( STWP, &btype, &battr );
	border( STWP, ONELINE, battr );
	refresh( STWP );
	return(0);
}

int createstate( ISP isp )
{
	STWP=makewindow( STINDEX );
	return(0);
}
int opentree( ISP isp )
{
  int btype, battr;
	getborder( STWP, &btype, &battr );
	border( STWP, TWOLINES, battr );
	openwindow( STWP );
	showlevel();
	return(0);
}

extern ISTATE editst, viewst, boardst, menust;
static char far enter[]=" \21 Move ";
static char far link[]=" F5 Link ";
static char far bkspace[]=" BkSp Back ";
static char far delete[]=" Del Delete ";
static char far menu[]=" F10 Menu ";
static char far tab[]=" Tab board ";
static char far cursor[]=" \33\30\31\32 Navigate ";
static char far save[]=" F2 Save ";
static char far load[]=" F3 Open ";
//static char far []=;

KEYINFO globalkey[]={
  { ALT_X, NULL,  EXIT,     0, NULL, asktosave },
  { 0, NULL,  0, NULL, NULL }
};

KEYINFO editintkey[]={
  { F1,           NULL,      GETHELP, 0, NULL, gethelp },
  { CURSORKEY,    NULL,      FUNCALL, 0, NULL, updatenextlevel },
  { LEFTPRESS,    NULL,      FUNCALL, 0, NULL, updatenextlevel },
  { LEFTBUTTMOVE, NULL,      FUNCALL, 0, NULL, updatenextlevel },
  { F2,           NULL,      FUNCALL, 0, NULL, savebase },
  { F3,           NULL,      FUNCALL, 0, NULL, loadbase },
  { F4,           NULL,      FUNCALL, 0, NULL, inspect },
  { F5,           link,      FUNCALL, 0, NULL, makelink },
  { RETURN,       enter,     FUNCALL, 0, NULL, makemove },
  { LEFTRELEAS,   NULL,      FUNCALL, 0, NULL, makemove },
  { '+',          NULL,      FUNCALL, 0, NULL, makemove },
  { BACKSPACE,    bkspace,   FUNCALL, 0, NULL, makemoveback },
  { '-',          NULL,      FUNCALL, 0, NULL, makemoveback },
  { RIGHTRELEAS,  NULL,      FUNCALL, 0, NULL, makemoveback },
  { CTRL_B,       NULL,      FUNCALL, 0, NULL, togglebestmove },
  { '*',          " * Best ", FUNCALL, 0, NULL, togglebestmove },
  { DEL,          delete,    FUNCALL, 0, NULL, deletemove },
  { CTRL_F2,      NULL,      FUNCALL, 0, NULL, resetbase },
  { ALT_V,        NULL,      FUNCALL, 0, NULL, viewreply },
  { 0 }
};
KEYINFO editextkey[]={
  { ALT_X,     NULL,       EXIT,    0, NULL,   asktosave },
  { F6,        " F6 View ", REPLACE, 0, (DWORD)&viewst, changestack },
  { F10,       menu,       INSERT,  0, (DWORD)&menust, NULL },
  { TAB,       tab,        REPLACE, 0, (DWORD)&boardst, NULL },
  { ALTKEY,    NULL,       INSERT,  SAVEKEY, (DWORD)&menust, mainmenukey },
  { LEFTPRESS, NULL,       INSERT,  MOUSEST|SAVEKEY, (DWORD)&menust, NULL },
  { LEFTPRESS, NULL,       REPLACE, MOUSEST|SAVEKEY, NULL, NULL },
  { INS,       NULL,       REPLACE, 0, (DWORD)&boardst, NULL },
  { 0 }
};
ISTATE editst={
  NULL, 1,
  editintkey, editextkey,
  createstate, NULL,
  opentree, closestate,
  STONE, NULL,
  "edit",
};

KEYINFO viewintkey[]={
  { F1,           NULL,   GETHELP, 0, NULL, gethelp },
  { F2,           NULL,   FUNCALL, 0, NULL, savebase },
/*  { F3,         NULL,   FUNCALL, 0, NULL, loadbase },*/
  { F4,           NULL,   FUNCALL, 0, NULL, inspect },
  { F5,           link,   FUNCALL, 0, NULL, makelink },
  { CURSORKEY,    cursor, FUNCALL, 0, NULL, updatenextlevel },
  { LEFTPRESS,    NULL,   FUNCALL, 0, NULL, updatenextlevel },
  { LEFTBUTTMOVE, NULL,   FUNCALL, 0, NULL, updatenextlevel },
  { RETURN,       enter, FUNCALL, 0, NULL, makemove },
  { LEFTRELEAS,   NULL,   FUNCALL, 0, NULL, makemove },
  { '+',          NULL,   FUNCALL, 0, NULL, makemove },
  { BACKSPACE,    bkspace,FUNCALL, 0, NULL, makemoveback },
  { '-',          NULL,   FUNCALL, 0, NULL, makemoveback },
  { RIGHTRELEAS,  NULL,   FUNCALL, 0, NULL, makemoveback },
  { CTRL_F2,      NULL,   FUNCALL, 0, NULL, resetbase },
  { 0 }
};

KEYINFO viewextkey[]={
  { ALT_X,     NULL,       EXIT,     0, NULL,    asktosave },
  { F6,        " F6 Edit ", REPLACE,  0, (DWORD)&editst, changestack },
  { F10,       menu,       INSERT,   0, (DWORD)&menust, NULL },
  { TAB,       tab,        REPLACE,  0, (DWORD)&boardst, NULL },
  { ALTKEY,    NULL,       INSERT,   SAVEKEY, (DWORD)&menust, mainmenukey },
  { LEFTPRESS, NULL,       INSERT, MOUSEST|SAVEKEY, (DWORD)&menust, NULL },
  { LEFTPRESS, NULL,       REPLACE, MOUSEST|SAVEKEY, (DWORD)&editst, NULL },
  { LEFTPRESS, NULL,       REPLACE, MOUSEST|SAVEKEY, NULL, NULL },
  { 0, 0, NULL,  NULL, NULL }
};
ISTATE viewst={
  NULL, 2,
  viewintkey, viewextkey,
  createstate, NULL,
  opentree, closestate,
  STONE, NULL,
  "view",
};

KEYINFO boardintkey[]={
  { F1,        NULL,   GETHELP, 0, NULL, gethelp },
  { F2,        save,   FUNCALL, 0, NULL, savebase },
  { F3,        load,   FUNCALL, 0, NULL, loadbase },
  { MOUSEKEY,  NULL,   FUNCALL, 0, NULL, boardmouse },
  { CURSORKEY, cursor, FUNCALL, 0, NULL, boardcursor },
  { RETURN,    " \21 Take piece ",  FUNCALL, 0, NULL, boardspace },
  { SPACE,     NULL,  FUNCALL, 0, NULL, boardspace },
  { '+',       NULL,  FUNCALL, 0, NULL, makemove },
  { BACKSPACE, bkspace,  FUNCALL, 0, NULL, makemoveback },
  { '-',       NULL,  FUNCALL, 0, NULL, makemoveback },
  { 0 }
};
KEYINFO boardextkey[]={
  { ALT_X,     NULL,  EXIT,     0, NULL,    asktosave },
  { F10,       menu,  INSERT,   0, (DWORD)&menust, NULL },
  { TAB,       " Tab Tree ",  REPLACE,  USERST, NULL, findstack },
  { ALTKEY,    NULL, INSERT,   SAVEKEY, (DWORD)&menust, mainmenukey },
  { LEFTPRESS, NULL,  INSERT, MOUSEST|SAVEKEY, (DWORD)&menust, NULL },
  { LEFTPRESS, NULL,  REPLACE, MOUSEST|SKIPKEY, NULL, NULL },
  { 0 }
};
ISTATE boardst={
  NULL, 3,
  boardintkey, boardextkey,
  createstate, NULL,
  openboard, closeboard,
  0, NULL, /* not stone */
  "board",
};

KEYINFO intmenu[]={
  { F1, NULL,  GETHELP, 0, NULL, gethelp },
  { CURSORKEY, NULL,   FUNCALL, 0, NULL, menuarrow },
  { ALTKEY, NULL,  FUNCALL, 0, NULL, menuletter },
  { ALNUMKEY, NULL,  FUNCALL, 0, NULL, menuletter },
  { LEFTRELEAS, NULL,  NEWKEY, 0, RETURN, NULL },
  { 0 }
};
KEYINFO extmenu[]={
  { ALT_X,  NULL,  EXIT,   0, NULL, asktosave },
  { ESCAPE, NULL,  REMOVE, 0, NULL, menuescape },
  { RETURN, NULL,  REMOVE, 0, NULL, menureturn },
  { LEFTPRESS, NULL,  REMOVE, MOUSEST|SAVEKEY, NULL, NULL },
  { 0 }
};
ISTATE menust={
  NULL, 0,
  intmenu, extmenu,
  makemenu, NULL,
  beginmainmenu, endmainmenu,
  0, NULL,
  "menu"
};

KEYINFO intmsg[]={
  { F1, NULL,  GETHELP, 0, NULL, gethelp },
  { 0 }
};
KEYINFO extmsg[]={
  { ESCAPE, NULL,  REMOVE, 0, NULL, NULL },
  { RETURN, NULL,  REMOVE, 0, NULL, NULL },
  { 0 }
};
ISTATE messagest={
  NULL, 9,
  intmsg, extmsg,
  createstate, NULL,
  openstate, closestate,
  0, NULL,
  "message",
};

