/*
	 ͻ
	                                                                
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#ifndef _LANG_H
#include "lang.h"
#endif

#define isfacekey(key) ( (key)<0 && (key)>-256 )
#define mouseinwind(w,x,y) ( (y)>=(w)->wi.top && (y)<=(w)->wi.bottom && \
							(x)>=(w)->wi.left && (x)<=(w)->wi.right )
/*
typedef {
  dkYes, dkNo, dkCancel, dkOk,
} DIALOGKEY;
*/
typedef enum { /* key groups to user function proceed */
  ANYKEY=257,
  CURSORKEY=258, FUNKEY=259,   SHIFTKEY=260,
  CTRLKEY=261,   ALTKEY=262,   MOUSEKEY=263,
  ALNUMKEY=264,  ALPHAKEY=265, DIGITKEY=266,
} KEYGROUP;

typedef enum {   /*** state manager commands ***/
  NOCOM=0,		/* no command = end of list */
  NEWKEY,       /* replace key to KEYARG */
  EXIT,			/* exit from state manager */
  REMOVE,		/* quit state, and remove it from stack */
  REPLACE,		/* go to new state, replace old one in stack */
  INSERT,		/* go to new state, pust old one in stack */
  FUNCALL,		/* function must be called */
  GETHELP,		/* help function must be called with helpindex */
/*** special flags: *************************************************/
  SAVEKEY=0x0001,	/* save key for proceed in other state */
  DELSTATE=0x0002,	/* delete this state after dialog */
  USERST=0x0004,	/* to get new state from user */
  MOUSEST=0x0008,	/* to search new state by window and mouse */
  BEFORESTD=0x0010,	/* to call user before standart face, else after */
  SKIPKEY=0x0020,	/* to skip this key and all mouse key until b.pressing */
  CONDITION=0x0040, /* goto new state if user fun return true */
} KEYCOMMAND;

typedef struct {
  int key;			/* key to proceed from FACEKEYS and FACEMOUSE */
  char far *name;   /* name for command, will be placed into help line */
  char cmnd;		/* state manager command */
  int flag;			/* state manager flags */
  DWORD arg;	/* command argument */
  int (*fun)();		/* function to call */
} KEYINFO;
#define KEYKEY   kip->key
#define KEYCOM   kip->cmnd
#define KEYFLAG  kip->flag
#define KEYARG   kip->arg
#define KEYFUN   kip->fun

typedef enum { /*** State flags ***/
  STONE=0x01,	/* this state replace old one in stack ( not push ) */
  OPEN= 0x02,   /* bit set = state already opened, else closed */
  EXIST=0x04,   /* bit set = state already exist, else must be created */

} STATEFLAG;

typedef struct istate {
  WINP wp;              /* window for dialog */
  char index;           /* index to make window */
  KEYINFO *internkey;   /* list of internal keys of state */
  KEYINFO *externkey;	/* list of external keys of state */
  int (*create)();		/* function to create this state */
  int (*delete)();		/* function to delete this state */
  int (*open)();		/* function to open state */
  int (*close)();		/* function to close state */
/*  struct istate *parent; /* parent of this state */
  struct istate *child;  /* child of this state */*/
  int flag;             /* state flag */
  char far *helpline;   /* */
  char far *helpkey;    /* key for search in help file */
} ISTATE;
typedef ISTATE *ISP;

#define STWP       isp->wp
#define STTYPE     isp->wp->wi.type
#define STINDEX    isp->index
#define STWAITKEY  isp->waitkeyfun
#define STHOTKEY   isp->hotkeyfun
#define STINTERN   isp->internkey
#define STEXTERN   isp->externkey
#define STOPEN     isp->open
#define STCLOSE    isp->close
#define STCREATE   isp->create
#define STDELETE   isp->delete
#define STFLAG     isp->flag
#define STHELPLINE isp->helpline
#define STHELPKEY  isp->helpkey

#define CURSTATE      (*istackp)
#define CURSTTYPE     (*istackp)->wp->wi.type
#define CURSTINDEX    (*istackp)->index
#define CURSTWP       (*istackp)->wp
#define CURSTWAITKEY  (*istackp)->waitkeyfun
#define CURSTHOTKEY   (*istackp)->hotkeyfun
#define CURSTINTERN   (*istackp)->internkey
#define CURSTEXTERN   (*istackp)->externkey
#define CURSTOPEN     (*istackp)->open
#define CURSTCLOSE    (*istackp)->close
#define CURSTCREATE   (*istackp)->create
#define CURSTDELETE   (*istackp)->delete
#define CURSTFLAG     (*istackp)->flag
#define CURSTHELPLINE (*istackp)->helpline
#define CURSTHELPKEY  (*istackp)->helpkey

int statemanager( void ); /* main state manager function */
int registerstate( ISP isp );
int sethelpcontext( CFP helpline, CFP helpkey );
extern ISP *istackp;
