/*
	 ͻ
	                                                                
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <stdlib.h>
#include <mem.h>             /* memcpy() */
#include <string.h>          /* ONLY strncat() */

#include "myface.h"
#include "faceproc.h"
#include "myfacpro.h"
#include "facelib.h"
#include "facekeys.h"
#include "facemous.h"
#include "facerr.h"
#include "dbwind.h"

#include "iFACE.H"
#include "iMENUFUN.H"

typedef struct {
  WINP wp;
  ISP isp;
} ITABLE;

static int near initstate( void );
static int near remove_state( void );
static int near replace_state( ISP isp );
static int near insert_state( ISP isp );
static ISP near findstate( int x, int y );
static KEYINFO * near findkey( KEYINFO *kip, int key, int findflag );
static int near activewindow( WINP wp );
static int near preparewindow( WINP wp );
static int near createhelpline( ISP isp );

#define TABLESIZE 16
#define STACKSIZE 6
extern KEYINFO globalkey[];
extern ISTATE menust;

static ISP istack[STACKSIZE]; /* Interface State Manager's stack */
ISP *istackp;          /* stack pointer */
static ITABLE itable[TABLESIZE];
ITABLE *itabp=itable;

static int near close_state( ISP isp )
{
  int i;
  int (*fun)(ISP);
	if( (fun=STCLOSE)!=NULL ) i=fun(isp); /* close fun exits -> close state */
	STFLAG &= ~OPEN;			/* now state is closed */
	return(i);
}
static int near open_state( ISP isp )
{
  int i;
  int (*fun)(ISP);
	if( (fun=STOPEN)!=NULL )
		i=fun(isp);   /* open state */
	STFLAG |= OPEN;               /* now state is opened */
	return(i);
}
static int near create_state( ISP isp )
{
  int i;
  int (*fun)(ISP);
	if( (fun=STCREATE)!=NULL ) i=fun(isp);
	STFLAG |= EXIST;
	return(i);
}
static int near delete_state( ISP isp )
{
  int i;
  int (*fun)(ISP);
	if( (fun=STDELETE)!=NULL ) i=fun(isp);
	STFLAG &= ~EXIST;
	return(i);
}

int registerstate( ISP isp )
{
  ITABLE *itp;
	if( !isp ) return(-1);
	itp=itable;
	while( itp->isp!=NULL ){
		if( ++itp>itable+TABLESIZE ) return(-1);
	}
	create_state( isp );
	itp->isp=isp; itp->wp=isp->wp;
	itabp=itp;
	return(0);
}

static int near initstate( void )
{
	istack[0]=itabp->isp;         /* get first element from state list */
	istackp=istack;               /* reset stack pointer */
	if( !(CURSTFLAG & EXIST) )      /* if state not exist */
		create_state( CURSTATE ); /* create this state */
	if( !(CURSTFLAG & OPEN) )       /* if state not opened */
		open_state( CURSTATE );   /* open this state */
	return(0);
}

static int near remove_state( void )
{
	if( istackp==istack )         /* stack level==0, can't move down */
		{ return(-1); }           /* state not changed */
	if( CURSTFLAG & OPEN )          /* if state opened */
		close_state( CURSTATE );
	istackp--;                    /* shift stack pointer */
	return(0);
}

static int near replace_state( ISP isp )
{
	if( CURSTFLAG & OPEN )          /* if state opened */
		close_state( CURSTATE );   /* close state */
	CURSTATE=isp;                 /* replace stone state */
	if( !(CURSTFLAG & EXIST) )      /* if state not exist */
		create_state( CURSTATE ); /* create this state */
	if( !(CURSTFLAG & OPEN) )       /* if state not opened */
		open_state( CURSTATE );   /* open this state */
	return(0);
}

static int near insert_state( ISP isp )
{
	if( (++istackp)>(istack+STACKSIZE) ) /* stack overflow */
		{ istackp--; return(-1); }
	CURSTATE=isp;             /* init */
	if( !(CURSTFLAG & EXIST) )  /* if state not exist */
		create_state( CURSTATE ); /* create this state */
	if( !(CURSTFLAG & OPEN) )   /* if state not opened */
		open_state( CURSTATE ); /* open this state */
	return(0);
}

static ISP near findstate( int x, int y )
{
  ITABLE *itp;
  WINP wp;
	wp=whatwindow( &y, &x );      /* in what window mouse is .. */
	if( wp==NULL ) return( NULL ); /* mouse not in window */
	itp=itable;                   /* get pointer to state table */
	while( itp<itable+TABLESIZE ){ /* find state with this window */
		if( itp->wp==wp ) return( itp->isp ); /* state found */
		itp++;                   /* get next state */
	}
	return( NULL );               /* no state with this window */
}

static ISP near mousestate( void )
{
  ISP isp;                        /* interface state pointer */
  int x, y;                       /* mouse location */
	getmouseloc( &x, &y );        /* get mouse location */
	isp=findstate( x, y );        /* find corresp. state (use window) */
	if( isp==CURSTATE ) return( NULL ); /* mouse in current window */
	return(isp);
}

static KEYINFO * near findkey( KEYINFO *first, int key, int findflag )
{
  static KEYINFO *oldfirst=NULL, *kip=NULL;
  register int curkey;
	if( !first ) return( NULL );
	if( findflag && oldfirst==first ){} /* start from old current */
	else { oldfirst=kip=first; } /* start from begining */
	while( (curkey=KEYKEY)!=0 ){ /* search key in key info array */
		if( curkey==key || curkey==ANYKEY ) return( kip++ );
		else if( iscurskey( key ) && curkey==CURSORKEY ) return( kip++ );
		else if( isfunkey( key ) && curkey==FUNKEY ) return( kip++ );
		else if( isshiftkey( key ) && curkey==SHIFTKEY ) return( kip++ );
		else if( isctrlkey( key ) && curkey==CTRLKEY ) return( kip++ );
		else if( isaltkey( key ) && curkey==ALTKEY ) return( kip++ );
		else if( ismousekey( key ) && curkey==MOUSEKEY ) return( kip++ );
		else if( !isfacekey( key ) ){
			if( isalnum( key ) && curkey==ALNUMKEY ) return( kip++ );
			else if( isalpha( key ) && curkey==ALPHAKEY ) return( kip++ );
			else if( isdigit( key ) && curkey==DIGITKEY ) return( kip++ );
		}
		kip++;
	}
	return( NULL );
}

static int near internalkey( int key )
{
  int x, y, i=0, oldkey, fcall=0, type;
  KEYINFO *kip;
	int (*fun)(int)=NULL;                /* function corresp. this key */
	if( ismousekey(key) ){             /* this is mouse key */
		getmouseloc( &x, &y );         /* get mouse location */
		if( !mouseinwind( CURSTWP, x, y) ) /* this is external mouse key */
			return( key );             /* quit proceeding */
	}
	oldkey=key;                        /* save old key */
	kip=findkey( CURSTINTERN, oldkey, 0 ); /* find first key */
	while( kip ){                      /* while key info exist */
		switch( KEYCOM ){              /* switch key command is */
		  case GETHELP:     /* function to call */
	        if( KEYFUN!=NULL ) KEYFUN( CURSTHELPKEY );
            return 0;
		  case FUNCALL: fun=KEYFUN;    /* function to call */
			fcall=(KEYFLAG & BEFORESTD); /* call flag: before std or after */
			break;
		  case NEWKEY: key=(int)KEYARG; break; /* replace key to new one */
		  default: break;
		}
		kip=findkey( CURSTINTERN, oldkey, 1 ); /* find next key */
	}
	if( fcall && fun )         /* call user before FACE standart */
		if( (i=fun( oldkey ))!=0 ) key=i;
	checkface( gettype( CURSTWP, &type ) );
	if( type!=GRAPH )
		if( (i=proceedfacekey( CURSTWP, key ))==ERROR ) /* call FACE */
			checkface(i);
	if( !fcall && fun )        /* call user after FACE standart */
		if( (i=fun( oldkey ))!=0 ) key=i;
	return( key );
}

static int near checkkey( int key, KEYINFO *kip )
{
  ISP newst;
  ISP isp=NULL;
  int (*fun)( int key, ISP *ispp );
	if( KEYFLAG & MOUSEST ){
		newst=mousestate();
		if( newst==NULL ) return(ERROR);
		if( KEYARG && newst!=(ISP)KEYARG ) return(ERROR);
		KEYARG=(DWORD)newst;
	}
	if( KEYFLAG & USERST ){
		if( (fun=KEYFUN)!=NULL ){
			fun( key, &isp );
			if( isp!=NULL ) KEYARG=(DWORD)isp; else return(ERROR);
		} else return(ERROR);
	}
	return(0);
}

static int near externalkey( int key )
{
  int x, y, done=0, i;
  KEYINFO *kip, ki;
  int (*fun)( int key );
	if( ismousekey(key) ){             /* if key is mouse one */
		getmouseloc( &x, &y );         /* check mouse out of window */
		if( mouseinwind( CURSTWP, x, y ) ) return(0);
	}
	kip=findkey( CURSTEXTERN, key, 0 ); /* find first key */
	while( kip && !done ){
	  memcpy( &ki, kip, sizeof( KEYINFO ) ); /* save this key info */
	  kip=&ki;
	  if( checkkey( key, kip )==OK ){
		  if( (fun=KEYFUN)==NULL || (KEYFLAG & USERST) ) i=1; /* no function */
			  else i=fun( key );     /* call user fun() */
		  if( i ){
			if( KEYFLAG & SAVEKEY ) myungetch( key ); /* save current key */
			if( KEYFLAG & SKIPKEY ) skipmousuntil( LOC_CH|LEFT_PR|RIGHT_PR );
		  }
		  switch( KEYCOM ){
			case REMOVE:             /* quit current state */
			  if( i ){ remove_state(); done=1; }
			  break;
			case REPLACE:            /* change state */
			  if( i && KEYARG ){ replace_state( (ISP)KEYARG ); done=1; }
			  break;
			case INSERT:             /* change state */
			  if( i && KEYARG ){ insert_state( (ISP)KEYARG ); done=1; }
			  break;
			case FUNCALL: done=1; break;
			case EXIT:    return( key ); /* exit from state manager */
			default: break;
		  } /* end of switch */
		  if( done && CURSTWP ){
			  activewindow( CURSTWP );
			  break;                 /* break from while */
		  }
	  } /* end of checkkey()==OK */
	  kip=findkey( CURSTEXTERN, key, 1 ); /* find next key */
	} /* end of while( kip )... */
	return(0);
}

int statemanager( void )
{
  int key, i, done=0;
	initstate();                  /* init stacks, get first state from list */
	if( CURSTWP ) activewindow( CURSTWP );
	while(!done){                 /* while not EXIT command */
        if( !CURSTHELPLINE ) createhelpline( CURSTATE );
            else puthelpline( CURSTHELPLINE );
		if( CURSTWP ) preparewindow( CURSTWP );
		key=getfacekey();
		if( (key=internalkey( key ))==OK ) continue;
		if( (i=externalkey( key ))!=OK ){ done=i; break; }
	}
	return(done);
}

static int near activewindow( WINP wp )
{
	if( freezed ) faceunfreeze(NULL);
	checkface( openwindow( wp ) );
	checkface( refresh( wp ) );
	if( !TEXT && !ISGRAPH )
		{ facerror=WRONGCALL; checkface(0); }
	WSTATUS &= ~RESIZED;
	if( TEXT ) TFLAGS &= ~TOSAVE;
	if( ISDEFAULT ){ WSTATUS |= BEGSEARCH ; WSTATUS &= ~WRITTEN; }
	return(0);
}

static int near preparewindow( WINP wp )
{
	if ((ISANYEDIT) && !(WSTATUS & BEGSEARCH)) {
		setcurs(CURY+UTOP-2,CURX+ULEFT-2);
	} else hidecurs();
	if( ismouse ){
		if (!(ISGRAPH) && (WSTATUS & USEMOUSE))
			makemouseborder(wp);
		enablecursor(); /* restore cursor */
	}
	return(0);
}

static int near createhelpline( ISP isp )
{
  char str[80+1]="";
  KEYINFO *kip;
  int totlen=0, len;
    if( (kip=STINTERN)!=NULL ){
        while( KEYKEY && totlen<80 ){
            if( kip->name ){
                len = FARSTRLEN( kip->name );
                if( totlen+len > 80 ) break;
                _fstrncat( str, kip->name, len );
                totlen+=len;
            }
            kip++;
        }
    }
    if( (kip=STEXTERN)!=NULL ){
        while( KEYKEY && totlen<80 ){
            if( kip->name ){
                len = FARSTRLEN( kip->name );
                if( totlen+len > 80 ) break;
                _fstrncat( str, kip->name, len );
                totlen+=len;
            }
            kip++;
        }
    }
    if( ! *str ){ puthelpline(" "); return 0; }  // no help line
    STHELPLINE=MYFARMALLOC( totlen+1 );
    if( !STHELPLINE ) return 0;
    FARSTRCPY( STHELPLINE, str );
    puthelpline( STHELPLINE );
    return 0;
}

int sethelpcontext( CFP helpline, CFP helpkey )
{
    if( helpline ) CURSTHELPLINE=helpline;
    if( helpkey  ) CURSTHELPKEY=helpkey;
    return 0;
}

