/*
	 ͻ
	           Implementation of Hash algorithm                     
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <stdio.h>           /* puts() */
#include <string.h>          /* strcpy() */
#include <dir.h>             /* fnmerge(), fnsplit() */
#include <mem.h>             /* memcpy(), memcmp() */

/********************** Must be changed *************************/

#define HASHSIZE 997         /* must be prime number */
#define KEYSIZE   32         /* size of identificator */
#define INFOSIZE  sizeof( HASHINFO ) /* size of hash information */
#define NULLKEY   nullkey    /* definition of null key */

typedef struct {
	char k[ KEYSIZE+1 ];
} HASHKEY;

typedef struct{
	int i;
} HASHINFO;

typedef unsigned int HASHFREQ;

#define  TABLEKEY  hashtable[hi].key                          /* key in hash table */
#define  TABLEINFO hashtable[hi].info                         /* info in hash table */
#define  TABLEFREQ hashtable[hi].freq                         /* freq in hash table */
#define  MAXCOLLISION  5

typedef struct {
	HASHKEY  key;
	HASHINFO info;
	HASHFREQ freq;
} HASHPIECE;                                                       -

long cur_item_number,max_item;

static HASHPIECE hashtable[HASHSIZE];
static char nullkey[ sizeof(HASHKEY) ]="\0";

static int near alloc_hash_memory ( void )                  /* return max number of items in hash  */
{
   long total_size;
   HASHPIECE *hashp;

	 total_size=farcoreleft();
	 if (total_size==0)  return(1);
	 max_item=(total_size % sizeof(HASHPIECE));
	 hash_size=prime(max_item);
	 hasp=farcalloc(max_item,sizeof(HASHPIECE));
	 return (max_item);
}
static int near hash( HASHKEY *key )                         /* hash function implementation */
{
  int i=0, s=0;
  char *cp;
	cp=(char *)key;
	while( *cp && i<KEYSIZE )                                 /* add all bytes of key */
		{ s+=*cp++; i++; }
	return( s % HASHSIZE );                                   /* get index in hash table */
}


int puthash( HASHKEY *key, HASHINFO *info)
{
  int hi;                                                     /* hash index */
  int i=0;                                                    /* step counter */
  HASHFREQ minfreq=MAXINT;
  int minhi;

	if ( cur_item_number > max_item)                          /* hash is full */
	return(1);
	hi=hash( key );                                           /* hashing the key */
	while( memcmp( &TABLEKEY,NULLKEY,KEYSIZE ) ) {
		if( memcmp( &TABLEKEY,key,KEYSIZE ) ) {               /* given key founded */
		   TABLEFREQ++;
		   return(1);
		}
		if(minfreq<TABLEFREQ) {
		  minfreq=TABLEFREQ;
		  minhi=hi;
        }
		i++;
		if(i==MAXCOLLISION) {                             /* Replace */
		  hi=minhi;
		  break;
		}
		hi+=i;                                            /* get new hash index */
		hi=(hi*hi)% hash_size;                            /* new hi= ( prev hi + i )^2 */
	}
														  /* Add */
	memcpy( &TABLEKEY,  key,  KEYSIZE );
	memcpy( &TABLEINFO, info, INFOSIZE );
	cur_item_num++;
	return(0);
}

int gethash( HASHKEY *key, HASHINFO *info )
{
  int hi;                                                /* hash index */
  int i=0;                                               /* step counter */
	hi=hash( key );                                      /* hashing the key */
	while( memcmp( &TABLEKEY, key, KEYSIZE ) ){
		if( memcmp( &TABLEKEY, NULLKEY, KEYSIZE ) )      /* given key not found */
			return(1);                           /* */
		if( i>HASHSIZE ){ puts(" Hash full"); return(1); }
		hi+=i;               /* get new hash index */
		hi=(hi*hi)%HASHSIZE; /* new hi= ( prev hi + i )^2 */
	}
	memcpy( info, &TABLEINFO, INFOSIZE );
	return(0);
}


char infn[80]="", outfn[80]="";

int search( char *str )
{
	return(0);
}

getstring()
{
  FILE *infp, *outfp;
  char buff[100+1];
	infp=fopen( infn, "r" );
	while( fgets( buff, 100, infp ) ){

	}
	return(0);
}

main( argc, argv )
char **argv;
int argc;
{
  char drive[4], dir[70], name[13], ext[5];

	if( !argc ){ puts(" Error: No input file"); return(1); }
	fnsplit( argv[1], drive, dir, name, ext );
	if( *ext=='\0' ){ ext[0]='.'; ext[1]='c'; ext[2]='\0'; }
	fnmerge( infn, drive, dir, name, ext );
	if( argc>=2 ) strcpy( outfn, argv[2] );
	search();
	return(0);
}

static long near prime( long number )
{
long i;
unsigned j;

  if( !(number&1) ) number--;
  for(i=number; i>3 ; i-=2) {
	for (j=3;(long)j*j<=i; j+=2)
      if ( ! (i%j) ) break;
    if( (long)j*j>i ) break;
  }
  return i;
}


