/*
	 ͻ
	          Generation of moves from position int Move stack      
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <stdlib.h>               /* NULL */
#include "dbchess.h"
#include "dbase.h"
#include "dbmove.h"

typedef enum {
	LEFT_UP_DIR=0,   UP_DIR=1,         RIGHT_UP_DIR=2,
	RIGHT_DIR=3,     RIGHT_DOWN_DIR=4, DOWN_DIR=5,
	LEFT_DOWN_DIR=6, LEFT_DIR=7,
} GENDIR;

#define MSTACKSIZE ( 40 * 50 * 2 ) /*   moves * stacksize * stacknum  */
MOVE movestack[MSTACKSIZE];
static MOVE *curmp=movestack;
PIECE_COLOR our_color, enemy_color;

int writemove( SQUARE_NUM from, SQUARE_NUM to, int flag )
{
	curmp->from=from; curmp->to=to;
	curmp->flags=flag; curmp++;
	return(0);
}

int writedir( SQUARE_NUM from, GENDIR dir )
{
  SQUARE_INFO *sqp;
  SQUARE_NUM sq, edge;
  int shift, i=0;
	sqp=&SQUARE[from];
	edge=sqp->edge[dir];
	if( edge==from ) return(0);
	shift=increment[dir];
	if( SQUARE[edge].wood.color==our_color ) edge-=shift;
	if( edge==from ) return(0);
	sq=from+shift;
	while(1){
		writemove( from, sq, 0 ); i++;
		if( sq==edge ) break;
		sq+=shift;
	}
	return( i );
}

int genrook( SQUARE_NUM from )
{
  GENDIR dir;
  int i=0;
	for( dir=UP_DIR; dir<=LEFT_DIR; dir+=2 ){
		i+=writedir( from, dir );
	}
	return(i);
}

int genbishop( SQUARE_NUM from )
{
  GENDIR dir;
  int i=0;
	for( dir=LEFT_UP_DIR; dir<=LEFT_DIR; dir+=2 ){
		i+=writedir( from, dir );
	}
	return(i);
}

int gencastles( void ) /* Generate castles */
{
  SQUARE_NUM line;                /* Begin of first/last line coordinate */
  SQUARE_INFO *linep;		      /* Pointer to square information */
  int i=0;
	enemy_color=REVCOLOR( our_color );
	line=(our_color==WHITE_PIECE)? a1: a8;/* Take begin of line */
	linep=&SQUARE[line];		  /* Take pointer to square informtion */
	if( CASTLE[our_color] & CASTLERIGHT ){  /* Consider right castle */
		if( !(linep[f1].attackedby.word[enemy_color]| /* Check attaked squares */
			  linep[g1].attackedby.word[enemy_color]) )
			if(!(linep[f1].wood.cost| /* Check occupated squares */
				 linep[g1].wood.cost))
					{ writemove( line+e1, line+g1, CASTLE_RIGHT ); i++; }
					/* Write move and shift move pointer */
	}
	if( CASTLE[our_color] & CASTLELEFT ){ /* Consider left castle */
		if(!(linep[c1].attackedby.word[enemy_color]| /* Check attaked squares */
			 linep[d1].attackedby.word[enemy_color]))
				if(!(linep[b1].wood.cost| /* Check occupated squares */
					 linep[c1].wood.cost|
					 linep[d1].wood.cost))
						{ writemove( line+e1, line+g1, CASTLE_LEFT ); i++; }
						/* Write move and shift move pointer */
	}
	return( i );
}

int genking( SQUARE_NUM from )
{
  SQUARE_NUM to;
  GENDIR dir;
  int i=0, dirmask, dmask;
	dirmask=wood_board[ from ].dirmask;
	dmask=1;
	for( dir=LEFT_UP_DIR; dir<=LEFT_DIR; dmask<<=1, dir++ ){
		if( !(dmask & dirmask) ) continue;
		to=from+increment[dir];
		if( SQUARE[to].wood.color==our_color ) continue;
		writemove( from, to, 0 ); i++;
	}
	i+=gencastles();
	return(i);
}

int genknight( SQUARE_NUM from )
{
  SQUARE_NUM to;
  GENDIR dir;
  int i=0, dirmask, dmask;
	dirmask=wood_board[ from ].kndirmask;
	dmask=1;
	for( dir=LEFT_UP_DIR; dir<=LEFT_DIR; dmask<<=1, dir++ ){
		if( !(dmask & dirmask) ) continue;
		to=from+knincrement[dir];
		if( SQUARE[to].wood.color==our_color ) continue;
		writemove( from, to, 0 ); i++;
	}
	return(i);
}

int genpawnmove( SQUARE_NUM from )
{
  SQUARE_NUM to;
	to=( our_color==WHITE_PIECE )? increment[UP_DIR]:increment[DOWN_DIR];
	to=from+to;
	if( SQUARE[to].wood.name==NOPIECE )
		{ writemove( from, to, 0 ); return(1); }
	return(0);
}

int genpawnjump( SQUARE_NUM from )
{
  SQUARE_NUM to, en_pass;
  int shift;
	shift=( our_color==WHITE_PIECE )? increment[UP_DIR]:increment[DOWN_DIR];
	en_pass=from+shift; to=from+2*shift;
	if( SQUARE[en_pass].wood.name==NOPIECE &&
		SQUARE[to].wood.name==NOPIECE )
		{ writemove( from, to, 0 ); return(1); }
	return(0);
}

int genpawnattack( SQUARE_NUM from )
{
  SQUARE_NUM to;
  int shift, i=0;
  DIR dirmask;
	dirmask=wood_board[ from ].dirmask;
	if( ( our_color==WHITE_PIECE && (dirmask & _LEFT_UP) )||
		( our_color==BLACK_PIECE && (dirmask & _LEFT_DOWN) ) ){
			shift=( our_color==WHITE_PIECE )? increment[LEFT_UP_DIR]:increment[LEFT_DOWN_DIR];
			to=from+shift;
			if( SQUARE[to].wood.name!=NOPIECE &&
				SQUARE[to].wood.color==enemy_color ){
                    writemove( from, to, 0 ); i++;
            } else if( to == EN_PASS
                && SQUARE[from-1].wood.name==PAWN
                && SQUARE[from-1].wood.color==enemy_color ){
                    writemove( from, to, EN_PASSANT ); i++;
            }
	}
	if( ( our_color==WHITE_PIECE && (dirmask & _RIGHT_UP) )||
		( our_color==BLACK_PIECE && (dirmask & _RIGHT_DOWN) ) ){
			shift=( our_color==WHITE_PIECE )? increment[RIGHT_UP_DIR]:increment[RIGHT_DOWN_DIR];
			to=from+shift;
			if( SQUARE[to].wood.name!=NOPIECE
                && SQUARE[to].wood.color==enemy_color ){
					writemove( from, to, 0 ); i++;
            } else if( to == EN_PASS
                && SQUARE[from+1].wood.name==PAWN
                && SQUARE[from+1].wood.color==enemy_color ){
                    writemove( from, to, EN_PASSANT ); i++;
            }
	}
	return(i);
}

int generator( void )
{
  SQUARE_NUM sq;
  PIECE_IN_LIST *our_piece_list;
  int i=0, j;
	curmp=MFIRST;
	our_color=MOVE_COLOR;
	enemy_color=REVCOLOR( MOVE_COLOR );
	our_piece_list=PIECE_LIST+NUM_PIECE*our_color;
	for( j=0; j<NUM_PIECE; j++ ){
		sq=our_piece_list[j].where;
		if( sq==DUMMY ) continue;
		switch( SQUARE[sq].wood.name ){
		  case KING:  i+=genking(sq); break;
		  case QUEEN: i+=genrook(sq); i+=genbishop(sq);
			break;
		  case ROOK:  i+=genrook(sq); break;
		  case BISHOP:i+=genbishop(sq); break;
		  case KNIGHT:i+=genknight(sq); break;
		  case PAWN:  i+=genpawnmove(sq); i+=genpawnjump(sq);
			i+=genpawnattack(sq);
			break;
		}
	}
	MLAST=curmp;
	return( i );
}

int legalmove( BASEMP bmp )
{
  MOVE *mp;
	mp=MFIRST;
	while( mp!=MLAST ){
		if( mp->from==FROM && mp->to==TO ){
			if( mp->flags & CASTLE_LEFT )
				{ if( LEFT_CASTLE ) return(1); }
			else if( mp->flags & CASTLE_RIGHT )
				{ if( RIGHT_CASTLE ) return(1); }
			else return(1);
		}
		mp++;
	}
	return(0);
}

