/* 	 ͻ
	              Drawing the board and pieces procedures           
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <conio.h>      /* for colors */
#include <dos.h>        /* MK_FP */
#include <stdlib.h>     /* NULL */

#include "myface.h"
#include "myfacpro.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facerr.h"
#include "facemouse.h"
/*#include "facelib.h"*/

#include "lang.h"
#include "dbchess.h"
#include "dbase.h"
#include "dbbdraw.h"
#include "dbmove.h"
#include "dbwind.h"
#include "iface.h"

#undef FIRSTLINE  /* it isn't identical with chess.h */
#undef LASTLINE

#undef ON
#define ON        |16*

#define BOARDLEFT    board->wi.left
#define BOARDTOP     board->wi.top
#define BOARDBOTTOM  board->wi.bottom
#define BOARDRIGHT   board->wi.right
#define SQHEIGHT     board->wps.text->wsi.ncol	  /* height of square on screen */
#define SQLENGTH     board->wps.text->wsi.collth  /* lehgth of square on screen */

#define REDSYM      ""      /* red square symbol */
#define CURSYM      ""      /* symbol for draw current square */
#define LEFTSYM     ""      /* symbol to draw left&right frame */
#define RIGHTSYM    ""

int revindex=0;		/* reverse board if flag set to 1 */
int usefont=1;		/* use special font if flag set */
int usefontnote=0;  /* special font for piece */
WINP board;     /* window pointer for board drawing */
static int boardsize=0; /* 0 is big board, 1 is small board */

char pctoch[]={'d','K','Q','R','B','N','P','#','','','','','',''};
			/* to use our chess font if some parameter is given */
static char *chessfont[7]=
{"    ","    ","    ",
 "    ","    ","    " };

int loadpieceimage( void ) {return 0;};
void gputch( int col, int row, int ch, int putopt );
#pragma argsused
void gr_drawpiece(int col,int row,PIECE_NAME piece,PIECE_COLOR color,PIECE_COLOR sqcolor ){return;};
#pragma argsused
void gr_drawsquare( int col, int row, PIECE_COLOR color ){return;};
#pragma argsused
void gr_drawboard( int col, int row ){return;};
#pragma argsused
void gr_clearframe( int col, int row, PIECE_COLOR color ){return;};

static void near drawboardaround( void );
/*WOOD_PIECE * whoonsquare( int square );*/

static unsigned char whitesq, blacksq, /* attributes for squares */
	whitepc, blackpc;                  /* attributes for pieces */
static unsigned char curattr, redattr; /* current and red squares */
static char sqheight, sqlength;        /* square height and length in sells */
static char firstfile, firstline;      /* first file and line coords */
static char lastfile, lastline;        /* last file and line coords */
char cursquare, redsquare;

#define LASTSCRCOL 79        /* last column */
#define LASTSCRROW 24        /* last row */
static char far *ldcorner;   /* pointer to lelf down corner of screen */

int showchar( char c, int p, char attr )/* draw char in left-down corner -pos */
{
  register int pos;
  register char far *ldp;

	if( facemode==0 ){       /* TEXT mode: write to Video RAM */
		pos=p<<1;       /* mult to 2 (each char-two bytes) */
		ldp=ldcorner-pos; /* get pointer to */
		*ldp++=c;       /* put char code */
		*ldp=attr;      /* put attribute */
	} else 
		gputch( LASTSCRCOL-p, LASTSCRROW, c, 4 ); /* 4 is NOT_PUT */
	return(0);
}

int getworldx( int square )
{
  register int x;
	x=GETFILE( square );       /* get file number */
	if( revindex ) x=7-x;   /* check board reversed */
	return( firstfile-1 + x*sqlength ); /* return coord on screen */
}
int getworldy( int square )
{
  register int y;
	y=GETLINE( square );       /* get file number */
	if( revindex ) y=7-y;    /* check board reversed */
	return( firstline-1 +(7-y)*sqheight ); /* return coord on screen */
}
static int near getboardx( int worldx )
{
  register int file;
	file=( worldx -firstfile );
	file=file/sqlength; /* get file number */
	if( revindex ) file=7-file;   /* check board reversed */
	return( file ); /* return coord on board */
}
static int near getboardy( int worldy )
{
  register int line;
	line=( worldy - firstline );
	line=line/sqheight; /* get file number */
	if( revindex ) line=7-line;   /* check board reversed */
	return( 7-line ); /* return coord on board */
}

int drawpiece( int square, int piece, int color, int sqattr )
{
  int x, y, attr, sqcolor;
  char *cp, buff[]="          ";

	setwritten(board);
	x=getworldx( square );     /* get X world coord. */
	y=getworldy( square );     /* get Y world coord. */
	sqcolor= SQISWHITE( square )? WHITE_PIECE:BLACK_PIECE;
	if( facemode==1 ){         /* there is GRAPH mode */
		gr_drawsquare(x,y,sqcolor); /* call graph subroutine */
		gr_drawpiece(x+1,y,piece,color,sqcolor); /* call graph subroutine */
	} else {
		attr=( color==0? whitepc:blackpc);         /* get foreground */
		attr=attr ON sqattr;        /* get background */
		if( boardsize ){     /* small board */
			if( usefont ) buff[1]=pctoch[piece+7];
			else buff[1]=pctoch[piece];
			cp=buff;
		} else {             /* big board */
			if( usefont )
				cp=chessfont[ piece-1 ];        /* use special chess font? */
			else {
				buff[7]=pctoch[ piece ];          /* piece name to char */
				cp=buff;
			}
		}
		putadrln( y,   x, cp, 0, sqlength, attr );  /* put to screen */
		if( sqheight>1 )
			putadrln( y+1, x, cp+sqlength, 0, sqlength, attr );  /* piece image */
	}
	return(0);
}

int clearpiece( int square, int sqattr )
{
  int x, y, attr, sqcolor;
  char buff[]="      ";

	setwritten(board);
	x=getworldx( square );     /* get X world coord. */
	y=getworldy( square );     /* get Y world coord. */
	sqcolor= SQISWHITE( square )? WHITE_PIECE:BLACK_PIECE;
	if( facemode==1 )         /* GRAPH mode is active */
		gr_drawsquare( x, y, sqcolor ); /* call graph draw function */
	else {
		attr=WHITE ON sqattr; /* get attribute - space on background */
		putadrln( y,   x, buff, 0, sqlength, attr );  /* put to screen */
		if( sqheight>1 )
			putadrln( y+1, x, buff, 0, sqlength, attr );  /* empty square */
	}
	return(0);
}

static void near drawboardaround( void )
{
  int x, y, inc, i, attr;
  int lmsize;     /* left margine size */
  char c, space[]="     ", info[]="     ";

	x=BOARDLEFT; y=BOARDTOP;
	lmsize=firstfile-BOARDLEFT-1;
	attr=blacksq ON whitesq;
	c=( revindex==0 )? '8':'1';
	inc=( revindex==0 )? -1:1;
	for( i=0; i<8; i++, y+=sqheight, c+=inc ){
		if( lmsize>1 )
			putadrln( y, x, space, 0, lmsize, attr );
		info[lmsize-1]=c;
		putadrln( y+(sqheight/2), x, info, 0, lmsize, attr );
	}
	c=( revindex==0 )? 'a':'h';
	inc=( revindex==0 )? 1:-1;
	putadrln( y, x, space, 0, lmsize, attr );
	x+=lmsize;
	for( i=0; i<8; i++, x+=sqlength, c+=inc ){
		space[sqlength/2]=c;
		putadrln( y, x, space, 0, sqlength, attr );
	}
}

int drawboard( void )
{
  WOOD_PIECE *wpp;
  SQUARE_NUM sq;
  int sqattr;
    if (!freezed) {
	    if( ismouse )
		    disablecursor();
	    makeborder( board );
	    drawboardaround();
	    for( sq=h8; sq>=a1; sq-- ){
	      wpp=whoonsquare( sq );
	      sqattr= SQISWHITE( sq ) ? whitesq:blacksq;
	      if( wpp->name!=NOPIECE ) /* if piece exist draw it */
			    drawpiece( sq, wpp->name, wpp->color, sqattr );
		      else  clearpiece( sq, sqattr );
	    }
	    if( facemode==0 )
		    savewindow(board);
	    if( ismouse )
		    enablecursor();
    }  else setwritten(board);
	return(0);
}

int refreshboard( void )
{
	checkface( refresh( board ) );
	return(0);
}


int clearframe( int square )    /* clear the square frame */
{
/*char sym[]=" ";*/
int attr, x, y, sqcolor;
WOOD_PIECE *wpp;
	setwritten(board);
	if( ismouse )
		disablecursor();
	x=getworldx( square );     /* get X world coord. */
	y=getworldy( square );     /* get Y world coord. */
	sqcolor= SQISWHITE( square )? WHITE_PIECE:BLACK_PIECE;
	if( facemode==1 )
		gr_clearframe( x, y, sqcolor );
	else {
		attr=( sqcolor==WHITE_PIECE ? whitesq:blacksq );
/*		attr=WHITE ON attr; /* foregr=Space, backgr=square attribute */
		putadrln( y, x, sym, 1, attr); /* clear square frame */
		putadrln( y+sqheight-1, x, sym, 1, attr);
		putadrln( y, x+sqlength-1 ,sym, 1, attr);
		putadrln( y+sqheight-1 ,x+sqlength-1, sym, 1, attr);*/
		wpp=whoonsquare( square );
		if( wpp->name!=NOPIECE ) /* if piece exist draw it */
			  drawpiece( square, wpp->name, wpp->color, attr );
			else  clearpiece( square, attr );
	}
	if( ismouse )
		enablecursor();
	return(OK);
}

int drawredframe( int square )       /* draw new square frame */
{
/*  int x,y;*/
/*  int attr;*/
  WOOD_PIECE *wpp;
	setwritten(board);
	if( ismouse )
		disablecursor();
/*	x=getworldx( square );     /* get X world coord. */
	y=getworldy( square );     /* get Y world coord. */
	if( SQISWHITE( square ) ) attr=redattr ON whitesq;
		else attr=redattr ON blacksq;
	putadrln( y, x, LEFTSYM, 1, attr); /* draw red square frame */
	putadrln( y+sqheight-1, x, LEFTSYM, 1, attr);
	putadrln( y, x+sqlength-1 ,RIGHTSYM, 1, attr);
	putadrln( y+sqheight-1 ,x+sqlength-1, RIGHTSYM, 1, attr);*/
	wpp=whoonsquare( square );
	if( wpp->name!=NOPIECE ) /* if piece exist draw it */
		  drawpiece( square, wpp->name, wpp->color, redattr );
		else  clearpiece( square, redattr );
	if( ismouse )
		enablecursor();
	return(OK);
}

int drawcurframe( int square )       /* draw new square frame */
{
/*  int x,y;*/
/*  int attr;*/
  WOOD_PIECE *wpp;
	setwritten(board);
	if( ismouse )
		disablecursor();
/*	x=getworldx( square );     /* get X world coord. */
	y=getworldy( square );     /* get Y world coord. */*/
/*	if( SQISWHITE( square ) ) attr=curattr ON whitesq;
		else attr=curattr ON blacksq;
	putadrln( y, x, CURSYM, 1, attr); /* draw red square frame */
	putadrln( y+sqheight-1, x, CURSYM, 1, attr);
	putadrln( y, x+sqlength-1 ,CURSYM, 1, attr);
	putadrln( y+sqheight-1 ,x+sqlength-1, CURSYM, 1, attr);*/
	wpp=whoonsquare( square );
	if( wpp->name!=NOPIECE ) /* if piece exist draw it */
		  drawpiece( square, wpp->name, wpp->color, curattr );
		else  clearpiece( square, curattr );
	if( ismouse )
		enablecursor();
	return(OK);
}

int setboardlocation( int square ) /* posit mouse to square */
{
  int x,y;
	y=getworldy(square);  x=getworldx(square);
	settextloc( x+HALF(sqlength), y+HALF(sqheight) );
	return( OK );
}

int setcursquare( int square ) /* moving the red square */
{
	static int oldsq=0;   /* buffer */

	if( oldsq!=square ){
		clearframe(oldsq);  /* clear old frame */
		drawcurframe(square);        /* draw new frame */
		oldsq=square;          /* save new red square */
	}
	return(OK);
}

int poscursor( WINP wp, int wndx, int wndy )
{                /* posit window cursor for respectivly to mouse */
	int num;
	static WINP oldwp=NULL; /* remember the current window */
	static int type, size, curx, cury;

	if(wp!=oldwp){           /* if window changed */
		gettype( wp, &type ); /* get window type */
		getmenu( wp, &num, &size ); /* get menu parameters */
		oldwp=wp;
	}                        /* only for this windowes */
	if( type==EDIT || type==MENU /*|| type==PANE*/ ){
		wndx=(wndx-1)/size+1;
		wndy=wndy;           /* get new cursor position */
		if( curx!=wndx || cury!=wndy ){
			curx=wndx;
			cury=wndy;
			gotowindow( wp, wndy, wndx ); /* posit cursor */
			refresh( wp ); /* show result */
		}
	}
	return(OK);
}

/*
int posmouse( WINP wp ) /* posit mouse to window cursor position */
{
	static WINP oldwp=NULL;
	static int top, left, border, size;
	int bot, right, num, wndx, wndy;

	if( wp!=oldwp ){
		getmenu( wp, &num, &size );
		getborder( wp, &border, &num );
		getposwindow( wp, &top, &left, &bot, &right );
		border=( border==0? 0:1 );
	}
	wndx=left+border+(getcurx( wp )-1)*size;
	wndy=top+border+(getcury( wp )-1);
	settextloc( wndx, wndy );
	return(OK);
}
*/

int onboard( int *file, int *line ) /* check position on board */
{
	if(*file>=firstfile && *file<=lastfile &&
	  *line>=firstline && *line<=lastline ){
		*file=getboardx(*file);
		*line=getboardy(*line);
		return(1);
	}
	return(0);
}

extern int adrdispl; /* used by face in FACEIBM.C */
extern char *wndname[];
extern char configfile[];

#pragma argsused
int far boardhotkey( WINP wp, int key, int why )
{
    if( why==REDRAW )
        drawboard();
    if( why==AFTER ) return(0);
    return(key);
}

int makedrboard( WINP wp )
{
  int lmsize; /* left margine size */
	checkface(0);
	board=wp;
	checkface( keyfunc(board,boardhotkey, 0 ) );
	ldcorner=MK_FP( adrdispl, LASTSCRROW*160 +LASTSCRCOL*2 );
	if( facemode==1 ){
		if( loadpieceimage()==-1 ){
			message(" Can't load file with piece images. ");
			return(-1);
		}
	}
	whitesq=ATTR>>4;       blacksq=MAXLINE>>4;
	whitepc=ATTR&0x0f;     blackpc=MAXLINE&0x0f;
	curattr=TNEGATTR&0x07;
	redattr=(((unsigned char)TNEGATTR)>>4)&0x07;
	sqheight=SQHEIGHT;     sqlength=SQLENGTH;
	if( sqlength==5 && sqheight==2 ) /* big board */
		{ boardsize=0; lmsize=2; }
	else { boardsize=1; lmsize=1; }
	firstfile=BOARDLEFT+lmsize+1; lastfile=firstfile+sqlength*8-1;
	firstline=BOARDTOP+1; lastline=firstline+sqheight*8-1;
	cursquare=e2; redsquare=DUMMY;
	return(0);
}

static int near newsquare( int square, int key )
{
  int file, line;
  int delta=0;
	file=GETFILE( square ); line=GETLINE( square );
	if( revindex ) {
	  switch( key ) {
		case LEFTARROW: if( file!=7 ) delta=1;  break;
		case RIGHTARROW:if( file!=0 ) delta=-1; break;
		case UPARROW:   if( line!=0 ) delta=-8; break;
		case DOWNARROW: if( line!=7 ) delta=8;  break;
		case HOME:      if( file!=7 ) delta=1;
				if( line!=0 ) delta-=8; break;
		case END:       if( file!=7 ) delta=1;
				if( line!=7 ) delta+=8; break;
		case PGUP:      if( file!=0 ) delta=-1;
				if( line!=0 ) delta-=8; break;
		case PGDOWN:    if( file!=0 ) delta=-1;
				if( line!=7 ) delta+=8; break;
		default: break;
	  }
    }
    else {
      switch( key ){
		case LEFTARROW: if( file!=0 ) delta=-1; break;
		case RIGHTARROW:if( file!=7 ) delta=1;  break;
		case UPARROW:   if( line!=7 ) delta=8;  break;
		case DOWNARROW: if( line!=0 ) delta=-8; break;
		case PGDOWN:    if( file!=7 ) delta=1;
				if( line!=0 ) delta-=8; break;
		case PGUP:      if( file!=7 ) delta=1;
				if( line!=7 ) delta+=8; break;
		case END:       if( file!=0 ) delta=-1;
				if( line!=0 ) delta-=8; break;
		case HOME:      if( file!=0 ) delta=-1;
				if( line!=7 ) delta+=8; break;
		default: break;
	  }
    }
	square+=delta;
	return( square );
}

int boardcursor( int key )
{
  static int sq=DUMMY;
    if( key ){
	    sq=newsquare( cursquare, key );
	    clearframe( cursquare );
	    cursquare=sq;
    } else if( sq!=DUMMY ) clearframe( sq );
    drawcurframe( sq=cursquare );
    if( redsquare!=DUMMY )
        drawredframe( redsquare );
    return(0);
}

int openboard( ISP isp )
{
  int btype, battr;
	getborder( STWP, &btype, &battr );
	border( STWP, TWOLINES, battr );
	openwindow( STWP );
    boardcursor(0);
	return(0);
}

int closeboard( ISP isp )
{
  int btype, battr;
	getborder( STWP, &btype, &battr );
	border( STWP, ONELINE, battr );
	refresh( STWP );
	return(0);
}

