/* 	 ͻ
	              Utility functions for work with strings           
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <conio.h>      /* getch() */
#include <ctype.h>      /* tolower() */
#include <string.h>     /* strcat() */
#include <stdio.h>      /* sprintf() */

#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"

char piecetochar[]={'#','K','Q','R','B','N','P'};

int stoupper( register char *str )
{
  register int i=0;
	while( *str ) { *str=toupper( *str ); str++; i++; }
	return(i);
}

int issquare( int c )
{
	c=tolower( c );
	if( (c>='a' && c<='h')||(c>='1' && c<='8') ) return(1);
	return(0);
}

int ispiece( int c )
{
	c=tolower( c );
	if( c=='k'||c=='q'||c=='r'||c=='n'||c=='p'||c=='b' ) return(1);
	return(0);
}

int ischess( int c )
{
	c=tolower( c );
	if( issquare(c) ) return(1);
	if( ispiece(c) )  return(1);
	if( c=='-'||c=='x'||c=='+') return(1);
	return(0);
}

int iscastle( register char *str )
{
	if( *str=='0' && *(str+1)=='-' && *(str+2)=='0' ){
		if( *(str+3)==' ' ) return(1);
		if( *(str+3)=='-'&& *(str+4)=='0'&& *(str+5)==' ' ) return(2);
	}
	return(0);
}

int ismove( register char *str )
{
	if( iscastle( str ) ) return(1);
	if( ispiece(*str) && issquare(*(str+1)) && issquare(*(str+2))
		&& ischess(*(str+3)) && issquare(*(str+4)) && issquare(*(str+5)) )
			return(1);
	return(0);
}

int chartopiece( int c )
{
	c=toupper(c);
	switch( c ){
		case 'K': return( KING );  case 'Q': return( QUEEN );
		case 'R': return( ROOK );  case 'B': return( BISHOP );
		case 'N': return( KNIGHT );case 'P': return( PAWN );
	}
	return(0);
}

/*
#define SKIPBLANK( str )  { while( *(str)==' ' ) (str)++; }

char * sscanpiece( char *str, PIECE_NAME *name )
{
	if( !ispiece( *str ) ) return( str );
	*name=chartopiece(*str++);
	return( str );
}
char * sscansquare( char *str, SQUARE_NUM *sqp )
{
	if( !( issquare( *str ) && issquare(*(str+1)) ) ) return( str );
	*sqp=GETOFFSET( *str -'a', *(str+1) -'1' );
	return( str+2 );
}

char * sscanmove( char *str, MOVE *mp )
{
int i;
	memset( mp, 0, sizeof( BASEMOVE ) );
	SKIPBLANK( str )
	if( !ismove( str ) ) return( NULL );
	if( (i=iscastle( str ))!=0 ){
	  if( i==1 ) mp->flags|=CASTLE_RIGHT; else mp->flags|=CASTLE_LEFT;
	  return(str+MOVESTRLEN);
	}
	str=sscanpiece( str, &mp->who );
	str=sscansquare( str, &mp->from );
	if( *str++=='x' ) mp->flags=CAPTURE;/* else mp->flags=0;*/
	str=sscansquare( str, &mp->to );
	if( *str=='+' ) mp->flags|=ISCHECK; /* I don't know where it place */
	if( ispiece(*str) ){
		str=sscanpiece( str, &mp->prom );
		mp->flags|=PROMOTION;
	}
	if( *str=='+' ) mp->flags|=ISCHECK;
/* for old protocols compatibility */
	if( mp->who==KING ){
	  if( mp->from-mp->to==-2 ) mp->flags|=CASTLE_RIGHT;
	  if( mp->from-mp->to==2 )  mp->flags|=CASTLE_LEFT;
	}
	if( *str ) str++; /* if not end-of-line */
	return( str );
}

int sprintpos( char *str, PIECE_COLOR color )
{
	int i, pnum;
	PIECE_NAME name, findpiece;
	PIECE_COLOR col;
	SQUARE_NUM square;

	*str++=( color==WHITE_PIECE )? 'w':'b';
	*str++=':';
	findpiece=KING;
	while( findpiece<=PAWN ){
		pnum=0;
		for( i=(NUM_PIECE*color); i<(NUM_PIECE*(color+1)); i++ ){
			pieceinlist( i, &name, &col, &square );
			if( name!=findpiece ) continue;
			*str++=piecetochar[findpiece]; /* get piece name */
			if( name==PAWN && pnum ) str--; /* don't need more P name */
			str=sprintsquare( str, square ); /* make square */
			*str++=',';
			pnum++;
		}
		findpiece++;
	}
	*(str-1)='.'; *str='\0';
	return(0);
}
*/
char * sprintsquare( char *str, SQUARE_NUM square )
{
	*str='a'+GETFILE(square);
	*(str+1)='1'+GETLINE(square);
	return( str+2 );
}

char * sprintmove( char *str, BASEMP bmp )
{
  char leftcastle[MOVESTRLEN+1]="0-0-0   ";
  char rightcastle[MOVESTRLEN+1]="0-0     ";
  char nullmove[MOVESTRLEN+1]="nilmove";
  char *cp;
	cp=str;
	if( !bmp )
		strcpy( str, nullmove );
	else if( LEFT_CASTLE )
		strcpy( str, leftcastle );
	else if( RIGHT_CASTLE )
		strcpy( str, rightcastle );
	else {
		*str++=piecetochar[ WHO ];
		str=sprintsquare( str, FROM );
		*str++=( CAPT )? 'x':'-';
		str=sprintsquare( str, TO );
		*str++=( ISCHECK )? '+':' ';
	/*	*str++=( PROM==NOPIECE )? ' ':piecetochar[ movep->prom ];*/
		*str++=' ';  /* isn't promotion in debut */
	}
	cp+=MOVESTRLEN;
	*cp='\0';
    return( cp );
}

int sprintfmove( char *str, char *fmt, BASEMP bmp )
{
  int fldsize;
	while( *fmt ){                /* format is: %[field]m */
		if( *fmt=='%' &&(*(fmt+1)=='m' || *(fmt+2)=='m') ){ /* begin of format string */
			fmt++;                /* skip '%' */
			if( isdigit( *fmt ) ) /* get new field size if exist */
				fldsize=*fmt++ -'0'; /* */
			else fldsize=MOVESTRLEN; /* */
			sprintmove( str, bmp );
			str+=fldsize;
			fmt++;                /* skip 'm' */
		} else
			*str++=*fmt++;
	}
	*str='\0';
	return(0);
}

