/*
     ͻ
              Procedures for searching debut tree                   
                     programmed  by  Anthon  Dubets                 
     ͼ
*/
#include <stdlib.h>

#include "myface.h"
#include "faceproc.h"
#include "myfacpro.h"
#include "facekeys.h"
#include "facerr.h"
#include "facemous.h"

#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"
#include "dbwind.h"
#include "dbmove.h"
#include "dbbdraw.h"
#include "dberror.h"
#include "iface.h"

#define BASEDEPTH  50
#define STACKNUM   2
#define INCSTACK   { basesp++; level++; stkinfo[stacknum].sp=basesp; stkinfo[stacknum].level=level; }
#define DECSTACK   { basesp--; level--; stkinfo[stacknum].sp=basesp; stkinfo[stacknum].level=level; }

extern MOVE movestack[];
static POSITION pos0, pos1;    /* current chess positions for both stacks */
BASEPOS basestk[2*BASEDEPTH];  /* base position stacks */
STACKINFO stkinfo[STACKNUM]= { { &pos0, 0, basestk, basestk, movestack },
  { &pos1, 0, basestk+BASEDEPTH, basestk+BASEDEPTH, movestack+40*BASEDEPTH } };
POSITION *posp=&pos1;           /* current chess position pointer */
BASEPOS *basesp=basestk;       /* base position stack pointer */
int level=0;                   /* base stack level */
int stacknum=0;                /* stack num may be 0 or 1, default 0 */
int basedepth=BASEDEPTH;       /* maximum base stack depth */
BASEMOVE nullmove=             /* move with flags for first move */
{ 0,0,0, 0,0,0,0,0, 1,1,0, 0, 0,0,0, NULL }; /* is first & last */
extern ISTATE editst, viewst;
extern int reload;

static int near godown( void ); /* make 'go down' on tree */
BASEMP near getnmove( BASEMP bmp, int num ); /* get move by number on level */
int findmove( BASEMP first, BASEMP bmp ); /* get move by number on level */
void checkmoves( BASEMP bmp, PIECE_COLOR color );
static int near legalpos( int file, int line ); /* check cursor position */
int reloadstack( void );

static int near godown( void )
{
  int i;
    codemove( &CURMOVE, BPCURRENT );
	if( move() )                  /* try to make move, if error return 0 */
		return(-1);
    dispmove( BPCURRENT, level ); /* show maked move in 'protocol' */
	(basesp+1)->first=BPCURRENT->next;   /* save vert link */
	(basesp+1)->mfirst=MLAST;
	INCSTACK;            /* shift stacks */
	if( (i=readbranch( BPFIRST ))!=OK )        /* load all branches of this level */
		{ message( errmessage[i] ); return(-1); }
	if( !generator() )
		{ message( " Can't generate moves " ); return(-1); }
	return(0);
}

static int near setcurmove( void )
{
  BASEMP bmp;
	if( BPFIRST ){
		bmp=getnmove( BPFIRST, BPCURNUM ); /* get move with this number */
		if( bmp!=NULL ) BPCURRENT=bmp; /* if it exist, init current */
		else           /* else current is NULL, cur number is 0 */
			{ BPCURNUM=0; BPCURRENT=getnmove( BPFIRST, 0 ); }
		checkmoves( BPFIRST, MOVE_COLOR ); /* check all moves on new level */
		bmp=BPCURRENT->next;           /* get next level */
		if( bmp )                      /* if next level exist check it */
			checkmoves( bmp, REVCOLOR(MOVE_COLOR) ); /* check all moves on new level */
	} else { BPCURNUM=0; BPCURRENT=NULL; }
	return(0);
}

int makemove( void )
{                                 /* return 1 if DOWN succeed else 0 */
  WINP wp;
  int file, line;
	wp=tree;
	line=TNROW-1; file=TNSYM-1;
	if( !legalpos( file, line ) )    /* check cursor pos is legal */
		return(0);
	if( file==0 ){ /* mouse or cursor is in first column */
		BPCURNUM=line; /* current move number=line number */
		BPCURRENT=getnmove( BPFIRST, BPCURNUM ); /* get move by number */
	} /* else use previouse setup (may be wrong ??) */
	if( !legalmove( BPCURRENT ) )
		{ message( " Move not legal. " ); return( 0 ); }
	if( godown() )
		{ message( " Can't make move. " ); return( 0 ); }
	if( file ){
		BPCURNUM=line;
		BPCURRENT=getnmove( BPFIRST, BPCURNUM );
		if( !legalmove( BPCURRENT ) )
			{ message( " Second move not legal. " ); return( 0 ); }
		if( godown() )
			{ message( " Can't make second move. " ); return( 0 ); }
	}
	setcurmove();
	repaint();
	return(0);
}

int makemoveback( void )
{
	if( level==0 ) return(0);
/*	if( tosave && (BPFIRST->flags & SAVELEVEL) )
		if( asktosave()!=OK ) return(0);*/
	move_back();
	freebranch( BPFIRST, NULL );  /* free all branches of level */
	BPFIRST=NULL;
	DECSTACK;
	clearmove( level );
	repaint();
	return(0);
}

int updatenextlevel( void )
{
  WINP wp;
  int file, line;
	wp=tree;
	line=TNROW-1; file=TNSYM-1;
	if( file || !legalpos( file, line ) )    /* check cursor pos is legal */
		return(0);
	BPCURNUM=line;               /* current move number=line number */
	BPCURRENT=getnmove( BPFIRST, BPCURNUM ); /* get move, skip DELMOVE */
	if( BPCURRENT->next )
		checkmoves( BPCURRENT->next, REVCOLOR(MOVE_COLOR) ); /* check all moves on new level */
	shownextlevel(); /* show new level in 'tree' */
	posstate( tree, BPCURNUM+1, 1 );
	return(0);
}

int proceedmove( BASEMP bmp )
{
	BPCURNUM=findmove( BPFIRST, bmp );
	if( !legalmove( bmp ) )
		{ message( " Move not legal. " ); return( 0 ); }
	if( BPCURNUM==-1 ){
		if( stacknum==1 ){
			BPCURNUM=0;
			message(" You can't add new move in View Tree ");
			return(0);
		}
		if( newmove( bmp )!=OK ) return(0);
	} else {
		BPCURRENT=getnmove( BPFIRST, BPCURNUM );
	}
	if( godown() )
		{ message( " Can't make move. " ); return( 0 ); }
	setcurmove();
	repaint();
	return(0);
}

void checkmoves( BASEMP bmp, PIECE_COLOR color )
{
	if( !bmp ) return;
	while(1){
	  fillmove( bmp );                 /* fill all fields if move */
	  if( RIGHT_CASTLE ){
		if( color==WHITE_PIECE ){ FROM=e1; TO=g1; }
		if( color==BLACK_PIECE  ){ FROM=e8; TO=g8; }
	  }
	  if( LEFT_CASTLE ){
		if( color==WHITE_PIECE ){ FROM=e1; TO=c1; }
		if( color==BLACK_PIECE  ){ FROM=e8; TO=c8; }
	  }
	  if( LASTMOVE ) break;
	  bmp++;
	}
}

BASEMP near getnmove( BASEMP bmp, int num ) /* get move by number */
{                                           /* from level */
  int i=0;
	if( !bmp ) return(NULL);
	while(1){
/*      if( !( EDITFLAG & DELMOVE ) )  /* skip deleted moves */*/
		if( i==num ) return( bmp ); /* found requred move */
		if( LASTMOVE )            /* end of level: no move */
			break;                /*   with given number */
		bmp++; i++;
	}
	return(NULL);                     /* */
}

int findmove( BASEMP bmp, BASEMP find ) /* get move by */
{
  int i=0;
	if( !find || !bmp ) return(-1);
	while(1){
/*      if( !( EDITFLAG & DELMOVE ) )  /* skip deleted moves */*/
		if( WHO==find->who && FROM==find->from && TO==find->to )
			return(i); /* found requred move */
		if( LASTMOVE )            /* end of level: no move */
			break;                /*   with given number */
		bmp++; i++;
	}
	return(-1);                     /* */
}

static int near legalpos( int file, int line ) /* check cursor position */
{
	if( file>1 ) return(0);
	if( getnmove( BPFIRST, line )==NULL ) /* check position for current level */
		return( 0 );
	if( file ){           /* check position for next level */
		if( getnmove( BPCURRENT->next, line )==NULL ) return( 0 );
	}
	return(1);
}

int resetbase( void )
{
  int i;
/*	if( tosave && asktosave()!=OK ) return(0);*/
	for( i=level; i>0; i-- ){
		move_back();
		freebranch( BPFIRST, NULL );  /* free all branches of level */
		BPFIRST=NULL;
        DECSTACK;
	}
	repaint();
	return(0);
}

int resetstack( void )
{
/*	if( tosave && asktosave()!=OK ) return(0);*/
	basesp=
	stkinfo[stacknum].sp=
	stkinfo[stacknum].bp;       /* load new stack information */
	freetree( BPFIRST );
	BPFIRST=NULL;
	level=stkinfo[stacknum].level=0;
	posp=stkinfo[stacknum].posp;
	MFIRST=MLAST=MCURRENT=stkinfo[stacknum].movebp;
	setstartpos();
	generator();
	return(0);
}

int setstack( int newstack )
{
	if( newstack<0 || newstack>STACKNUM-1 ) return(0);
	if( newstack!=stacknum ){
/*		stkinfo[stacknum].sp=basesp;       /* save old stack information */
		stkinfo[stacknum].level=level;
*/
		basesp=stkinfo[newstack].sp;       /* load new stack information */
		level= stkinfo[newstack].level;
		posp=  stkinfo[newstack].posp;
		stacknum=newstack;
	}
	if( newstack==1 ){ tree=viewst.wp;   protocol=prot2; }
	else { tree=editst.wp;  protocol=prot1; }
	return(0);
}

int changestack( void )
{
	setstack( 1-stacknum );
	if( stacknum==1 && reload ){ reloadstack(); reload=0; }
	openwindow( protocol  );
	openwindow( tree );
	repaint();
	return(1);               /* ret 1 for coming into new state */
}

int freetree( BASEMP node )
{
  BASEMP bmp;
	if( !node ) return(0);
	bmp=node;
	while(1){
		if( NEXT ) freetree( NEXT );
		if( LASTMOVE ) break;
		bmp++;
	}
	freelevel( node );
	return(0);
}

int reloadstack( void )
{
  int i;
	resetstack();
	if( (i=loadstack())!=OK )
		{ message( errmessage[i] ); return(-1); }
	return(OK);
}

int findstack( int key, ISP *ispp )
{
	if( stacknum==0 ) *ispp=&editst;
	else *ispp=&viewst;
	return(0);
}
