/*
	 ͻ
	          Declaration of used functions                         
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

/*** DBFILE.C *******************************************************/
/*** Read/Write moves and levels from/to file ***********************/
int filecopy( int destfh, int srcfh );
int openbase( char *fname );      /* open base file */
int closebase( void );        /* close base file */
int getmovedump( char *str, long int index ); /* put move dump to string */
int loadbasefile( char *fname );     /* open base, load first level */
int creatbasefile( char *fname );
int loadstack( void );       /* load base into the current stack */
int makebackup( char *fname );
int maketemp( char *fname );
int copytemp( char *fname );
int savebasefile( void );     /* save changed & new moves */
BASEMP readlevel( long int index ); /* read level by index in file */
int freelevel( BASEMP bmp );  /* free level of moves */
int readbranch( BASEMP bmp ); /* read all branches form level */
int freebranch( BASEMP bmp, BASEMP exclude ); /* free branches without exclude */
int checklevel( BASEMP bmp );

/*** DBTREE.C ********************************************************/
/*** Interactive base tree searching functions ***********************/
int resetbase( void );
int resetstack( void );
int setstack( int newstack );
int makemove( void );
int makemoveback( void );
int updatenextlevel( void );
int proceedmove( BASEMP bmp );
int freetree( BASEMP node );
int changestack( void );

/*** DBUTIL.C *******************************************************/
/*** Utility functions **********************************************/
int stoupper( register char *str );
int issquare( register int c );
int ispiece( register int c );
int ischess( register int c );
int ismove( register char *str );
int chartopiece( register int c );
char * sprintmove( char *str, BASEMP movep );
int sprintfmove( char *str, char *fmt, BASEMP bmp );

/*** DBDRAW.C *******************************************************/
/*** Display new moves and levels ***********************************/
char * sprintlevel( char *str, BASEMP basemp );
int showlevel( void );
int shownextlevel( void );
int clearlevel( int level );
int showcurrent( BASEMP bmp, int level );
int showendbase( void );
int dispmove( BASEMP bmp, int nmove );
int clearmove( int nmove );
int inspect( void );
void drawprotocol( void );
int removebase( void );
int loadbase( void );
int savebase( void );
int replyline( char *str );
int repaint( void );
int asktosave( void );

/*** DBINMOVE.C ****************************************************/
/*** Functions for input new moves and levels **********************/
int boardspace( void );
int boardmouse( int key );
int waitmovekey( BASEMP bmp );
int fillmove( BASEMP bmp );

/*** DBMENU.C ******************************************************/
/*** Menu interface ************************************************/
int baseexit( void );
int getcommand( void );
int putcommand( int c, int ntime );

/*** DBEDIT.C *******************************************************/
/*** Procedures for edition of debut base ***************************/
int deletemove( void ); /* to delete current move from base */
int restoremove( void ); /* to delete current move from base */
int newmove( BASEMP newbmp ); /* to add move or create new level */
int togglebestmove( void ); /* toggle best ON/OFF */
int playbase( void );
int makelink( void );

/*** GENMOVE.C *******************************************************/
/*** Procedures for moves generation ***************************/
int generator( void ); /* to delete current move from base */
int legalmove( BASEMP bmp );
