/*
	 ͻ
	            Functions  for  set & clear  position               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <mem.h>		/* memset() */
#include <stdio.h>      /* fopen(), fclose() */

#include "face.h"
#include "faceproc.h"
#include "facekeys.h"
#include "facemous.h"
#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"
#include "dbmove.h"

typedef struct{
  BYTE who;
  BYTE color;
  BYTE where;
} START_POS;

#define NEXTCOLOR 10
#define TOPAWN     8

static START_POS start_pos[]={
{ ROOK,   WHITE_PIECE, a1},{ ROOK,   WHITE_PIECE, h1},
{ KNIGHT, WHITE_PIECE, b1},{ KNIGHT, WHITE_PIECE, g1},
{ BISHOP, WHITE_PIECE, c1},{ BISHOP, WHITE_PIECE, f1},
{ QUEEN,  WHITE_PIECE, d1},{ KING,   WHITE_PIECE, e1},
{ PAWN,   WHITE_PIECE, a2},{ PAWN,   WHITE_PIECE, h2},

{ ROOK,   BLACK_PIECE, a8},{ ROOK,   BLACK_PIECE, h8},
{ KNIGHT, BLACK_PIECE, b8},{ KNIGHT, BLACK_PIECE, g8},
{ BISHOP, BLACK_PIECE, c8},{ BISHOP, BLACK_PIECE, f8},
{ QUEEN,  BLACK_PIECE, d8},{ KING,   BLACK_PIECE, e8},
{ PAWN,   BLACK_PIECE, a7},{ PAWN,   BLACK_PIECE, h7}};

void init_pos( void )
{
  SQUARE_NUM sq;
	memset( posp, 0, sizeof( POSITION ) );
	for( sq=a1; sq<NSQUARE; sq++ ) prepare_square( sq );
	memset( PIECE_LIST, DUMMY, sizeof( PIECE_LIST ) );
	memset( PIECE_MASKS, 0, sizeof( PIECE_MASKS ) );
	memset( NPOSPIECE, 0, sizeof( NPOSPIECE ) );
	EN_PASS=DUMMY;
}

int pieceinlist( index, piece, color, square )
int index;
PIECE_NAME *piece;
PIECE_COLOR *color;
SQUARE_NUM *square;
{
  SQUARE_INFO *sqp;
	*square=PIECE_LIST[index].where;
	if( *square!=DUMMY ){
		sqp=&(SQUARE[*square]);
	    *piece=sqp->wood.name;
	    *color=sqp->wood.color;
	} else {
	    *piece=NOPIECE;
	    *color=NOCOLOR;
	}
	return(0);
}

WOOD_PIECE * whoonsquare( SQUARE_NUM square )
{
  SQUARE_INFO *sqp;
	sqp=SQUARE+square;
	return( &sqp->wood );
}

void countpieces( void )
{
  SQUARE_NUM square;
  SQUARE_INFO *sqp;
  int i;

	memset( NPOSPIECE, 0, sizeof( NPOSPIECE ) ); /* clear the piece counters */
	for( i=0; i<TOTAL_NUM_PIECE; i++ ){
		square=PIECE_LIST[i].where;
		if( square==DUMMY ) continue;
		sqp=SQUARE+square;
		NPOSPIECE[sqp->wood.color][sqp->wood.name]++;
	}
}

void set_piece_list( int pieceindex, SQUARE_NUM square )
{
	PIECE_LIST[pieceindex].where=square;
}

int corr_piece_list( SQUARE_NUM from, SQUARE_NUM to, PIECE_COLOR color )
{
  register /*SQUARE_NUM*/ PIECE_IN_LIST *pp;
  int index,i;

	index=KING_INDEX(color); /* get index of king in piece list */
	pp=PIECE_LIST+index; /* get pointer to king */
	for(i=0;i<NUM_PIECE;i++,pp++)
	  if( pp->where==from ){ pp->where=to; break;}
	return(index+i);
}

int near getnewindex( PIECE_COLOR color )
{
  int i;
	for( i=WHITE_PAWN_A; i<NUM_PIECE; i++ ){
		if( PIECE_LIST[ i+NUM_PIECE*color ].where!=DUMMY ) continue;
/*		npiece[color][PAWN]++;*/
		break;
	}
	return(i);
}

int newpiece( SQUARE_NUM square, PIECE_NAME pname, PIECE_COLOR color )
{
  PIECE_MASK mask={0L};
  BYTE *numpp;                /* pointer to number of required piece */
  int index, colorindex;

	numpp=&NPOSPIECE[color][pname]; /* get pointer to number of required piece */
	if( *numpp==8 ) return( ERROR ); /* if number more then 8 - Error */
	colorindex=KING_INDEX(color); /* get color index in piece list */
	switch( pname ){         /* what is piece */
	  case KING: if( *numpp ) return( ERROR );
		mask.word[color]=KING_MASK; /* get king mask */
		index=WHITE_KING;    /* get number in piece list */
		break;
	  case QUEEN: if( *numpp==0 ){ /* queen already exist? */
			mask.word[color]=QUEEN_MASK; /* get default queen mask */
			index=WHITE_QUEEN; break; /* get default queen index */
		}
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new queen mask */
		break;
	  case ROOK: if( *numpp==0 ){ mask.word[color]=LEFT_ROOK_MASK;
			index=WHITE_LEFT_ROOK; break;
		}
		if( *numpp==1 ){ mask.word[color]=RIGHT_ROOK_MASK;
			index=WHITE_RIGHT_ROOK; break;
		}
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  case BISHOP: if( *numpp==0 ){ mask.word[color]=LEFT_BISHOP_MASK;
			index=WHITE_LEFT_BISHOP; break;
      	}
		if( *numpp==1 ){ mask.word[color]=RIGHT_BISHOP_MASK;
			index=WHITE_RIGHT_BISHOP; break;
        }
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  case KNIGHT: if( *numpp==0 ){ mask.word[color]=LEFT_KNIGHT_MASK;
			index=WHITE_LEFT_KNIGHT; break;
      	}
		if( *numpp==1 ){ mask.word[color]=RIGHT_KNIGHT_MASK;
			index=WHITE_RIGHT_KNIGHT; break;
        }
		index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  case PAWN: index=getnewindex( color ); /* get new index */
		mask.word[color]=KING_MASK<<index; /* get new mask */
		break;
	  default: return( ERROR );
	}
	if( index<0 || index>15 ) return(ERROR);
	/*if( pname!=PAWN )*/ *numpp+=1;
	index+=colorindex;
	PIECE_MASKS[pname].word[color]|=mask.word[color]; /* correct the group mask */
	piece_down( square, pname, color, mask.dwrd ); /* put piece on board */
	set_piece_list( index, square );
	return(OK);
}

int deloldpiece( SQUARE_NUM square )
{
	SQUARE_INFO *sqp;
	PIECE_NAME pname;
	PIECE_COLOR color;
	PIECE_MASK mask;

	sqp=SQUARE+square;
	pname=sqp->wood.name;
	color=sqp->wood.color;
	mask.dwrd=sqp->who_mask.dwrd;
	piece_up( square );
	PIECE_MASKS[pname].word[color]&=~mask.word[color];
	corr_piece_list( square, DUMMY, color );
/*	npiece[color][pname]--; /* only in set position */*/
	return(OK);
}

int setposition( PIECE_COLOR move_color )
{
	MOVE_COLOR=move_color;
	CHECK=check( move_color );
/*	if( position.check ) position.ncheck=1; else position.ncheck=0;*/
/*	position.material_eval=material_eval();*/
	return(0);
}

int setstartpos( void )
{
  START_POS *stpp; /* start pos pointer */
  int i;

	init_pos();
	for( i=0; i<8; i++ ){
		stpp=start_pos+i;
		newpiece( stpp->where, stpp->who, stpp->color );
		stpp=stpp+NEXTCOLOR;
		newpiece( stpp->where, stpp->who, stpp->color );
	}
	for( i=0; i<8; i++ ){
		stpp=start_pos+TOPAWN;
		newpiece( stpp->where+i, stpp->who, stpp->color );
		stpp=stpp+NEXTCOLOR;
		newpiece( stpp->where+i, stpp->who, stpp->color );
	}
/*  setcastles */
	CASTLE[ WHITE_PIECE ]= CASTLELEFT | CASTLERIGHT;
	CASTLE[ BLACK_PIECE ]= CASTLELEFT | CASTLERIGHT;

	setposition( WHITE_PIECE );
	return(0);
}

/*int saveposition( int item )
{
	FILE *fp;
	SSTRING wstr, bstr, fname="*.pos";
	int i;

	disablecursor();
	i=nameforsave( fname, fname );
	enablecursor();
	if( i==ERROR ){ checkface(i); return(0); }
	if( i==ESCAPE ){ return(0); }
	sprintpos( wstr, WHITE_PIECE ); sprintpos( bstr, BLACK_PIECE );
	emptystate( reply );
	lastlinereply( wstr );          lastlinereply( bstr );
	fp=fopen( fname, "w" );
	if( fp==NULL ){ message( "Can't open file to write position."); return(1); }
	fputs( wstr, fp ); fputs( "\n", fp );
	fputs( bstr, fp );
	fclose( fp );
	return(0);
}

int loadposition( int item )
{
	FILE *fp;
	SSTRING wstr, bstr, fname="*.pos";
	char *cp;
	int i;
	SQUARE_NUM square;
	PIECE_NAME name;
	PIECE_COLOR color;
	WOOD_PIECE *wpp;

	disablecursor();
	i=findfile( fname, fname );
	enablecursor();
	if( i==ERROR ){ checkface(i); return(0); }
	if( i==ESCAPE ){ return(0); }
	fp=fopen( fname, "r" );
	if( fp==NULL ){ message( "Can't open file to read position"); return(1); }
	cp=fgets( wstr, SHORT_STR_LEN, fp );
	cp=fgets( bstr, SHORT_STR_LEN, fp );
	fclose( fp );
	init_pos();
	if( !(*wstr=='w' && *(wstr+1)==':' && *bstr=='b' && *(bstr+1)==':') ){
		message(" This isn't position file." );
		return(0);
	}
	for( color=WHITE_PIECE; color<NCOLOR; color++ ){
		cp=( color==WHITE_PIECE )? wstr:bstr;
		cp+=2;  /* skip color: "w:" */
		name=NOPIECE;
		while( *cp!='\0' && *cp!='\n' ){
			if( name!=PAWN ) cp=sscanpiece( cp, &name );
			cp=sscansquare( cp, &square );
			wpp=whoonsquare( square );
			if( wpp->name!=NOPIECE ) deloldpiece( square );
			newpiece( square, name, color );
			cp++;  /* skip comma or point */
		}
	}
	setposition( WHITE_PIECE );
	resetprotocol();
	closebase();
	drawboard();
	emptystate( reply );
	lastlinereply( wstr );  lastlinereply( bstr );
	return(0);
}

typedef struct {
  char flag[22];   /* "Kaissa position file" Must be first */
  POSITION pos;
  MOVE prev;
}              SAVEPOS;
static SSTRING defpos="*.pos";
		      /*012345678901234567890*/
static char posfname[]="Kaissa position file";

int saveposition( int item )
{
	FILE *fp;
	SSTRING fname="";
	int i;
	SAVEPOS save;

	disablecursor();
	i=nameforsave( fname, defpos );
	enablecursor();
	if( i==ERROR ){ checkface(i); return(0); }
	if( i==ESCAPE ){ return(0); }
	unlink(fname);
	fp=fopen( fname, "wb" );
	if( fp==NULL ){ message( "Can't open file to write position."); return(0); }
	copy_position( &save.pos, &pos_buf, FULLPOSSIZE);
	movecpy( &save.prev, PREVIOUS );
	memccpy( save.flag, posfname, '\0', 25 );
	i=fwrite( &save, sizeof( SAVEPOS ), 1, fp );
	if( i!=1 ) message( " Save Position: Write file error. ");
	fclose( fp );
	return(0);
}

int loadposition( int item )
{
	FILE *fp;
	SSTRING fname="";
	int i;
	SAVEPOS save;

	disablecursor();
	i=findfile( fname, defpos );
	enablecursor();
	if( i==ERROR ){ checkface(i); return(0); }
	if( i==ESCAPE ){ return(0); }
	fp=fopen( fname, "rb" );
	if( fp==NULL ){ message( "Can't open file to read position"); return(0); }
	i=fread(&save,sizeof(SAVEPOS),1,fp);
	if( i!=1 ) message(" Load Position: Read file error. ");
	fclose( fp );
	if( memcmp( save.flag, posfname, 15 )){
		message(" This isn't position file." );
		return(0);
	}
	copy_position( pos_stk, &save.pos, FULLPOSSIZE );
	copy_position( &pos_buf, &save.pos, FULLPOSSIZE );
	copy_position( &position, &save.pos, FULLPOSSIZE );
	movecpy( move_stk, &save.prev );
	setcolor(MOVE_COLOR);
	set_game_stk();
	return(0);
}
*/

