/*
	 ͻ
	     Functions for make foreward and backward moves             
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <mem.h>
#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"
#include "dbmove.h"

PIECE_COLOR revcolor[NCOLOR]={ BLACK_PIECE, WHITE_PIECE };
static MOVE *Movep;
static BYTE Mflag;
static BOOLEAN Move_capture;
static MAT_EVAL Cost_captured;
/*
static POSITION far *Next_pos;
static BOOLEAN Suff_capture;   /* True if capture is sufficient */
*/
static PIECE_COLOR Color, Enemycolor;

/*
static void near countnslow( int checkstate );
	/* Count number of slow moves at the branch. */
static void near countncheck( int checkstate );
	/* Count number of checks and checks in fv. */
*/
int check( PIECE_COLOR color ) /* test check status */
{
	SQUARE_NUM kingsq;       /* number of king square */
	SQUARE_INFO *kingsqp;    /* pointer to king square information */
	int i;

	kingsq=PIECE_LIST[KING_INDEX(color)].where; /* get square of king */
	kingsqp=SQUARE+kingsq; /* get pointer to square info */
	color= 1- color; /* enemy color */
	i=kingsqp->attackedby.word[color];
	return( i!=0 );  /* !!! must be number of checks */
}

void near make_promotion( PIECE_NAME pname, DWORD mask )
{                                   /* correct group mask: */
	PIECE_MASKS[PAWN].dwrd&=~mask; /* clear from pawn's mask */
	PIECE_MASKS[pname].dwrd|=mask; /* set to piece's mask */
}

void near deletemask( PIECE_NAME pname, DWORD mask )
{                                   /* correct group mask: */
/*	POS_MASK.dwrd&=~mask; /* del mask of captured piece */*/
	PIECE_MASKS[pname].dwrd&=~mask; /* del mask of captured piece */
}

#define LEFT_CASTLE_LEN  3
#define RIGHT_CASTLE_LEN 2

void near make_castle( BYTE flag )
{
  SQUARE_NUM from, to, base;
  PIECE_MASK mask;
  CASTLES *castp;

	castp=&(CASTLE[Color]);
	mask.dwrd=0L;
	base=( Color==WHITE_PIECE )? a1:a8; /* get base square for castle */
	if( flag & CASTLE_LEFT ){ /* long or short castle */
		from=base; to=base+LEFT_CASTLE_LEN; /* get squares from and to */
		mask.word[Color]=LEFT_ROOK_MASK; /* get mask to rook */
		*castp |= CASTLELEFTDONE;
	} else {
		from=base+LINELEN-1; to=from-RIGHT_CASTLE_LEN;
		mask.word[Color]=RIGHT_ROOK_MASK;
		* castp |= CASTLERIGHTDONE;
	}
	piece_up( from );        /* raise rook from board */
	piece_down( to, ROOK, Color, mask.dwrd ); /* place rook to board */
	corr_piece_list( from, to, Color );
	*castp &= ~CASTLERIGHT;
	*castp &= ~CASTLELEFT;
}

void near make_en_passant( SQUARE_NUM to )
{
  SQUARE_INFO *sqp;
	to=(Color==WHITE_PIECE )? to-LINELEN:to+LINELEN;
	sqp=SQUARE+to; /* get to square pointer */
	deletemask( PAWN, sqp->who_mask.dwrd );
	corr_piece_list( to, DUMMY, Enemycolor );
	piece_up( to );
}
/*
void near move_pos( register POSITION far *dest, register POSITION far *src )
{
	dest->first=src->last;             /* set move stack pointer */
	dest->nslow=src->nslow;            /* number of slow moves */
	dest->neval=src->neval;            /* number os evaluations */
	dest->ncheck=src->ncheck;          /* number of checks */
	dest->nfvcheck=src->nfvcheck;      /* number of checks in fv */
	dest->status=src->status;          /* status for generator */
	dest->previous=src->current;       /* set previouse move pointer */
	dest->material_eval=-src->material_eval; /* set material eval */
	dest->en_pass=DUMMY;               /* clear en passant square */
	dest->check=0;                     /* reset check status */
	dest->capt_flag=0;
	dest->move_color=Enemycolor;
}
*/
int move( void )
{
  register SQUARE_NUM from, to;
  SQUARE_INFO *fromp, *top;
  PIECE_MASK whomask;
  WORD whotomask;
  PIECE_NAME name;
  int i;

	Movep=&CURMOVE;   /* get current move pointer */
	Color=MOVE_COLOR;
	Enemycolor=1-Color;
	EN_PASS=DUMMY;
	CHECK=0;
	Mflag=Movep->flags;      /* get move status flags */
	from=Movep->from;
	to=Movep->to;
	fromp=SQUARE+from; /* get from square pointer */
	top=SQUARE+to; /* get to square pointer */
	whomask=fromp->who_mask; /* save the piece mask */
	name=fromp->wood.name;
	Move_capture=(top->wood.name!=NOPIECE);
	if( Move_capture ){  /* this is capture */
		whotomask=top->who_mask.word[Enemycolor]; /* M.D. */
		if (whotomask & LEFT_ROOK_MASK) {
			CASTLE[Enemycolor] &= ~CASTLELEFT;
		}  else if ( whotomask & RIGHT_ROOK_MASK) {
			CASTLE[Enemycolor] &= ~CASTLERIGHT;
		}
		corr_piece_list( to, DUMMY, Enemycolor );
		deletemask( top->wood.name, top->who_mask.dwrd );
	}
	piece_up( from ); /* raise piece from board */
	if( name==PAWN ){
		i=from-to;
		if( i==16 || i==-16 ) /* this is pawn jump */
			EN_PASS=from-i/2;			/* M.D. */
    }
	piece_down( to, name, Color, whomask.dwrd ); /* set piece to board */
	corr_piece_list( from, to, Color );
	if( check( Color ) ) return(1);

	if( Mflag & (CASTLE_LEFT|CASTLE_RIGHT) ){ /* Make the castle */
		make_castle( Mflag );
	} else if( name==KING ) { /* ELSEs inserted by ADubets 16 july 90 */
		CASTLE[Color] &= ~CASTLELEFT;
		CASTLE[Color] &= ~CASTLERIGHT;
	} else if( name==ROOK ){
		i=GETFILE( from );
		if( i==0 ) CASTLE[Color] &= ~CASTLELEFT;
		if( i==7 ) CASTLE[Color] &= ~CASTLERIGHT ;
	} else if( Mflag & EN_PASSANT ){
		make_en_passant( to );
		Cost_captured=PAWN_COST;
	}

	if( (i=check( Enemycolor ))!=0 ){
		CHECK=i;
	}

	Movep->flags=Mflag;
	MOVE_COLOR=Enemycolor;
	return(0);
}

void move_back( void )
{
  int savelevel;
  BASEPOS *savesp;
	savelevel=level; savesp=basesp;
	setstartpos();
	for( level=0, basesp=stkinfo[stacknum].bp; level<savelevel-1; level++, basesp++ )
		move();
	level=savelevel; basesp=savesp;
}

void codemove( MOVE *mp, BASEMP bmp )
{
	mp->from=FROM;
	mp->to=TO;
	mp->flags=0;
/*	mp->profit=0;*/
	if( CAPT ) mp->flags |= CAPTURE;
	if( IS_ENPASS ) mp->flags |= EN_PASSANT;
	if( RIGHT_CASTLE ) mp->flags |= CASTLE_RIGHT;
	if( LEFT_CASTLE ) mp->flags |= CASTLE_LEFT;
}
