/*
	 ͻ
	          Entering new move                                     
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <stdlib.h>          /* abs() */
#include <mem.h>             /* setmem() */

#include "face.h"
#include "facekeys.h"
#include "facemous.h"

#include "dbchess.h"
#include "dbase.h"
#include "dbmove.h"
#include "dbbdraw.h"
#include "dbproc.h"

extern char cursquare, redsquare;
int moveready=0;
static BASEMOVE inmove;

static int near takepiece( void )
{
  WOOD_PIECE *wpp;
  BASEMP bmp=&inmove;
	wpp=whoonsquare( cursquare );
	if( wpp->name!=NOPIECE && wpp->color==MOVE_COLOR ){
		setmem( &inmove, sizeof( BASEMOVE ), 0 );
		redsquare=cursquare;
		WHO=wpp->name;
		FROM=redsquare;
	}
	return(0);
}

static int near leavepiece( void )
{
  WOOD_PIECE *wpp;
  BASEMP bmp=&inmove;
	clearframe( redsquare );
	wpp=whoonsquare( cursquare );
	if( wpp->color==MOVE_COLOR ){
		setmem( &inmove, sizeof( BASEMOVE ), 0 );
		redsquare=cursquare;
		WHO=wpp->name;
		FROM=redsquare;
	} else {
		TO=cursquare;
		fillmove( bmp );
		redsquare=DUMMY;
		moveready=1;
	}
	return(0);
}

int boardspace( void )
{
	if( redsquare==DUMMY ) takepiece();
	else leavepiece();
	if( moveready )
		{ proceedmove( &inmove ); moveready=0; }
	boardcursor(0);
	return(0);
}

int boardmouse( int key )
{
  int x, y, newsquare;
	getmouseloc( &x, &y );
	if( !onboard( &x, &y ) ) return(0);
	newsquare=GETOFFSET( x, y );
	switch( key ){
	  case LEFTPRESS: cursquare=newsquare; boardcursor(0);
		break;
	  case LEFTRELEAS: cursquare=newsquare; boardspace();
		break;
	  case LEFTBUTTMOVE:
		if( redsquare==DUMMY ) takepiece();
		cursquare=newsquare;
		boardcursor(0);
		break;
	}
	return(0);
}

int fillmove( BASEMP bmp )
{
  SQUARE_INFO *sqp;
	if( RIGHT_CASTLE ){
		WHO=KING;
		if(MOVE_COLOR) { FROM=e8; TO=g8; } /* Black */
		else { FROM=e1; TO=g1; }           /* White */
	} else if( LEFT_CASTLE ){
		WHO=KING;
		if( MOVE_COLOR ) { FROM=e8; TO=c8; }
		else { FROM=e1; TO=c1; }
	} else if( WHO==KING && FROM==TO ){
		if( FROM==h1 ) RIGHT_CASTLE=1;
		if( FROM==a1 ) LEFT_CASTLE=1;
		if( MOVE_COLOR ) { FROM=e8; TO=c8; }
		else { FROM=e1; TO=c1; }
	} else if( WHO==KING ){
		if( (FROM==e1 && TO==g1)||(FROM==e8 && TO==g8) ) RIGHT_CASTLE=1;
		if( (FROM==e1 && TO==c1)||(FROM==e8 && TO==c8) ) LEFT_CASTLE=1;
	}
	sqp=SQUARE + TO;
	CAPT=(sqp->wood.name!=NOPIECE)? 1:0;
	if( WHO==PAWN ){
/*	No promotion: if( (GETLINE( TO )==0 || GETLINE( TO )==7 )){
			bmp->prom=QUEEN;
			FLAG|=PROMOTION;
		} else bmp->prom=NOPIECE;
*/
		if( abs(FROM-TO)==9 || abs(FROM-TO)==7 )
			if( !CAPT ){
				IS_ENPASS=1;
				CAPT=1;
			}
	}
	return(0);
}
