/*
	 ͻ
	              Procedures for edition of debut base              
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/
#include <mem.h>             /* memcpy(), */
#include <alloc.h>           /* calloc() */
#include <setjmp.h>          /* jmp_buff, setjump(), longjump() */

#include "face.h"
#include "facekeys.h"
#include "faceproc.h"

#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"
#include "dbwind.h"
#include "dbmove.h"
#include "dbbdraw.h"
#include "dberror.h"
#include "dbfile.h"

#define CHECK_IO( fun ) if((i=(fun))!=OK){ message(errmessage[i]); return(0); }

void checkmoves( BASEMP bmp );
int checkcastle( BASEMP bmp );
int addlevel( BASEMP bmp );

extern BASEMOVE inmove;
jmp_buf jmp;
int add_move, del_move,add_level;/*counters add/del move & add level*/
int tosave=0;
int reload=1;
char cancel[]="  Cancel ";

BASEMP getlast( BASEMP bmp ) /* search last move on level */
{
	while( !LASTMOVE ) bmp++;
	return( bmp );
}

BASEMP getfirst( BASEMP bmp ) /* search first move on level */
{
	while( !FIRSTMOVE )	bmp--;
	return( bmp );
}

int getmovenum( BASEMP bmp ) /* count number of moves on level */
{
  int i=1;
	while( !LASTMOVE ) { i++; bmp++; }
	return(i);
}

int addmove( BASEMP newbmp ) /* to add move to the end of level */
{
  BASEMP newlevel, lastbmp, firstbmp;
  int nmove, i;
/** No request *******************************************************
  char movestr[40];
  char *strp[]={ NULL, cancel, NULL };
	sprintfmove( movestr," Add move: %m? ", newbmp );      /* make move string */
	strp[0]=movestr;
	i=makedialog( strp );
	if( i==0 || i==2 ) return(1);
*/
	lastbmp=firstbmp=BPFIRST;     /* pointer to first move */
	nmove=getmovenum( firstbmp ); /* count number of moves */
	lastbmp=firstbmp+nmove-1;     /* get last move on level */
	newlevel=calloc( nmove+1, sizeof( BASEMOVE ) );/* allocate memory for new move */
	if( !newlevel )			      /* check result of allocation */
		{ message(" No memory to insert move. "); return( ERROR ); }

	lastbmp->last=0;              /* clear LAST flag in prev. move */
	newbmp->last=1;                /* set LAST flag in new move */
	setmask( newbmp->flags, ADDMOVE ); /* set flags new move */
	newbmp->next=NULL;
	memcpy( newlevel, firstbmp, nmove*sizeof(BASEMOVE) ); /* move level */
	memcpy( newlevel+nmove, newbmp, sizeof(BASEMOVE));  /* copy new move to empty space */
	add_move++;			          /* calc. add. move*/
	BPFIRST=newlevel;
	setmask( BPFIRST->flags, SAVELEVEL );   /* level must be saved */
	BPLAST=newlevel+nmove;
	BPCURRENT=newlevel+nmove;
	BPCURNUM=nmove;
	if( level ) (basesp-1)->current->next=newlevel;
	else nullmove.next=newlevel;
	tosave=1; reload=1;                /* base must be saved */
	freelevel( firstbmp );
	CHECK_IO( checklevel( BPFIRST ) ); /* save all changes into the file */
	showlevel();
	return(0);
}

int addlevel( BASEMP bmp ) /* make new level after current move */
{
  int i;
  BASEMP nodebmp, newlevel;
	if( level==0 && BPFIRST==NULL ) nodebmp=&nullmove;
	else nodebmp=(basesp-1)->current;
	newlevel=calloc( 1, sizeof( BASEMOVE ) );/* allocate memory for new move */
	if( !newlevel )			      /* check result of allocation */
		{ message(" No memory for new level. "); return( ERROR ); }
	LASTMOVE=1;                   /* set LAST flag in new move */
	FIRSTMOVE=1;                  /* set FIRST flag in new move */
	setmask( EDITFLAG, ADDMOVE|SAVELEVEL ); /* set new move & level flag */
	setmask( nodebmp->flags, ADDLEVEL ); /* set new level flag */
	memcpy( newlevel, bmp, sizeof( BASEMOVE ) ); /* copy move */
	add_move++;			          /* calc. add. move*/
	BPFIRST=BPLAST=BPCURRENT=newlevel; /* init stack pointers */
	BPCURNUM=0;                   /* set current move number */
	nodebmp->next=newlevel;       /* link with previouse level */
	tosave=1; reload=1;                     /* base must be saved */
	bmp=getfirst( nodebmp );      /* get first move of previouse level */
	setmask( EDITFLAG, SAVELEVEL );  /* prev. level must be rewritten */
	CHECK_IO( checklevel( bmp ) ); /* save all changes into the file */
	showlevel();
	return(0);
}

int newmove( BASEMP newbmp )
{
	if( !BPFIRST ) return( addlevel( newbmp ) );
	else return( addmove( newbmp ) );
}

int deletemove( void ) /* to delete given move from base */
{
  char movestr[40];
  char *str[]={ NULL, cancel, NULL};
  BASEMP bmp, nodebmp;
  int i;
	if( (bmp=BPCURRENT)==NULL ) return(0); /* <=== Error */
	sprintfmove( movestr," Delete move: %m ", bmp );      /* make move string */
	str[0]=movestr;
	i=makedialog( str );               /* request user about deleting move */
	if( i==0 || i==2 ) return(0);      /* pressed ESCAPE or Cancel */
	if( FIRSTMOVE && LASTMOVE ){       /* only one move on level */
		if( level==0 ) nodebmp=&nullmove;
		else nodebmp=(basesp-1)->current;
		freelevel( bmp );              /* free this level */
		BPFIRST=BPCURRENT=NULL;        /* del level from stack */
		bmp=nodebmp;                   /* get previouse move in stack */
		setmask( EDITFLAG, DELLEVEL ); /* delete whole level */
		NEXT=NULL;                     /* clear link */
		bmp=getfirst( bmp );           /* get first move on prev. level */
		setmask( EDITFLAG, SAVELEVEL ); /* level must be saved */
		CHECK_IO( checklevel( bmp ) ); /* save all changes into the file */
	} else {
		setmask( EDITFLAG, DELMOVE );
		setmask( BPFIRST->flags, SAVELEVEL );   /* level must be saved */
		CHECK_IO( checklevel( BPFIRST ) ); /* save all changes into the file */
	}
	tosave=1; reload=1;                     /* base must be saved */
	showlevel();
	return(0);
}
/*
int restoremove( void ) /* to restore deleted move */
{
  BASEMP bmp;
	if( (bmp=BPCURRENT)==NULL ) return(0); /* <=== Error */
	clearmask( EDITFLAG, DELMOVE );
	tosave=1; reload=1;                     /* base must be saved */
	showlevel();
	return(0);
}
*/
int togglebestmove( void ) /* set flag BEST to current move */
{
  BASEMP bmp;
  int i;
	bmp=BPCURRENT;
	if( !bmp )
		return( ERROR );
	if( BESTMOVE ) BESTMOVE=0;
	else           BESTMOVE=1;
	setmask( EDITFLAG, REWRITE );
	setmask( BPFIRST->flags, SAVELEVEL );   /* level must be saved */
	CHECK_IO( checklevel( BPFIRST ) );  /* save all changes into the file */
	tosave=1; reload=1;                 /* base must be saved */
	showlevel();
	return(0);
}

int makelink( void )
{
  char *str[]={
  " Link positions on Edit tree with View tree. ", cancel, NULL};
  char *str1[]={
  " Positions are not identical. Continue ? ", cancel, NULL};
  int i;
  long int index;
  BASEMP bmp;
    if( stkinfo[0].posp->move_color != stkinfo[1].posp->move_color ){
        message(" Can't link positions: turn move difference ");
        return 0;
    }
	i=makedialog( str );               /* request user about ... */
	if( i==0 || i==2 ) return(0);      /* pressed ESCAPE or Cancel */
	if( memcmp( stkinfo[0].posp, stkinfo[1].posp, sizeof( POSITION )) ){
		/* check positions are identical there */
	    i=makedialog( str1 );               /* request user about ... */
	    if( i==0 || i==2 ) return(0);      /* pressed ESCAPE or Cancel */
	}
	bmp=stkinfo[1].sp->first;          /* get first move of this level */
	index=OWNLINK;                     /* get index of move in file */
	if( !index ) return( ERROR );
	bmp=(stkinfo[0].sp-1)->current;    /* get previouse move */
	if( !bmp ) return( ERROR );
	if( bmp->next )                         /* freeing old NEXT */
		{ freelevel( bmp->next ); bmp->next=NULL; }
	bmp->vlink=index;                  /* link in file */
	bmp->next=readlevel( bmp->vlink );
    if( !bmp->next ){ message( errmessage[errorcode] ); return(0); }
	stkinfo[0].sp->first=stkinfo[0].sp->current=bmp->next;
	CHECK_IO( readbranch( bmp->next ) ); /* load all branches of this level */
	setmask( bmp->flags, REWRITE );      /* move must be saved */
	bmp=(stkinfo[0].sp-1)->first;        /* get first move of previouse level */
	setmask( bmp->flags, SAVELEVEL );    /* level must be saved */
	CHECK_IO( checklevel( bmp ) );     /* save all changes */
	tosave=1; reload=1;                /* base must be saved */
	showlevel();
	return(0);
}

/********************************************************************/
/*** Base Search Tree Algorithm *************************************/
/********************************************************************/
/*
unsigned long int movecount=0;
int breaksearch=0;

static int near down( void )
{                            /* return 1 if DOWN succeed else 0 */
  static char str[80]=" ";
	if( kbhit() ) if( getfacekey()==ESCAPE ) /*breaksearch=1;*/
		longjmp(jmp,1);
	if( breaksearch ) return(0);
	if( BPCURRENT==BPLAST )
		return(0);
/*	if( BPCURRENT->flag & NULLMOVE ){
		BPCURRENT++; BPCURNUM++;
		return(0);
	}
*/
/*** !!!! check castles there ****************************************/
/*	if( (BPCURRENT->flag & CASTLE_RIGHT )||
		(BPCURRENT->flag & CASTLE_LEFT ) ||
		(BPCURRENT->from==BPCURRENT->to) )
			while( !checkcastle( BPCURRENT ) );
*/
/*********************************************************************/
/*	(basesp+1)->first=BPCURRENT->vlink;*/
	codemove( &CURMOVE, BPCURRENT );
	if( move() ){
		move_back();
		BPCURRENT++; BPCURNUM++;
		return(0);
	}
/*	dispmove( BPCURRENT, level );*/
	INCSTACK;
	movecount++;
/*	drawboard();*/
	if( level==0 ) 	posstate( tree, (BPCURNUM>0)? BPCURNUM:1, 1 );
	temphelpline( ultoa( movecount, str, 10 ) );
	return(1);
}

static int near up( void )
{                            /* return 1 if UP succed else 0 */
	if( level==0 ) return(0);
	move_back();
	BPCURRENT=NULL;
	BPCURNUM=0;
/*	clearmove( level-1 );*/
	DECSTACK;
	BPCURRENT++; BPCURNUM++;
/*	drawboard();*/
	return(1);
}

static int near baseamerican( void )
{
  BASEMP bmp;
	if( level==50-1 ) return(0);
	if( BPFIRST==NULL ) return(0);
	bmp=BPFIRST;
	while( !LASTMOVE ) bmp++;
	BPLAST=bmp+1; /* BPLAST is pointer to next move after last on level */
	BPCURNUM=0; BPCURRENT=BPFIRST;
	checkmoves( BPFIRST );     /* check & fill all moves on level */
	return(1);
}

static int near baserussian( void )
{
	return(0);
}

static int near basechinese( void )
{
	return(0);
}

int playbase()	/* the main tree search function */
{
  if ( !setjmp(jmp)) {
	   movecount=breaksearch=0;
/*	   resetbase();        	/* begin search */*/
	   labelmain: if ( !baseamerican() ) goto labelup;
	   labeldown: if ( down()    ) goto labelmain;
	   labelup:   baserussian();
			  if ( !up()      ) goto labelexit;
			  if ( basechinese() ) goto labelup;
			  goto labeldown;
	   labelexit:
/*	   resetbase();       /* end search */*/
	   restorehelpline();
  }
  return(0);
}
*/
/*
static int near shortcastle( PIECE_COLOR color )
{
	if( color==WHITE_PIECE ){
		if( SQUARE[f1].wood.name==NOPIECE &&
			SQUARE[g1].wood.name==NOPIECE ) return(1);
				else return(0);
	} else {
		if( SQUARE[f8].wood.name==NOPIECE &&
			SQUARE[g8].wood.name==NOPIECE ) return(1);
				else return(0);
	}
}

static int near longcastle( PIECE_COLOR color )
{
	if( color==WHITE_PIECE ){
		if( SQUARE[b1].wood.name==NOPIECE &&
			SQUARE[c1].wood.name==NOPIECE &&
			SQUARE[d1].wood.name==NOPIECE ) return(1);
				else return(0);
	} else {
		if( SQUARE[b8].wood.name==NOPIECE &&
			SQUARE[c8].wood.name==NOPIECE &&
			SQUARE[d8].wood.name==NOPIECE ) return(1);
				else return(0);
	}
}

int checkcastle( BASEMP bmp )
{
  int i;
  char movestr[80]=" ";
  char *str[]={" Short castle: 0-0 "," Long castle:  0-0-0 ",
	" Not a castle ", NULL };

	i=0;
	if( shortcastle( MOVE_COLOR ) ) i=1;
	if( longcastle( MOVE_COLOR ) ) i+=2;
	if( i==3 ){
		sprintmove( movestr, bmp );
		temphelpline( movestr );
		drawboard();
		drawprotocol();
		i=makedialog( str );
		restorehelpline();
	}
	FLAG &= ~(CASTLE_RIGHT|CASTLE_LEFT);
	switch( i ){
	  case 1:                          /* this is short castle */
		FLAG |= CASTLE_RIGHT;
		if( MOVE_COLOR==WHITE_PIECE ){ FROM=e1; TO=g1; }
		else { FROM=e8; TO=g8; }
		break;
	  case 2:                          /* this is long castle */
		FLAG |= CASTLE_LEFT;
		if( MOVE_COLOR==WHITE_PIECE ){ FROM=e1; TO=c1; }
		else { FROM=e8; TO=c8; }
		break;
	  case 3:                          /* not a castle, set NULLMOVE */
		FLAG |= NULLMOVE;
	  case 0: longjmp(jmp,1);
		break;
	  default: return(0);
	}
	return(1);
}
*/
