/*
	 ͻ
	          Functions for show new moves, levels                  
	                 and other parameters                           
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <stdlib.h>          /* exit() */
#include <stdio.h>           /* sprintf() */
#include <dir.h>             /* findfile() */
#include <dos.h>             /* */
#include <string.h>          /* strcpy() */
#include <alloc.h>           /* coreleft() */

#include "myface.h"
#include "faceproc.h"
#include "myfacpro.h"
#include "facekeys.h"
#include "facerr.h"
#include "facemous.h"

#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"
#include "dbwind.h"
#include "dbbdraw.h"
#include "dbmove.h"
#include "dberror.h"

#include "iface.h"

int baseexit( void )
{
	setmoded(3);
	mouseintmask( 0 );
	exit(1);
	return(0);
}

int showcurrent( BASEMP bmp, int level )
{
  char str[100]=" ";
	sprintmove( str, bmp );
	posstate( tree, level+1, 1 );
	deleol( tree );
	checkface( putstring( tree, str ) );
	return(OK);
}

int showlevel( void )
{
  char buff[40]=" ";
  BASEMP bmp;
  int file, line;
	freezed=1;
	file=getcurx( tree ); line=getcury( tree );
	emptystate( tree );
	setupwind( tree );
	bmp=BPFIRST;
	if( bmp==NULL ){
		sprintf( buff, " No more" );
		checkface( newline( tree, buff ) );
		freezed=0; refresh( tree );
		return(OK);
    }
	while(1){
		if( EDITFLAG & DELMOVE ) sprintf( buff, "   Deleted" );
		else {
			sprintfmove( buff,"   %m   ", bmp );
			if( BESTMOVE ) buff[1]='*';
		}
		checkface( newline( tree, buff ) );
		if( LASTMOVE ) break;
		bmp++;
	}
	shownextlevel();
	posstate( tree, line, file );
	freezed=0; refresh( tree );
	return(OK);
}

int shownextlevel( void )
{
  static char top0[]="", top1[]=" ";
  static char vertline[]="  ";
  static char cur0[]=" ", cur1[]="Ĵ ";
  char buff[40]=" ", *cp;
  int nmove, i, top, left, bott, right;
  int file, line, freezedone=0;
  BASEMP bmp;
	if( !freezed ){ freezed=1; freezedone=1; }
	file=getcurx( tree ); line=getcury( tree );
	posstate( tree, 1, 2 );
	checkface( getposwindow( tree, &top, &left, &bott, &right ) );
	for( i=0; i<bott-top-1; i++ ){
		posstate( tree, i+1, 2 );
		deleol( tree );
	}
	bmp=BPCURRENT->next;
	nmove=1;
	while(1){
		posstate( tree, nmove, 2 );
		if( bmp==NULL ){
			sprintf( buff, "    No more" );
			checkface( putstring( tree, buff ) );
			break;
		}
		if( EDITFLAG & DELMOVE ) sprintf( buff, "     Deleted" );
		else {
			sprintfmove( buff,"     %m  ", bmp );
			if( BESTMOVE ) buff[4]='*';
		}
		checkface( putstring( tree, buff ) );
		if( LASTMOVE ) break;
		bmp++; nmove++;
	}
	for( i=0; i<BPCURNUM+1; i++ ){
		if( i==0 ){ if( BPCURNUM==0 ) cp=top0; else cp=top1; }
		else if( i==BPCURNUM ){ if( i<nmove-1 ) cp=cur1; else cp=cur0; }
		else cp=vertline;
		posstate( tree, i+1, 2 );
		checkface( putstring( tree, cp ) );
	}
	posstate( tree, line, file );
	if( freezedone ){ freezed=0; refresh( tree ); }
	return(OK);
}

int clearlevel( int level )
{
	posstate( tree, level+1, 1 );
	deleol( tree );
	return(OK);
}

char * sprintlevel( char *str, BASEMP bmp )
{
	while(1){
		if( EDITFLAG & DELMOVE ) {
/***** teporary code! del single move= del level! **************/
		  if ( LASTMOVE )
			break;
		  bmp++;
		}
		if( BESTMOVE ) *str++='*';
		else *str++=' ';
		str=sprintmove( str, bmp );
		str--;
		if( LASTMOVE ) break;
		bmp++;
	}
	return(str);
}

int dispmove( BASEMP bmp, int nmove )
{
  char str[MOVESTRLEN*2];
  char movestr[MOVESTRLEN+1];
  int nextnum;
	freezed=1;
	sprintmove( movestr, bmp );
	if( nmove%2==0 ) sprintf( str,"  %2d. %s", nmove/2+1, movestr );
	else sprintf( str,"   %s", movestr );
	posstate( protocol , nmove/2+1,nmove%2+1 );
	checkface( putstring( protocol , str ) );
	nextnum=nmove+1;
	if( nextnum%2==0 ){
		sprintf( str,"  %2d.", nextnum/2+1 );
		posstate( protocol , nextnum/2+1, nextnum%2+1 );
		checkface( putstring( protocol , str ) );
	}
	posstate( protocol , nmove/2+1,nmove%2+1 );
	freezed=0; refresh( protocol  );
	return(0);
}

int clearmove( int nmove )
{
  int nextnum;
	freezed=1;
	posstate( protocol , nmove/2+1, nmove%2+1 );
	deleol( protocol  );
	nextnum=nmove+1;
	if( nextnum%2==0 ){
		posstate( protocol , nextnum/2+1, nextnum%2+1 );
		deleol( protocol  );
	}
/*	gotowindow( protocol , 5, getcurx(protocol ));*/
	if( nmove ) posstate( protocol , (nmove-1)/2+1,(nmove-1)%2+1 );
	freezed=0;
	refresh( protocol  );
	return(0);
}
/*
void drawprotocol( void )
{
  int l;
	for( l=0; l<level+1; l++ ){
		dispmove( basestk[l].current, l );
	}
}
*/
int replyline( char *str )
{
	checkface( newline( reply, str ) );
	refresh( reply );
	return(0);
}

int viewreply( void  )
{
	waitkey( reply );
	return(0);
}

int repaint( void )
{
	showlevel();
	checkface( posstate( tree, BPCURNUM+1, 1 ) );
	showstatistic();
	refresh( tree );
	setwritten( board );
	checkface( refresh( board ) );
	return(0);
}

char srcfile[MAXPATH]="NONAME.DBE";    /* source file name */
char tempfile[MAXPATH]="NONAME.TMP";   /* temporary file name */
char bakfile[MAXPATH]="NONAME.BAK";    /* back up file name */
char srcdrive[MAXDRIVE]="C:";          /* source file drive */
char srcdir[MAXDIR]="";                /* source file directory */
char srcname[MAXFILE]="NONAME";        /* source file name */
char srcext[MAXEXT]=".DBE";            /* source file extension */
char defstr[MAXPATH]="*.DBE";          /* default file mask or name */
char defext[MAXEXT]=".DBE";            /* default extension */
static int fload=0;                    /* file already loaded */

int removebase( void )
{
	setstack(1); resetstack();
	setstack(0); resetstack();
	closebase();
	unlink( tempfile );
	fload=0;
	return(0);
}

int loadbase( void )
{
  WINP wp;
  int i;
	wp=getwindow();
	if( !wp ){ checkface(0); return(0); }
	makefilewnd( wp, 4, 5, " Load Base Name ");
	i=searchfile( wp, srcfile, defstr );
	checkface( freewindow( wp ) );
	if( i!=OK ) return(0); /* Escape pressed or error */
	removebase();
	stoupper( srcfile );
	fnsplit( srcfile, srcdrive, srcdir, srcname, srcext );
	fnmerge( tempfile, srcdrive, srcdir, srcname, ".TMP" );
	fnmerge( bakfile, srcdrive, srcdir, srcname, ".BAK" );
	if( *srcdrive=='\0' ) *srcdrive='A'+getdisk();
	i=maketemp( srcfile );
	if( i ) message( errmessage[i] );
	i=loadbasefile( tempfile );
	if( i ) message( errmessage[i] );
	else {
		fload=1;
		resetbase();
	}
	return(0);
}

int savebase( void )
{
  WINP wp;
  int i;
  struct ffblk blk;
  char msg[50], dir[MAXDIR];
  char *str[]={ NULL," Terminate. ",NULL};
    if( !tosave ) return 0;
	if( !fload ){
		wp=getwindow();
		if( !wp )
			{ checkface(0); return(0); }
		makefilewnd( wp, 5, 5, " Save Base Name ");
		i=searchfile( wp, srcfile, defstr );
		checkface( freewindow( wp ) );
		if( i!=OK )
			return(0); /* Escape pressed or error */
		i=findfirst( srcfile, &blk, 0 );
		if( i==0 ){
			sprintf( msg, " File '%s' exist. Overwrite? ", srcfile );
			str[0]=msg;
			i=makedialog( str );
			if( i!=1 )
				return(0);
		}
		stoupper( srcfile );
		fnsplit( srcfile, srcdrive, dir, srcname, srcext );
		fnmerge( tempfile, srcdrive, srcdir, srcname, ".TMP" );
		fnmerge( bakfile, srcdrive, srcdir, srcname, ".BAK" );
/*		i=creatbasefile( srcfile );
		i=closebase();
		if( i ){ message( errmessage[i] ); return(0); }
		rename( tempfile, srcfile );
		i=maketemp( srcfile );
		if( i ){ message( errmessage[i] ); return(0); }
		else */
		fload=1;
	}
	sprintf( msg, " Saving file '%s'. Please wait . . .", srcfile );
	temphelpline( msg );
	unlink( bakfile );
	rename( srcfile, bakfile );
	i=copytemp( srcfile );
	if( i ) message( errmessage[i] );
	tosave=0;
	restorehelpline();
	showstatistic();
	return(0);
}

int asktosave( void )
{
  char *strp[]={" Changes will be lost. Save it ? ",
	"   Not save ","   Cancel", NULL };
  char msg[80];
  int i;
    if( !tosave ) return 0;
	i=makedialog( strp );    /* request user */
	if( i==0 || i==3 ) return(1); /* cancel command */
	if( i==1 ) savebase();  /* save base into the file, else not save */
	tosave=0;                /* clear flag to save */
	return(0);               /* continue */
}

void showstatistic( void )
{
  unsigned int mem;
  char str[80]="";
	mem=coreleft();
	freezed=1;
	posstate( infowind, 1, 40 ); deleol( infowind );
	/* Free: 40,000 byte  File: a:filename.ext */
	sprintf( str,"Free: %-2u,%03u byte ", mem/1000, mem%1000 );
	checkface( putstring( infowind, str ) );
	posstate( infowind, 1, 60 );
	sprintf( str,"File: %s%s%s ", srcdrive, srcname, srcext );
	checkface( putstring( infowind, str ) );
	freezed=0; refresh( infowind );
}

int inspect( void )
{
  long int index;
  int i, done;
  char *str[10], *cp;
  char pos[80]=" ", err[80]=" Err: ";
  char edit[80]=" ";
  char buff[80]=" ", dump[80]=" ";
  BASEMP bmp;

	if( (bmp=BPCURRENT)==NULL ) return(0);
	cp=pos+1; i=0;
	if( BESTMOVE ){  strcpy( cp, "Best  "); cp+=6; }
	if( FIRSTMOVE ){ strcpy( cp, "First "); cp+=6; }
	if( LASTMOVE ){  strcpy( cp, "Last  "); cp+=6; }
	if( cp!=pos+1 ) str[i++]=pos;
	cp=edit+1;
	if( EDITFLAG & ADDMOVE ){  strcpy( cp, "New move  "); cp+=10; }
	if( EDITFLAG & ADDLEVEL ){ strcpy( cp, "New level "); cp+=10; }
	if( EDITFLAG & SAVELEVEL ){   strcpy( cp, "ToSave    "); cp+=10; }
	if( cp!=edit+1 ) str[i++]=edit;
	cp=err+6;
	index=OWNLINK;
	sprintf( buff, " Index in file: %lu  ", index );
	str[i++]=buff;
	if( index ){
		temphelpline(" Search move in file. Pleace Wait...");
		done=getmovedump( dump, index );
		if( done==OK ) str[i++]=dump;
		restorehelpline();
	}
	str[i]=NULL;
	makedialog( str );
	return(0);
}
