/*
	 ͻ
	                Correction  of  edges  and  masks               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <mem.h>    /* NULL */
#include <time.h>   /* clock */
#include "dbchess.h"
#include "dbase.h"
#include "dbproc.h"

#define SQSIZE sizeof(SQUARE_INFO)  /* size of square info in bytes */
				   /* 0   1   2   3   4   5   6   7 */
DIR reverse[NDIR]=  { 4,  5,  6,  7,  0,  1,  2,  3 };
int increment[NDIR]={ 7,  8,  9,  1, -7, -8, -9, -1 };
int knincrement[NDIR]={ 6, 15 , 17, 10, -6, -15, -17, -10 };
int byteshift[NDIR]={ SQSIZE*7, SQSIZE*8, SQSIZE*9, SQSIZE*1,
			  SQSIZE*(-7),SQSIZE*(-8),SQSIZE*(-9),SQSIZE*(-1)};
int knbyteshift[NDIR]={ SQSIZE*6, SQSIZE*15, SQSIZE*17, SQSIZE*10,
			  SQSIZE*(-6),SQSIZE*(-15),SQSIZE*(-17),SQSIZE*(-10)};
MAT_EVAL const piece_cost[NPIECE+1]={ 0, 200, 19, 10, 7, 7, 2 };
/*
PIECE_MASK piece_mask[NPIECE+1];
*/
extern WOOD_SQUARE wood_board[ NSQUARE ];

BYTE npiece[NCOLOR][NPIECE+1]; /* current number of pieces on board */

static void near setedge( void ); /* to set edge on dir */
static void near deledge( void ); /* to clear edge on dir */
static void near setallmask( void ); /* set masks on dir */
static void near setonemask( void );/* set mask on first square */
static void near clearallmask( void );/* to clear all masks on direction */
static void near clearonemask( void );/* to clear one mask on first square */

/* Static variables for use in setedge, deledge, setmask and clearmask */
static SQUARE_NUM Newedge;  /* new edge to set */
static DIR Rdir;            /* direction from edge to main square */
static int Shift;           /* shift in bytes to next square on dir */
static SQUARE_INFO *Sqp,    /* pointer to current square */
	*Forep,                 /* pointer to foreward edge */
	*Backp;                 /* pointer to backward edge */
static DWORD Clmask, Setmask;/* masks to clear and set on current dir */


void near setedge( void )/* to set new edge on dir */
{
  register SQUARE_NUM *src, *dest;

	src=Sqp->edge+Rdir;       /* get pointer for stop */
	dest=Forep->edge+Rdir;    /* get dest */
	while( dest!=src ){      /* moving from dest to source */
		*dest=Newedge;       /* set new edge on dest */
		(char *)dest-=Shift; /* shift to next square */
	}                        /* shift is from src to dest=>'-' */
}

void near deledge( void )/* to clear edge on dir */
{
  SQUARE_NUM newedge;
  register SQUARE_NUM *src, *dest;

	src=Sqp->edge+Rdir;      /* get pointer for stop */
	dest=Forep->edge+Rdir;   /* get dest */
	newedge=*src;            /* get new edge */
	while( dest!=src ){      /* moving from dest to source */
		*dest=newedge;       /* set new edge on dest */
		(char *)dest-=Shift; /* shift to next square */
	}                        /* shift is from src to dest */
}
				 /* set masks on all dir */
void near setallmask( void )
{
  register PIECE_MASK *dest, *src;

	dest=&(Forep->attackedby); /* get dest for mask setting */
	src= &(Sqp->attackedby); /* get source */
	while( dest!=src ){      /* move from dest to source */
		*(DWORD *)dest|=Setmask; /* set new mask */
		(char *)dest-=Shift; /* increment */
	}
}
				 /* set masks to first square on dir */
void near setonemask( void )
{
  register PIECE_MASK *dest;

	dest=&(Sqp->attackedby); /* get pointer to square */
	(char *)dest+=Shift;     /* add shift to next square in bytes */
	*(DWORD *)dest|=Setmask;
}

void near clearallmask( void )
{
  register PIECE_MASK *dest, *src;
  DWORD clearmask;

	dest=&(Forep->attackedby);
	src= &(Sqp->attackedby);
	clearmask=~Clmask;
	while( dest!=src ){
		*(DWORD *)dest&=clearmask; /* clear old mask */
		(char *)dest-=Shift;
	}
}

void near clearonemask( void )
{
  register PIECE_MASK *dest;

	dest=&(Sqp->attackedby);
	(char *)dest+=Shift;     /* add shift to next square in bytes */
	*(DWORD *)dest&=(~Clmask);
}

#define ALL  2               /* how many squares on direction */
#define ONE  1               /* attacked by corresp. piece */
#define NOT  0               /* All squares, only first square or none */
#define B_PAWN 7

BYTE numattack[NPIECE+1+1][NDIR]=
/*              0    1    2    3    4    5    6    7   direction */
/* dummy  */{{ NOT, NOT, NOT, NOT, NOT, NOT, NOT, NOT},
/* king   */ { ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE},
/* queen  */ { ALL, ALL, ALL, ALL, ALL, ALL, ALL, ALL},
/* rook   */ { NOT, ALL, NOT, ALL, NOT, ALL, NOT, ALL},
/* bishop */ { ALL, NOT, ALL, NOT, ALL, NOT, ALL, NOT},
/* knight */ { ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE},
/* W pawn */ { ONE, NOT, ONE, NOT, NOT, NOT, NOT, NOT},
/* B pawn */ { NOT, NOT, NOT, NOT, ONE, NOT, ONE, NOT}};

void piece_down( offset, pname, color, mask )
SQUARE_NUM offset;
PIECE_NAME pname;
PIECE_COLOR color;
DWORD mask;
{
	register int dmask;  /* current direction bit */
	register DIR dir;    /* current direction */
	int rdmask;          /* reverse direction bit */
	BIT_DIR dirmask, kndirmask;
	SQUARE_INFO *sqbasep;    /* square base pointer */
	PIECE_NAME oldname, newname, backname;
	SQUARE_NUM *edgep;       /* pointer to edges of square */
	WOOD_PIECE *wp;
	BYTE *oldattp, *newattp;

	Setmask=mask;            /* new mask to be set */
	Newedge=offset;          /* new edge to be set */
	sqbasep=SQUARE;          /* get the square array base pointer */
	Sqp=sqbasep+offset;      /* get pointer to main square */
	edgep=Sqp->edge;         /* get pointer to edges of this square */
	oldname=Sqp->wood.name;  /* get who stay on square */
	newname=pname;
							 /* wP not equal bP for use in numattack */
	if( pname==PAWN && color==BLACK_PIECE ) newname=B_PAWN;
	if( oldname==PAWN && Sqp->wood.color==BLACK_PIECE ) oldname=B_PAWN;
	dirmask.i=wood_board[ offset ].dirmask; /* get avail dir masks */
	kndirmask.i=wood_board[ offset ].kndirmask; /* get knight avail dir mask */
	oldattp=numattack[oldname]; /* get pointer to array of n attacked sq */
	newattp=numattack[newname]; /* for old and new pieces */

	for( dmask=1, dir=0; dmask<256; dmask<<=1, dir++, oldattp++, newattp++ ){
		if( !( dmask & dirmask.i ) ) continue; /* not available direction */
		Rdir = reverse[ dir ]; /* get reversed dir & save in global var */
		rdmask =1<<Rdir;     /* get reverse dir mask */
		Shift = byteshift[ dir ]; /* get shift to next square in bytes */
		Forep = sqbasep + *( edgep+dir ); /* get fore edge pointer */
		if( oldname ){       /* that is capture */
			if( (*oldattp)!=NOT ){ /* capt'd piece attack this dir */
				Clmask=Sqp->who_mask.dwrd;
				if( oldname==KNIGHT ){ /* if old piece is knight */
					if(dmask & kndirmask.i){  /* dir is avail for kn */
						Shift=knbyteshift[ dir ]; /* get shift for knight */
						clearonemask();           /* clear king mask on dir */
						Shift=byteshift[ dir ]; /* restore shift */
					}
				} else { /* it isn't knight */
					if( *(oldattp)==ALL ) clearallmask();
						else clearonemask();
				}
			}
        } else {             /* that isn't capture */
			if( rdmask & dirmask.i ){ /* reverse dir avail (not edge of board) */
				setedge(); /* set new if not edge of board */
				Backp = sqbasep + *( edgep + Rdir ); /* get back edge pointer */
				backname = Backp->wood.name; /* get piece on back edge */
				if( numattack[backname][dir]==ALL && backname!=KNIGHT ){
					/* back piece attack dir */
					Clmask=Backp->who_mask.dwrd;
					clearallmask();
				}
			}
		}
		if( newname==KNIGHT ) /* if new piece is knight */
			if(dmask & kndirmask.i) Shift=knbyteshift[ dir ]; /* dir is avail for kn */
				else continue;
		if( *(newattp)!=NOT ){ /* new piece attack this dir */
			if( *(newattp)==ALL ) setallmask();
				else setonemask();
		}
	} /* end of dir for */
	Sqp->bound=NOBOUND;    /* ??????? Piece not baund */
	wp=&Sqp->wood;           /* get pointer to wood piece */
	wp->name=pname;
	wp->color=color;
	wp->cost=piece_cost[pname];
	Sqp->who_mask.dwrd=mask;
}

void piece_up( SQUARE_NUM offset )
{
	register int dmask;      /* current direction bit */
	register DIR dir;          /* current direction */
	int rdmask;              /* reverse direction bit */
	int dirmask, kndirmask;  /* available dir masks */
	SQUARE_INFO *sqbasep;    /* square base pointer */
	PIECE_NAME oldname, backname;
	SQUARE_NUM *edgep;
	BYTE *oldattp;
	WOOD_PIECE *wp;

	sqbasep=SQUARE;  /* get square base pointer */
	Sqp=sqbasep+offset;      /* main square pointer */
	oldname=Sqp->wood.name;  /* piece name */
	if( oldname==PAWN && Sqp->wood.color==BLACK_PIECE ) oldname=B_PAWN;
	edgep=Sqp->edge;         /* edges pointer */
	dirmask=wood_board[ offset ].dirmask; /* avail. directions */
	if( oldname==KNIGHT ) kndirmask=wood_board[ offset ].kndirmask;
	oldattp=numattack[oldname]; /* pointer to attack array */
	Clmask=Sqp->who_mask.dwrd;  /* get mask to clear */

	for( dmask=1, dir=0; dmask<256; dmask<<=1, dir++, oldattp++ ){
		if( !( dmask & dirmask ) ) continue; /* not available direction */
		Rdir = reverse[ dir ]; /* get reversed dir */
		rdmask=1<<Rdir;      /* get mask to rev dir */
		Shift = byteshift[ dir ]; /* get shift to next square in bytes */
		Forep = sqbasep + *( edgep + dir ); /* get fore edge pointer */
		if( rdmask & dirmask ){ /* isn't edge of board */
			deledge();       /* delete the old edge */
			Backp = sqbasep + *( edgep + Rdir ); /* get back edge pointer */
			backname = Backp->wood.name; /* get piece on back edge */
			if( numattack[backname][dir]==ALL && backname!=KNIGHT ){
				/* back piece attack dir, back knight can't attack  */
				Setmask=Backp->who_mask.dwrd;
				setallmask();
			}
		}
		if( oldname==KNIGHT ) /* if old piece is knight */
			if(dmask & kndirmask) Shift=knbyteshift[ dir ]; /* dir is avail for kn */
				else continue;
		if( *( oldattp )!=NOT ){        /* piece attack this dir */
			if( *( oldattp )==ALL ) clearallmask();
				else clearonemask();
		}
	} /* end of dir for */
	Sqp->wood.name=NOPIECE;
	wp=&Sqp->wood;           /* get pointer to wood piece */
	wp->name=NOPIECE;
	wp->color=NOCOLOR;
	wp->cost=NOCOST;
	Sqp->who_mask.dwrd=(DWORD)NOMASK;
}

/*
	 ͻ
	                    Initialization of data                      
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#define MIN_XY 0
#define MAX_XY 7
#define ONBOARD(x,y) ( (x)>=MIN_XY && (x)<=MAX_XY && (y)>=MIN_XY && (y)<=MAX_XY )

WOOD_SQUARE wood_board[NSQUARE];   /* !!!!!! */
DIR direction[NSQUARE][NSQUARE];
			/* direction  between two squares */

/* direction  lup up upr r rd dn dl lf  */
int stepx[NDIR]={ -1, 0, 1, 1, 1, 0,-1,-1 };
int stepy[NDIR]={  1, 1, 1, 0,-1,-1,-1, 0 };
/*               upl upr rup rdn dnr dlf lfd lup */
int kn_stepx[NDIR]={ -2, -1,  1,  2,  2,  1, -1, -2 };
int kn_stepy[NDIR]={  1,  2,  2,  1, -1, -2, -2, -1 };

static void near prepare_dir( SQUARE_NUM square )
{
	BYTE dirmask, kndirmask;
	int file, line, x, y;
	register DIR dir, i;

	dirmask=kndirmask=0;
	file=GETFILE( square ); line=GETLINE( square );
	for( dir=0, i=1; dir<NDIR; dir++, i<<=1 ){
		x=file+stepx[dir]; y=line+stepy[dir];
		if( ONBOARD(x,y) ) dirmask|=i;
		x=file+kn_stepx[dir]; y=line+kn_stepy[dir];
		if( ONBOARD(x,y) ) kndirmask|=i;
	}
	wood_board[ square ].dirmask=dirmask;
	wood_board[ square ].kndirmask=kndirmask;
	wood_board[ square ].name[0]='a'+file;
	wood_board[ square ].name[1]='1'+line;
}

void prepare_square( SQUARE_NUM square )
{
	int file, line, x, y;
	SQUARE_NUM edge;
	register DIR dir;

	file=GETFILE( square ); line=GETLINE( square );
	for( dir=0; dir<NDIR; dir++ ){
		x=file+stepx[dir]; y=line+stepy[dir];
		while( ONBOARD(x,y) ){
			x+=stepx[dir]; y+=stepy[dir];
		}
		edge=GETOFFSET( x-stepx[dir], y-stepy[dir] );
		SQUARE[square].edge[dir]=edge;
	}
	SQUARE[square].mynum=square;
	SQUARE[square].wood.color=NOCOLOR;
	SQUARE[square].wood.name=NOPIECE;
	SQUARE[square].wood.cost=NOCOST;
}

static void near prepare_direct(void)
{
  SQUARE_NUM src, dest;
  DIR dir;
  int sfile, sline, dfile, dline, deltax, deltay;
					/* direction  between two squares */
    for(src=a1; src<NSQUARE; src++) {
		sfile=GETFILE(src); sline=GETLINE(src);
		for( dest=a1; dest<NSQUARE; dest++ ){
			if( src==dest ){ direction[src][dest]=NODIR; continue; }
			dfile=GETFILE(dest); dline=GETLINE(dest);
			deltax=dfile-sfile; deltay=dline-sline;
			if( deltax==0 )  /* squares is on one file */
				if( deltay>0 ) dir=_UP; else dir=_DOWN;
			else if( deltay==0 )  /* squares is on one line */
				if( deltax>0 ) dir=_RIGHT; else dir=_LEFT;
			else if( deltax==deltay ) /* squares is on a1-h8 diag. */
				if( deltax>0 ) dir=_RIGHT_UP; else dir=_LEFT_DOWN;
			else if( deltax==-deltay ) /* squares is on a8-h1 diag. */
				if( deltax>0 ) dir=_RIGHT_DOWN; else dir=_LEFT_UP;
			else dir=NODIR;  /* squares isn't on some dir */
			direction[src][dest]=dir;
		}
    }
}

BYTE bit_number[256];			/* Convert byte to bit number */
static void near ini_bit_num(void)
{
  int i;
  int n;
    for(i=0; i<256; i++) bit_number[i]=0;
    for(i=1,n=0; i<256; i*=2,n++) bit_number[i]=n;
}

void prepare( void )
{
	int i;

	for( i=0; i<TOTAL_NUM_PIECE; i++ ){
		PIECE_LIST[i].where=DUMMY;
	}
	for( i=0; i<64; i++ ){
		prepare_dir( i );
		prepare_square( i );
	}
	prepare_direct();
	ini_bit_num();	/* W.K. */
}

