/* 19 sep 90
	 ͻ
	          Converting debut file from short format to full:      
	          Make both horizontal & vertical links.                
	          Use file in old format.                               
	                 programmed  by  Anthon  Dubets                 
	 ͼ
*/

#include <io.h>              /* open().. */
#include <stdio.h>           /* puts(), sprintf() */
#include <conio.h>           /* getch() */
#include <stdlib.h>			 /* exit() */
#include <fcntl.h>           /* open flags */
#include <alloc.h>           /* alloc() */
#include <mem.h>             /* memcpy(), setmem() */
#include <dir.h>             /* findfirst() */
#include <dos.h>             /* file attributes */

#include "dbchess.h"
#include "dbfile.h"
#include "dbase.h"

/*** Format of moves in base file ***********************************
+-----------------------------------------+
| Move num |                              |
| -----------------------------------------
| 0...5    | Title " Kaissa opening book "|
| 6        | Zero move                    |
| 7...     | other moves                  |
+-----------------------------------------+
|      Old debut base file                |
+-----------------------------------------+
| 0        | Zero move                    |
| 1...     | other moves                  |
+-----------------------------------------+
**** Format of moves in base file ***********************************/

#define BITMSIZE  sizeof( BITMOVE )
enum basepiece {
	BITPAWN=0, BITKNIGHT=1, BITBISHOP=2,
	BITROOK=3, BITKING=4,   BITQUEEN=5
};

typedef struct {  /* */
	BYTE b1, b2, b3, b4, b5, b6;
} BITMOVE;

int infh=-1, outfh=-1;  /* input & output file handlers */
char infname[MAXPATH]="",
	 outfname[MAXPATH]=""; /* i&o file names */
void *buff;             /* pointer to buffer */
WORD buffsize;  		/* size of buffer in bytes */
unsigned long movecnt; /* count of transferred moves */
int printflag=0;
					  /* 123456789_123456789_123456789 */
#define TITLEMOVE  5
#define TITLESIZE (sizeof(FILEMOVE)*TITLEMOVE )
char title[ TITLESIZE ]=" Kaissa Opening Book v.1 \x1a";

int near decodebasemove( FILEMOVE *fmp , BITMOVE *bitmp );
char * sprintmove( char *str, FILEMP fmp );

int near openinput( void )
{
	infh=open( infname, O_RDONLY|O_BINARY );
	if( infh==-1 ){
		printf(" Can't open input file: %s.\n", infname );
		return(1);
	}
	return(0);
}

int near openoutput( void )
{
  int i, c;
  struct ffblk blk;          /* file control block structure */
	i=findfirst( outfname, &blk, FA_ARCH ); /* ? what attribute ? */
	if( !i ){
		i=0;
		while( !i ){
			printf("\n File '%s' already exist. Overwrite? (Y/N) ",outfname );
			c=getch();
			if( c=='Y' || c=='y' )
				{ i=1; puts("Yes"); /* unlink( outfname ); */ }
			if( c=='N' || c=='n' )
				{ puts(" Terminated."); return(1); }
		}
	}
	outfh=_creat( outfname, 0 ); /* create/rewrite in binary mode */
	if( outfh==-1 ){
		printf(" Can't open output file: %s.\n", outfname );
		return(1);
	}
	write( outfh, title, TITLESIZE ); /* write title */
	return(0);
}

int near getmem( void )
{
  unsigned int maxmem;
	maxmem=coreleft()-16;    /* get available memory + rezerv for alloc info */
	buffsize=(maxmem/BITMSIZE)*BITMSIZE; /* buffer size in bytes */
	buff=calloc( 1, buffsize ); /* allocate mem for buffsize/inmsize moves */
	if( !buff )
		{ puts(" Can't allocate memory. "); return(-1); }
	return(0);
}

int near decodebasemove( FILEMOVE *fmp , BITMOVE *bitmp )
{
  int bitpiece[6]={ PAWN, KNIGHT, BISHOP, ROOK, KING, QUEEN };
  unsigned int buf=0;
  unsigned long link=0;

/*	FLAG=0; */                   /* clear flags */
	buf=bitmp->b1 & 7;                 /* pname = 0-2 bites in 1 byte */
	if( buf<BITPAWN || buf>BITQUEEN )
		{ /* check error */ }
	FWHO=bitpiece[ buf ];
	if( bitmp->b1 & 0x08 ) FCAPT=1; /* bit 3 is capture */
	if( bitmp->b1 & 0x10 ) FISCHECK=1; /* bit 4 is check */
	if( bitmp->b1 & 0xe0 )                 /* get 4-7 bits (don'n know) */
		{ /* check unknown bits */ }
	buf=bitmp->b2>>2;                      /* square from=0-5 bites from b2 */
	buf = FFROM = GETOFFSET( buf/8, buf%8 ); /* code: b1=8 to b1=1 */
	if( buf<a1 || buf>h8 )
		{ /* check square from */ }
	buf=((bitmp->b2 & 3)<<4) + (bitmp->b3>>4); /* to: 6,7 2b and 0-3 3 byte */
	buf = FTO = GETOFFSET( buf/8, buf%8 ); /* */
	if( buf<a1 || buf>h8 )
		{ /* chech square to */ }
	if( FWHO==PAWN && ( FFROM==FTO )){ /* check castle: piece=0, from=to */
		FWHO=KING;                  /* set new name */
		if( FFROM==h1 ){            /* h1= a8(in old code) */
			FFROM=FTO=h1;            /* this is short castle */
		}
		if( FFROM==h8 ){            /* h8= h8(in old code) */
			FFROM=FTO=a1;   /* this is long castle */
		}                          /* squares from, to undefined */
	}
	if( bitmp->b6 & 0x80 ) FBESTMOVE=1; /* in byte 6: 7 bit=best */
	if( bitmp->b6 & 0x01 ) FLASTMOVE=1; /* 0 bit = is last move */
/*	if( bitmp->b6 & 0x7e ) FLAG |= BYTE6ERR; /* use 1-6 bites ?? */ */

	link=bitmp->b5                   /* get long offset to next level */
		+(((long)bitmp->b4)<<8)
		+(((long)bitmp->b3 & 0xf)<<16);
	if( link!=0 )                    /* vert link exist */
		PUT_VLINK( fmp, link+1 );    /* correct old link to 1 */
	else
		PUT_VLINK( fmp, 0 );         /* no link = last move on branch */
	if( FLASTMOVE )                  /* move is last on level? */
		PUT_HLINK( fmp, 0l );        /* move last - no horiz link */
	else                             /* not last - link to next move   */
		PUT_HLINK( fmp, movecnt+1 ); /* offs to cur move = movecnt =>  */
	return(OK);                      /* offs to next move = movecnt+1  */
}

WORD near readbuff( void )
{
  WORD nbyte;
	nbyte=read( infh, buff, buffsize ); /* read part of file to memory */
	if( nbyte==0xffff )
		{ printf(" Read error from file: %s.\n", infname );  return(-1); }
	return( nbyte );
}

int near writebuff( WORD nmove )
{
  FILEMOVE filemove, *fmp=&filemove;
  BITMOVE  *bitmp;
  char str[MOVESTRLEN+1], s[50], *cp;
  int i;
	bitmp=buff;               /* input move pointer */
	if( !movecnt ){
		setmem( fmp, sizeof( FILEMOVE ), 0x0 );    /* make first null move */
		PUT_VLINK( fmp, 1 );
		i=write( outfh, fmp, sizeof( FILEMOVE ) ); /* write null move to file */
		movecnt++; bitmp++; nmove--;               /* skip first move */
	}
	while( nmove ){
		setmem( fmp, sizeof( FILEMOVE ), 0x0 );
		decodebasemove( fmp, bitmp );
		i=write( outfh, fmp, sizeof( FILEMOVE ) );
		if( i==-1 )
			{ printf(" Write error in file: %s.\n", outfname ); return(-1); }
		bitmp++;
		nmove--;
		movecnt++;
		if( printflag ){
			sprintmove( str, fmp );
			printf(" %7s %6u   ", str, movecnt );
			if( FLASTMOVE ) puts("");
		} else if( !(movecnt%100) ) /* display only x100 moves number */
			printf("\b\b\b\b\b\b\b %6u", movecnt );
	}
	return(0);
}

int near transfer( void )
{
  WORD nbyte;
	movecnt=0;
	printf(" Moves transferred:       "); /* display info string */
	while( !eof( infh ) ){             /* do while not end of file */
		nbyte=readbuff();              /* read buffer from file */
		if( nbyte==0xffff )            /* check n byte readed */
			return(-1);
		writebuff( nbyte/BITMSIZE );    /* convert & write buffer */
	}
	printf("\b\b\b\b\b\b\b %6u ", movecnt );
	return(0);
}

int near help( void )
{
	puts(" Usage: dbconvrt [] srcfile destfile");
	return(0);
}

int near scanargs( int argc, char **argv )
{
  int i, nfname=0;
  char *cp;
	for( i=1; i<argc; i++ ){
		cp=argv[i];
		if( *cp=='-' || *cp=='/' ){ /* this is the keys */
			cp++;
			switch( *cp ){
			  case 'p': case 'P': printflag=1-printflag;
			  break;
			}
			continue;
		}
		if( nfname==0 )
			{ sscanf( cp, "%s", infname ); nfname++; }
		else
			{ sscanf( cp, "%s", outfname ); nfname++; }
	}
	return( nfname );
}

main( argc, argv )
char **argv;
int argc;
{
  int done;

	if( argc>1 )
		done=scanargs( argc, argv );
	else
		{ help(); exit(1); }
	if( done==0 )
		{ help(); exit(1); }
	if( openinput() )
		exit(1);
	if( openoutput() )
		exit(1);
	if( getmem() )
		exit(1);
	transfer();
	if( close( infh ) || close( outfh ) )
		puts(" File close error." );
	else
		puts("Ok");
	return(0);
}

char piecetochar[]={'#','K','Q','R','B','N','P'};

char * sprintsquare( char *str, int square )
{
	*str='a'+square%8;
	*(str+1)='1'+square/8;
	return( str+2 );
}

char * sprintmove( char *str, FILEMP fmp )
{
  char leftcastle[MOVESTRLEN+1]="0-0-0   ";
  char rightcastle[MOVESTRLEN+1]="0-0     ";
  char *cp;
	cp=str;
/*	if( LEFT_CASTLE )
		strcpy( str, leftcastle );
	else if( RIGHT_CASTLE )
		strcpy( str, rightcastle );
	else {*/
		*str++=piecetochar[ FWHO ];
		str=sprintsquare( str, FFROM );
		*str++=( FCAPT )? 'x':'-';
		str=sprintsquare( str, FTO );
		*str++=( FISCHECK )? '+':' ';
	/*	*str++=( FPROM==NOPIECE )? ' ':piecetochar[ movep->prom ];*/
		*str++=' ';  /* isn't promotion in debut */
/*	}*/
	cp+=MOVESTRLEN;
	*cp='\0';
	return( cp );
}
