		/**\
		 	Header file "chess.h"		
		 					
		 		Some chess definitions	
		\**/

#ifndef  _CHESS_H
#define  _CHESS_H

#ifndef  _LANG_H
#include "lang.h"
#endif

	/* Some global constants */


#define TOTAL_NUM_PIECE 32	/* Total number of pieces. */
				  /* White king have # 0 and */
				  /* Black king have # 16 */
#define NUM_PIECE   16		/* Number of pieces of one color */
#define NSQUARE     64		/* Number of squares on a board */
#define NDIR	     8		/* Number of directions */
#define NLINE        8  	/* Number of lines on a board */
#define NFILE        8         	/* Number of files on a board */
#define NPIECE       6		/* Number of different pieces */
#define LINELEN      8		/* Lenght of line or file on a board */
#define FIRSTLINE    0		/* Number of the first line on a board */
#define LASTLINE     7		/* Number of the last line on a board */

	/* Some global types and constants */
typedef BYTE DIR;		/* directions of moving */
typedef enum {
	NODIR=0x00,
	_LEFT_UP   =0x01, _UP  =0x02, _RIGHT_UP =0x04, _RIGHT=0x08,
	_RIGHT_DOWN=0x10, _DOWN=0x20, _LEFT_DOWN=0x40, _LEFT =0x80
} DIRECTIONS;
#define NOBOUND '\xFF'

#define NCOLOR	     2		/* Number of colors */
typedef enum {			/* Define type PIECE_COLOR */
  NOCOLOR=-1,
  WHITE_PIECE = 0,
  BLACK_PIECE = 1
}		  PIECE_COLOR;

typedef enum {			/* Define type PIECE_NAME */
  NOPIECE= 0,
  KING   = 1,
  QUEEN  = 2,
  ROOK   = 3,
  BISHOP = 4,
  KNIGHT = 5,
  PAWN   = 6
}		   PIECE_NAME;

typedef signed int MAT_EVAL;
typedef signed int POS_EVAL;
#define	MAT_INFINITY	997	/* Maximum material evaluation value */
#define POS_INFINITY    0x7FFF	/* Maximum position evaluation value */

typedef enum {
  NOCOST=0,     KING_COST=200,  QUEEN_COST=19,
  ROOK_COST=10, BISHOP_COST=7,  KNIGHT_COST=7,
  PAWN_COST=2
} PIECE_COST;

typedef struct {		/* Define type EVAL for evaluations */
  MAT_EVAL material;			/* Material part */
  POS_EVAL position;			/* Position part */
}		         EVAL;

typedef const struct {		/* Define type WOOD_PIECE */
  PIECE_NAME name;			/* piece name */
  PIECE_COLOR color;			/* color of piece */
  MAT_EVAL cost;			/* piece cost */
  /* int? (*...)( void? ) */    	/* gen func ? */
}		   WOOD_PIECE;

typedef enum {			/* Define type SQUARE NUMber */
  a1,b1,c1,d1,e1,f1,g1,h1,
  a2,b2,c2,d2,e2,f2,g2,h2,
  a3,b3,c3,d3,e3,f3,g3,h3,
  a4,b4,c4,d4,e4,f4,g4,h4,
  a5,b5,c5,d5,e5,f5,g5,h5,
  a6,b6,c6,d6,e6,f6,g6,h6,
  a7,b7,c7,d7,e7,f7,g7,h7,
  a8,b8,c8,d8,e8,f8,g8,h8,
  DUMMY=-1
}	 	 SQUARE_NUM;

typedef struct {		/* Define type PIECE_IN_LIST */
  SQUARE_NUM where;			/* where stay piece */
  /*
  WOOD_PIECE wood;			/* who stay on square "where"*/
  */
}		   PIECE_IN_LIST;

typedef enum {			/* Define type piece LIST NUMber */
  EMPTY_NUM = -1,
  WHITE_KING   =  0,
  WHITE_QUEEN  =  1,
  WHITE_LEFT_ROOK   =  2,  WHITE_RIGHT_ROOK   =  3,
  WHITE_LEFT_BISHOP =  4,  WHITE_RIGHT_BISHOP =  5,
  WHITE_LEFT_KNIGHT =  6,  WHITE_RIGHT_KNIGHT =  7,
  WHITE_PAWN_A =  8, WHITE_PAWN_B =  9,  WHITE_PAWN_C = 10, WHITE_PAWN_D = 11,
  WHITE_PAWN_E = 12, WHITE_PAWN_F = 13,  WHITE_PAWN_G = 14, WHITE_PAWN_H = 15,
  BLACK_KING   = 16,
  BLACK_QUEEN  = 17,
  BLACK_LEFT_ROOK   = 18,  BLACK_RIGHT_ROOK   = 19,
  BLACK_LEFT_BISHOP = 20,  BLACK_RIGHT_BISHOP = 21,
  BLACK_LEFT_KNIGHT = 22,  BLACK_RIGHT_KNIGHT = 23,
  BLACK_PAWN_A = 24, BLACK_PAWN_B = 25,  BLACK_PAWN_C = 26, BLACK_PAWN_D = 27,
  BLACK_PAWN_E = 28, BLACK_PAWN_F = 29,  BLACK_PAWN_G = 30, BLACK_PAWN_H = 31,
}		   LIST_NUM;

typedef struct {		/* Define type MOVE */
  SQUARE_NUM from;			/* move from square */
  SQUARE_NUM to;			/* move  to  square */
  BYTE flags;				/* move flags */
/*  MAT_EVAL profit;			/* capture profit */*/
}			 MOVE;

#define CASTLE_LEFT   0x01
#define CASTLE_RIGHT  0x02
#define EN_PASSANT    0x04
#define CAPTURE       0x08

typedef struct {		/* Type for view masks in TD */
  unsigned int K:1, Q:1, lR:1, rR:1, lB:1, rB:1, lN:1, rN:1;
  unsigned int aP:1, bP:1, cP:1, dP:1, eP:1, fP:1, gP:1, hP:1;
} BIT_MASK;

typedef enum {			/* Define type DEFAULT piece MASK */
  NOMASK = 0,
  KING_MASK =        0x0001, QUEEN_MASK =        0x0002,
  LEFT_ROOK_MASK =   0x0004, RIGHT_ROOK_MASK =   0x0008,
  LEFT_BISHOP_MASK = 0x0010, RIGHT_BISHOP_MASK = 0x0020,
  LEFT_KNIGHT_MASK = 0x0040, RIGHT_KNIGHT_MASK = 0x0080,
  A_PAWN_MASK =      0x0100, B_PAWN_MASK =       0x0200,
  C_PAWN_MASK =      0x0400, D_PAWN_MASK =       0x0800,
  E_PAWN_MASK =      0x1000, F_PAWN_MASK =       0x2000,
  G_PAWN_MASK =      0x4000, H_PAWN_MASK =       0x8000
}  DEFAULT_MASK;

#define ROOK_MASK   ( LEFT_ROOK_MASK | RIGHT_ROOK_MASK)
#define BISHOP_MASK ( LEFT_BISHOP_MASK | RIGHT_BISHOP_MASK)
#define KNIGHT_MASK ( LEFT_KNIGHT_MASK | RIGHT_KNIGHT_MASK)
#define QUEEN_ROOK_MASK   (QUEEN_MASK | ROOK_MASK)
#define QUEEN_BISHOP_MASK (QUEEN_MASK | BISHOP_MASK)
#define BISHOP_KNIGHT_MASK  (BISHOP_MASK | KNIGHT_MASK)
#define PAWN_MASK   0xFF00

typedef union {			/* Define type PIECE MASK */
  DWORD dwrd;
  WORD word[NCOLOR];
  BYTE byte[NCOLOR][2];
  BIT_MASK bit[NCOLOR];
}                 PIECE_MASK;

typedef struct {           	/* Define type WOOD_SQUARE */
  char name[3];            		/* name of square */
  BYTE dirmask;          		/* available direction bits for queen */
  BYTE kndirmask;        		/* available direction bits for knight */
} 		WOOD_SQUARE;

typedef struct {		/* Define type SQUARE_INFO */
  SQUARE_NUM edge[NDIR];		/* edges for all directions */
  PIECE_MASK attackedby;		/* who attacks this square */
  WORD moves;				/* mask of written moves to this square */
  WOOD_PIECE wood;			/* who is on square */
  PIECE_MASK who_mask;			/* "who is on square" mask */
  DIR        bound;			/* can't leave this direction */
  SQUARE_NUM mynum;                     /* number of this square */
}		SQUARE_INFO;

typedef int CASTLES;
#define CASTLELEFT 8
#define CASTLERIGHT 4
#define CASTLELEFTDONE 2
#define CASTLERIGHTDONE 1 /* M.D. */

#define FORCED 	      0x0001
#define WITHOUT_CHECK 0x0002
#define VARIANT       0x0004

typedef enum {			/* Define type GENerator STATUS */
  NORMAL      = 0,
  FORCED_MOVE               = FORCED,
  FORCED_WITHOUT_CHECK      = FORCED|VARIANT|WITHOUT_CHECK,
  FORCED_VARIANT            = FORCED|VARIANT,
  FORCED_MOVE_WITHOUT_CHECK = FORCED|WITHOUT_CHECK
}		   GEN_STATUS;


typedef enum {				/* Define type PARTY_STATUS */
  DEBUT=1,
  MIDDLEGAME=2,
  ENDGAME=4,
  CHECKMATE=8
} PARTY_STATUS;

typedef struct  {		/* Define type POSITION -- */
				  /* position stack element type */
  SQUARE_INFO square[NSQUARE];		/* Square information */
  PIECE_IN_LIST piece_list[TOTAL_NUM_PIECE];	/* Piece list */
  PIECE_MASK piece_mask[NPIECE+1];  /* Group masks for all piece +NOPIECE */
  CASTLES castle[NCOLOR];		/* Available and done castles */
  BYTE npospiece[NCOLOR][NPIECE+1];
/*  MOVE *first, *last;			/* First & last moves */
  MOVE *current;			/* Current move */*/
  BYTE check;				/* Check state indicator (king square attack number) */
  PIECE_COLOR move_color;		/* Color of moved piece */
  SQUARE_NUM en_pass;			/* En passant captured pawn square */
} POSITION;

#define SQUARE      posp->square		/* square information */
#define PIECE_LIST  posp->piece_list 	/* Piece list */
#define PIECE_MASKS posp->piece_mask		/* piece masks */
#define MOVES       posp->moves		/* piece masks */
#define CASTLE      posp->castle		/* available & done castles */
/*#define FIRST       posp->first
#define LAST        posp->last			/* first & last moves */
#define PREVIOUS    posp->previous		/* previous move */*/
#define MOVE_COLOR  posp->move_color		/* color of moved piece */
#define EN_PASS     posp->en_pass 		/* en passant captured pawn square */
#define CHECK       posp->check			/* check state indicator */
#define NPOSPIECE   posp->npospiece

typedef struct {
  unsigned int leftup:1, up:1, uprght:1, right:1,
	rghtdn:1, down:1, dnleft:1, left:1/*, unuse:8*/;
} B_DIR;
typedef union {
  BYTE i;
  B_DIR bd;
} BIT_DIR;
/* Directions
   knight
	1    2
 0  	    3
	  *
 7          4
	6    5

  not knight
	  1
   0     2
 7    *    3
   6     4
	  5
*/

#endif
