/*
	 ͻ
	          Main definitions & data types for Debut Base          
	                 programmed  by  Anthon  Dubets                 
	                 supported by  Michael  Karayev                 
	 ͼ
*/

#ifndef _LANG_H
#include "lang.h"
#endif

#ifndef _CHESS_H
#include "dbchess.h"
#endif

#define OK          0
#define ERROR      -1
#define MOVESTRLEN  8            /* size of move string */
#define TMPFILE 1

#undef FIRST       /* This identifiers already used in FACE */
#undef CURRENT     /* */
#undef NEXT        /* */
#undef TOSAVE

typedef struct basemove { /* Define type of moves in memory */
  BYTE who;
  BYTE from, to;
  WORD capt:1, check:1,           /* flags: move is capture, check, */
	   lcastle:1, rcastle:1,      /* move is right or left castle */
	   en_pass:1,                  /* move is en passant */
	   first:1, last:1, best:1,   /* first, last, best on level */
	   flags:8;                   /* editor flags */
  long hlink, vlink, ownlink;    /* horiz, vert links & own index */
  struct basemove *next;          /* point to next level in memory */
} BASEMOVE;

typedef BASEMOVE * BASEMP; /* may be far ?? */

#define FROM      bmp->from
#define TO        bmp->to
#define WHO       bmp->who
#define CAPT      bmp->capt
#define ISCHECK   bmp->check
#define IS_ENPASS bmp->en_pass
#define LASTMOVE  bmp->last
#define BESTMOVE  bmp->best
#define FIRSTMOVE bmp->first
#define NEXT      bmp->next
#define LEFT_CASTLE  bmp->lcastle
#define RIGHT_CASTLE bmp->rcastle
#define EDITFLAG   bmp->flags
	/* Define operation for get */
	/* vertical/horizontal links with seg:offs */
/*
#define VLINK      (((unsigned long)( bmp->vlseg )<<16) \
					|(unsigned)( bmp->vloffs ))

#define HLINK      (((unsigned long)( bmp->hlseg )<<16) \
					|(unsigned)( bmp->hloffs ))

#define OWN_NUM    (((unsigned long)( bmp->ownseg )<<16) \
					|(unsigned)( bmp->ownoffs ))
*/
#define VLINK      bmp->vlink
#define HLINK      bmp->hlink
#define OWNLINK    bmp->ownlink

		/* editor flags */
#define ADDMOVE  0x01        /* add new move to end of level */
#define DELMOVE  0x02        /* delete one move from level (nmove>1) */
#define ADDLEVEL 0x04        /* add new level */
#define DELLEVEL 0x08        /* del whole level or level with one move */
#define REWRITE  0x10        /* overwrite current move */
#define OWNSTACK 0x40        /* level loaded by stack: 0-first 1-second */
#define SAVELEVEL 0x80        /* this level must be saved */

typedef struct {
	BASEMP first, last;
	BASEMP current;
	signed char curnum;
	MOVE curmove;
	BASEMOVE curbmove;
	MOVE *mfirst, *mlast, *mcurrent;
} BASEPOS;

#define BPFIRST   basesp->first
#define BPLAST    basesp->last
#define BPCURRENT basesp->current
#define BPCURNUM  basesp->curnum
#define CURMOVE   basesp->curmove			/* current move */
#define CURBMOVE  basesp->curbmove			/* current base move */
#define MFIRST    basesp->mfirst
#define MLAST     basesp->mlast
#define MCURRENT  basesp->mcurrent

#define LINELEN 8
#define SQISWHITE( square ) (((square)%8-(square)/8)%2!=0) /* check square color */
#define GETOFFSET( file, line ) ( LINELEN*(line) + (file) )
#define GETFILE( offset )   ( (offset) % LINELEN )
#define GETLINE( offset )   ( (offset) / LINELEN )
#define REVCOLOR( color )   ( 1-(color) )
#define KING_INDEX( color ) ( color*NUM_PIECE )
#define HALF(i)             ((i)>>1)
#define setmask( var, mask ) ( (var) |= (mask) )
#define clearmask( var, mask ) ( (var) &= ~(mask) )

typedef struct {
  POSITION *posp;
  int level;
  BASEPOS *bp, *sp;
  MOVE *movebp;
} STACKINFO;

extern POSITION *posp;       /* current chess position pointer */
extern BASEPOS *basesp;      /* main base pointer */
extern int level;            /* levels for current stack */
extern BASEMOVE nullmove;    /* move with flags for first move */
extern STACKINFO stkinfo[];  /* information about stacks */
extern int stacknum;         /* current stack number */
extern int add_move, del_move,add_level;/*counters add/del move & */
						/* add level*/
extern int tosave;           /* if 1 base must be saved */
